/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.sqlite;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.SqliteDialect;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.vendors.DefinitionProviderImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class SqliteDefinitionProvider
extends DefinitionProviderImpl {
    public static final SqliteDefinitionProvider INSTANCE = new SqliteDefinitionProvider();

    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            SqliteDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.VIEW || kind == ObjectKind.TABLE || kind == ObjectKind.VIRTUAL_TABLE || kind == ObjectKind.TRIGGER || kind == ObjectKind.INDEX;
    }

    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection, @NotNull PairConsumer<DasObject, Object> consumer) throws Exception {
        if (objects == null) {
            SqliteDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            SqliteDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            SqliteDefinitionProvider.$$$reportNull$$$0(3);
        }
        for (DasObject dasObject : objects) {
            PreparedStatement statement = connection.prepareStatement(SqliteDefinitionProvider.getQuery(dasObject));
            Throwable throwable = null;
            try {
                statement.setString(1, dasObject.getName());
                try {
                    ResultSet rs = statement.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        consumer.consume((Object)dasObject, !rs.next() ? null : rs.getString(1));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    consumer.consume((Object)dasObject, (Object)e);
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                statement.close();
            }
        }
    }

    private static String getQuery(@NotNull DasObject obj) {
        if (obj == null) {
            SqliteDefinitionProvider.$$$reportNull$$$0(4);
        }
        SqliteDialect dialect = SqliteDialect.INSTANCE;
        ObjectKind kind = obj.getKind();
        if (kind == ObjectKind.VIRTUAL_TABLE) {
            kind = ObjectKind.TABLE;
        }
        StringBuilder res = new StringBuilder("SELECT sql FROM ");
        String schema = DasUtil.getSchema((DasObject)obj);
        if (StringUtil.isNotEmpty((String)schema)) {
            res.append(dialect.quoteIdentifier(schema, true, false)).append(".");
        }
        res.append("sqlite_master WHERE name=? AND type='").append(kind.code()).append("'");
        return res.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/vendors/sqlite/SqliteDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getQuery";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

