/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.openapi.fileTypes.UserBinaryFileType;
import icons.DatabaseIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class DbStorageFileType
extends UserBinaryFileType {
    @NotNull
    public String getName() {
        String string = this.getDatabaseName() + " Database";
        if (string == null) {
            DbStorageFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.getDatabaseName() + " Database File";
        if (string == null) {
            DbStorageFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Icon getIcon() {
        return DatabaseIcons.Dbms;
    }

    @NotNull
    public abstract String getDatabaseName();

    public boolean isReadOnly() {
        return true;
    }

    @NotNull
    abstract String getFilePrefix();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/vfs/DbStorageFileType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class H2Storage
    extends DbStorageFileType {
        public static final H2Storage INSTANCE = new H2Storage();

        @NotNull
        public String getDefaultExtension() {
            if ("h2.db" == null) {
                H2Storage.$$$reportNull$$$0(0);
            }
            return "h2.db";
        }

        @Override
        @NotNull
        public String getDatabaseName() {
            if ("H2" == null) {
                H2Storage.$$$reportNull$$$0(1);
            }
            return "H2";
        }

        @Override
        @NotNull
        String getFilePrefix() {
            if ("-- H2 0.5/B --" == null) {
                H2Storage.$$$reportNull$$$0(2);
            }
            return "-- H2 0.5/B --";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/vfs/DbStorageFileType$H2Storage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultExtension";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDatabaseName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePrefix";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class SqliteStorage
    extends DbStorageFileType {
        public static final SqliteStorage INSTANCE = new SqliteStorage();

        @Override
        @NotNull
        public String getDatabaseName() {
            if ("SQLite" == null) {
                SqliteStorage.$$$reportNull$$$0(0);
            }
            return "SQLite";
        }

        @Override
        @NotNull
        String getFilePrefix() {
            if ("SQLite format " == null) {
                SqliteStorage.$$$reportNull$$$0(1);
            }
            return "SQLite format ";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/vfs/DbStorageFileType$SqliteStorage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDatabaseName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePrefix";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

