/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.EscapeSequenceTokenizer;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlStringLiteralEscaper;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import org.jetbrains.annotations.NotNull;

public class SqlSpellcheckingStrategy
extends SpellcheckingStrategy {
    private static final Tokenizer DEFINITION_TOKENIZER = new MyDefinitionTokenizer();
    private static final Tokenizer STRING_TOKENIZER = new StringTokenizer();

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        IElementType nodeType;
        IElementType iElementType = nodeType = element instanceof LeafPsiElement ? ((LeafPsiElement)element).getElementType() : null;
        if (nodeType == SqlTokens.SQL_STRING_TOKEN) {
            Tokenizer tokenizer = STRING_TOKENIZER;
            if (tokenizer == null) {
                SqlSpellcheckingStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        if (nodeType == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            Tokenizer tokenizer = TEXT_TOKENIZER;
            if (tokenizer == null) {
                SqlSpellcheckingStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        if (element instanceof SqlAsExpression) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                SqlSpellcheckingStrategy.$$$reportNull$$$0(2);
            }
            return tokenizer;
        }
        if (element instanceof SqlDefinition) {
            Tokenizer tokenizer = DEFINITION_TOKENIZER;
            if (tokenizer == null) {
                SqlSpellcheckingStrategy.$$$reportNull$$$0(3);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            SqlSpellcheckingStrategy.$$$reportNull$$$0(4);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlSpellcheckingStrategy", "getTokenizer"));
    }

    private static class StringTokenizer
    extends EscapeSequenceTokenizer<SqlStringTokenElement> {
        private StringTokenizer() {
        }

        public void tokenize(@NotNull SqlStringTokenElement element, TokenConsumer consumer) {
            PsiElement parent;
            if (element == null) {
                StringTokenizer.$$$reportNull$$$0(0);
            }
            if ((parent = element.getParent()) instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)parent))) {
                return;
            }
            String text2 = element.getText();
            if (!text2.contains("\\") || !SqlStringLiteralEscaper.supportsSlashEscapes(element, text2)) {
                TextRange range = element.getRangeInElement();
                consumer.consumeToken((PsiElement)element, text2, false, 0, range, (Splitter)PlainTextSplitter.getInstance());
            } else {
                StringBuilder unescapedText = new StringBuilder();
                int[] offsets = new int[text2.length() + 1];
                CodeInsightUtilCore.parseStringCharacters((String)text2, (StringBuilder)unescapedText, (int[])offsets);
                StringTokenizer.processTextWithOffsets((PsiElement)element, (TokenConsumer)consumer, (StringBuilder)unescapedText, (int[])offsets, (int)1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlSpellcheckingStrategy$StringTokenizer", "tokenize"));
        }
    }

    private static class MyDefinitionTokenizer
    extends Tokenizer<SqlDefinition> {
        private MyDefinitionTokenizer() {
        }

        public void tokenize(@NotNull SqlDefinition element, TokenConsumer consumer) {
            if (element == null) {
                MyDefinitionTokenizer.$$$reportNull$$$0(0);
            }
            for (SqlIdentifier identifier : PsiTreeUtil.findChildrenOfType((PsiElement)element.getNameElement(), SqlIdentifier.class)) {
                int start;
                String text2;
                if (identifier == null) {
                    return;
                }
                if (identifier.getTextRange().isEmpty()) {
                    return;
                }
                int stop = text2.length();
                for (start = StringUtil.startsWithIgnoreCase((String)(text2 = identifier.getText()), (String)"u&") ? 2 : 0; !(start >= stop || Character.isLetter(text2.charAt(start)) && text2.charAt(start) != '@'); ++start) {
                }
                while (stop > start && !Character.isLetter(text2.charAt(stop - 1))) {
                    --stop;
                }
                if (stop <= start) continue;
                consumer.consumeToken((PsiElement)identifier, text2, true, 0, TextRange.from((int)start, (int)(stop - start)), (Splitter)IdentifierSplitter.getInstance());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlSpellcheckingStrategy$MyDefinitionTokenizer", "tokenize"));
        }
    }
}

