/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result checkAutoPopup(char c, Project project, @NotNull Editor editor, PsiFile file) {
        if (editor == null) {
            SqlTypedHandler.$$$reportNull$$$0(0);
        }
        if (!(file instanceof SqlFile)) {
            return super.checkAutoPopup(c, project, editor, file);
        }
        if (c == ' ' || c == '(') {
            PsiElement at;
            int offset = editor.getCaretModel().getOffset();
            PsiElement psiElement = at = offset > 0 ? file.findElementAt(offset - 1) : null;
            if (SqlTypedHandler.goodFor(at, c)) {
                AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return super.checkAutoPopup(c, project, editor, file);
    }

    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            SqlTypedHandler.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            SqlTypedHandler.$$$reportNull$$$0(2);
        }
        if (file == null) {
            SqlTypedHandler.$$$reportNull$$$0(3);
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE || !(file instanceof SqlFile) || c == '\'' || c == '\"' || c == '`') {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        if (c != '$' && (offset < 2 || document.getCharsSequence().charAt(offset - 2) != '\'')) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        MultiCharQuoteHandler quoteHandler = (MultiCharQuoteHandler)ObjectUtils.tryCast((Object)TypedHandler.getQuoteHandler((PsiFile)file, (Editor)editor), MultiCharQuoteHandler.class);
        if (quoteHandler == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        CharSequence closingQuote = quoteHandler.getClosingQuote(highlighter.createIterator(offset), offset);
        if (closingQuote == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!quoteHandler.hasNonClosedLiteral(editor, highlighter.createIterator(offset - 1), offset - 1)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (offset == document.getTextLength() || !Character.isUnicodeIdentifierPart(document.getCharsSequence().charAt(offset))) {
            document.insertString(offset, closingQuote);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        if (!(file instanceof SqlFile)) {
            TypedHandlerDelegate.Result result2 = super.beforeCharTyped(c, project, editor, file, fileType);
            if (result2 == null) {
                SqlTypedHandler.$$$reportNull$$$0(4);
            }
            return result2;
        }
        if (c == ']') {
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            boolean transactFamily = dialect.getFamilyId().isTransactSql();
            int offset = editor.getCaretModel().getOffset();
            String text2 = editor.getDocument().getText();
            if (transactFamily && offset < text2.length() && c == text2.charAt(offset)) {
                EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.STOP;
                if (result3 == null) {
                    SqlTypedHandler.$$$reportNull$$$0(5);
                }
                return result3;
            }
        }
        TypedHandlerDelegate.Result result4 = super.beforeCharTyped(c, project, editor, file, fileType);
        if (result4 == null) {
            SqlTypedHandler.$$$reportNull$$$0(6);
        }
        return result4;
    }

    private static boolean goodFor(@Nullable PsiElement element, char c) {
        PsiElement prev;
        if (!(element instanceof LeafPsiElement)) {
            return false;
        }
        IElementType type = ((LeafPsiElement)element).getElementType();
        PsiElement parent = element.getParent();
        if (c == ' ') {
            if (type == SqlCommonKeywords.SQL_WHERE && parent instanceof SqlWhereClause) {
                return true;
            }
            if (type == SqlCommonKeywords.SQL_FROM && parent instanceof SqlFromClause) {
                return true;
            }
            if (type == SqlCommonKeywords.SQL_ON && parent instanceof SqlJoinConditionClause) {
                return true;
            }
            if (type == SqlCommonKeywords.SQL_JOIN && parent instanceof SqlJoinExpression) {
                return true;
            }
        }
        return c == '(' && PsiTreeUtil.getParentOfType((PsiElement)(prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)element)), SqlTableColumnsList.class) != null && PsiTreeUtil.getParentOfType((PsiElement)prev, SqlInsertStatement.class) != null && PsiTreeUtil.getParentOfType((PsiElement)prev, SqlReferenceList.class) == null && PsiTreeUtil.getParentOfType((PsiElement)element, SqlReferenceList.class) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

