/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mysql.MysqlElementTypes;
import com.intellij.sql.dialects.mysql.MysqlOptionalKeywords;
import com.intellij.sql.dialects.mysql.MysqlReservedKeywords;
import com.intellij.sql.dialects.mysql.MysqlTokens;
import com.intellij.sql.dialects.mysql.MysqlTypes;
import com.intellij.sql.dialects.mysql.psi.MysqlDelimiterStatementImpl;
import com.intellij.sql.dialects.mysql.psi.MysqlShowStatementImpl;
import com.intellij.sql.dialects.mysql.refactoring.MysqlExtractVariableHelper;
import com.intellij.sql.dialects.sql92.Sql92ReservedKeywords;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlDialect
extends SqlLanguageDialectEx {
    public static final MysqlDialect INSTANCE = new MysqlDialect();

    public MysqlDialect() {
        super("MySQL");
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "Geometry", "geometry", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "JSON", "json", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "Point", "point", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "Curve", "curve", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "LineString", "linestring", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "Line", "line", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "LinearRing", "linearring", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "Surface", "surface", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "Polygon", "polygon", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "GeometryCollection", "geometrycollection", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "MultiPoint", "multipoint", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "MultiCurve", "multicurve", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "MultiLineString", "Multilinestring", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "MultiSurface", "multisurface", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "MultiPolygon", "multipolygon", (SqlLanguageDialectEx)this);
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.MysqlDialect mysqlDialect = com.intellij.database.dialects.MysqlDialect.INSTANCE;
        if (mysqlDialect == null) {
            MysqlDialect.$$$reportNull$$$0(0);
        }
        return mysqlDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map2 = LazyData.ourFunctionMap;
        if (map2 == null) {
            MysqlDialect.$$$reportNull$$$0(1);
        }
        return map2;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(MysqlTokens.class);
        if (set == null) {
            MysqlDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            MysqlDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        MysqlShowStatementImpl showStatement;
        Pair<IElementType, IElementType> type;
        ReservedEntity.Typed[] cols;
        if (element == null) {
            MysqlDialect.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            MysqlDialect.$$$reportNull$$$0(5);
        }
        if (!MysqlDialect.processReservedEntitiesWithTypeDual(name, element, resolve, processor)) {
            return false;
        }
        SqlStatement stmt = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
        if (stmt instanceof MysqlShowStatementImpl && (cols = LazyData.RE_SHOW_COLUMNS_BY_TYPE.get(type = (showStatement = (MysqlShowStatementImpl)stmt).getShowType())) != null) {
            for (ReservedEntity.Typed col : cols) {
                if (MysqlDialect.processReservedEntitiesWithTypeSimple(col, col.type, name, element, resolve, processor, true, false)) continue;
                return false;
            }
        }
        return super.processReservedEntitiesWithType(name, element, resolve, processor);
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        DasNamespace namespace = MysqlDialect.getDefaultNamespace(dataSource, null);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, (TreePatternNode.Group[])null);
            if (treePattern == null) {
                MysqlDialect.$$$reportNull$$$0(6);
            }
            return treePattern;
        }
        String dbname = SqlDialectImplUtil.getDatabaseName(SqlImportUtil.getConnectionConfig(dataSource));
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.createNodeIfNotNull(ObjectName.quoted((String)dbname), ObjectKind.SCHEMA, new TreePatternNode.Group[0])));
        if (treePattern == null) {
            MysqlDialect.$$$reportNull$$$0(7);
        }
        return treePattern;
    }

    @Override
    public boolean isVariablePrefix(@Nullable String prefix) {
        return "@".equals(prefix) || "@@".equals(prefix);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public boolean isAutoIncrementColumn(@NotNull DasColumn column) {
        if (column == null) {
            MysqlDialect.$$$reportNull$$$0(8);
        }
        if (super.isAutoIncrementColumn(column)) {
            return true;
        }
        String type = column.getDataType().getSpecification();
        return StringUtil.equalsIgnoreCase((CharSequence)type, (CharSequence)"serial");
    }

    @Override
    @NotNull
    public String getDelimiterAt(@NotNull SqlFile file, int offset) {
        if (file == null) {
            MysqlDialect.$$$reportNull$$$0(9);
        }
        String result2 = null;
        if (offset > 0) {
            for (MysqlDelimiterStatementImpl delimiter : SqlImplUtil.iterarateStatementsBackward((PsiFile)file, offset).filter(MysqlDelimiterStatementImpl.class)) {
                if (delimiter.getDelimiter() == null) continue;
                result2 = delimiter.getDelimiter();
                break;
            }
        }
        if (result2 == null) {
            String string = super.getDelimiterAt(file, offset);
            if (string == null) {
                MysqlDialect.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            MysqlDialect.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new MysqlExtractVariableHelper();
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            MysqlDialect.$$$reportNull$$$0(12);
        }
        return !this.getKeywords().contains(ref);
    }

    @Override
    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element) {
        if (element == null) {
            MysqlDialect.$$$reportNull$$$0(13);
        }
        return element == SqlCompositeElementTypes.SQL_STRING_LITERAL || element == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || element == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    public boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            MysqlDialect.$$$reportNull$$$0(14);
        }
        return kind == ObjectKind.TRIGGER;
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            MysqlDialect.$$$reportNull$$$0(15);
        }
        switch (cat) {
            case INTEGER: {
                return "int";
            }
            case REAL: {
                return "decimal";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "tinyint";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "binary";
            }
            case ARRAY: {
                return "binary";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            MysqlDialect.$$$reportNull$$$0(16);
        }
        name = super.getNormalizedTypeName(name);
        name = StringUtil.trimStart((String)name, (String)"national ");
        name = StringUtil.trimEnd((String)name, (String)" zerofill");
        name = StringUtil.trimEnd((String)name, (String)" signed");
        if ((name = StringUtil.trimEnd((String)name, (String)" unsigned")).equals("nchar varying")) {
            if ("varchar" == null) {
                MysqlDialect.$$$reportNull$$$0(17);
            }
            return "varchar";
        }
        if (name.equals("nvarchar")) {
            if ("varchar" == null) {
                MysqlDialect.$$$reportNull$$$0(18);
            }
            return "varchar";
        }
        if (name.equals("nchar")) {
            if ("char" == null) {
                MysqlDialect.$$$reportNull$$$0(19);
            }
            return "char";
        }
        if (name.equals("character varying")) {
            if ("varchar" == null) {
                MysqlDialect.$$$reportNull$$$0(20);
            }
            return "varchar";
        }
        if (name.equals("char varying")) {
            if ("varchar" == null) {
                MysqlDialect.$$$reportNull$$$0(21);
            }
            return "varchar";
        }
        if (name.equals("character")) {
            if ("char" == null) {
                MysqlDialect.$$$reportNull$$$0(22);
            }
            return "char";
        }
        if (name.equals("long")) {
            if ("mediumtext" == null) {
                MysqlDialect.$$$reportNull$$$0(23);
            }
            return "mediumtext";
        }
        if (name.equals("integer")) {
            if ("int" == null) {
                MysqlDialect.$$$reportNull$$$0(24);
            }
            return "int";
        }
        if (name.equals("boolean")) {
            if ("tinyint" == null) {
                MysqlDialect.$$$reportNull$$$0(25);
            }
            return "tinyint";
        }
        if (name.equals("bool")) {
            if ("tinyint" == null) {
                MysqlDialect.$$$reportNull$$$0(26);
            }
            return "tinyint";
        }
        if (name.equals("dec")) {
            if ("decimal" == null) {
                MysqlDialect.$$$reportNull$$$0(27);
            }
            return "decimal";
        }
        if (name.equals("numeric")) {
            if ("decimal" == null) {
                MysqlDialect.$$$reportNull$$$0(28);
            }
            return "decimal";
        }
        if (name.equals("fixed")) {
            if ("decimal" == null) {
                MysqlDialect.$$$reportNull$$$0(29);
            }
            return "decimal";
        }
        if (name.equals("double precision")) {
            if ("double" == null) {
                MysqlDialect.$$$reportNull$$$0(30);
            }
            return "double";
        }
        if (name.equals("real")) {
            if ("double" == null) {
                MysqlDialect.$$$reportNull$$$0(31);
            }
            return "double";
        }
        String string = name;
        if (string == null) {
            MysqlDialect.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Override
    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref) {
        if (processor == null) {
            MysqlDialect.$$$reportNull$$$0(33);
        }
        if (state == null) {
            MysqlDialect.$$$reportNull$$$0(34);
        }
        if (ref == null) {
            MysqlDialect.$$$reportNull$$$0(35);
        }
        if (processor.isExpected(MysqlElementTypes.Extra.USER_VARIABLE)) {
            SqlFileImpl sqlFile;
            PsiFile file = ref.getElement().getContainingFile();
            if (file != null) {
                file = (PsiFile)ObjectUtils.chooseNotNull((Object)file.getOriginalFile(), (Object)file);
            }
            if ((sqlFile = (SqlFileImpl)((Object)ObjectUtils.tryCast((Object)file, SqlFileImpl.class))) != null) {
                for (SqlReferenceExpression expression : MysqlDialect.getGlobalVariables(sqlFile)) {
                    if (processor.execute((PsiElement)expression, state)) continue;
                    return false;
                }
            }
            if (processor.referenceName != null && !processor.isExpected(SqlDbElementType.ANY)) {
                return false;
            }
        }
        return super.processUnqualifiedResolve(processor, state, ref);
    }

    @NotNull
    public static List<SqlReferenceExpression> getGlobalVariables(@NotNull SqlFile file) {
        if (file == null) {
            MysqlDialect.$$$reportNull$$$0(36);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            if (file == null) {
                MysqlDialect.$$$reportNull$$$0(41);
            }
            return CachedValueProvider.Result.create(MysqlDialect.calcGlobalVariables((SqlFileImpl)file), (Object[])new Object[]{file});
        });
        if (list == null) {
            MysqlDialect.$$$reportNull$$$0(37);
        }
        return list;
    }

    @NotNull
    private static List<SqlReferenceExpression> calcGlobalVariables(SqlFileImpl file) {
        SqlLanguageDialectEx language = file.getSqlLanguage();
        if (!language.getFamilyId().isMysql() || file.getStub() != null) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                MysqlDialect.$$$reportNull$$$0(38);
            }
            return list;
        }
        HashMap gradedVariables = ContainerUtil.newHashMap();
        for (SqlReferenceExpression ref : SqlImplUtil.sqlTraverser((PsiElement)file).filter(SqlReferenceExpression.class)) {
            String prefix;
            if (ref.getReferenceElementType() != MysqlElementTypes.Extra.MYSQL_USER_VARIABLE_REFERENCE) continue;
            SqlIdentifier identifier = ref.getIdentifier();
            String string = prefix = identifier == null ? null : identifier.getNamePrefix();
            if (!language.isVariablePrefix(prefix)) continue;
            int grade = MysqlDialect.getVariableReferenceGrade(ref);
            String name = ref.getName();
            Pair old = (Pair)gradedVariables.get(name);
            if (old != null && grade >= (Integer)old.second) continue;
            gradedVariables.put(name, Pair.create((Object)ref, (Object)grade));
        }
        List list = ContainerUtil.map2List(gradedVariables.values(), val -> (SqlReferenceExpression)val.first);
        if (list == null) {
            MysqlDialect.$$$reportNull$$$0(39);
        }
        return list;
    }

    private static int getVariableReferenceGrade(@NotNull SqlReferenceExpression ref) {
        if (ref == null) {
            MysqlDialect.$$$reportNull$$$0(40);
        }
        int grade = 0;
        boolean insideRoutine = PsiTreeUtil.getParentOfType((PsiElement)ref, SqlCreateProcedureStatement.class) != null;
        SqlSetAssignment assignment = (SqlSetAssignment)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlSetAssignment.class);
        if (assignment != null && assignment.getLValue() == ref) {
            return insideRoutine ? grade + 1 : grade;
        }
        grade += 2;
        SqlBinaryExpression expr = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlBinaryExpression.class);
        if (expr != null && expr.getLOperand() == ref && (expr.getOpSign() == SqlTokens.SQL_OP_ASSIGN || expr.getOpSign() == SqlTokens.SQL_OP_EQ)) {
            return insideRoutine ? grade + 1 : grade;
        }
        return insideRoutine ? grade + 1 : (grade += 2);
    }

    static /* synthetic */ SqlType access$000(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$100(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$200(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$300(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$400(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$500(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$600(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$700(MysqlDialect x0) {
        return x0.DATE_TIME;
    }

    static /* synthetic */ SqlType access$800(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$900(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$1000(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$1100(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$1200(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$1300(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$1400(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$1500(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$1600(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$1700(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$1800(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$1900(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$2000(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$2100(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$2200(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$2300(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$2400(MysqlDialect x0) {
        return x0.DATE_TIME;
    }

    static /* synthetic */ SqlType access$2500(MysqlDialect x0) {
        return x0.DATE_TIME;
    }

    static /* synthetic */ SqlType access$2600(MysqlDialect x0) {
        return x0.DATE_TIME;
    }

    static /* synthetic */ SqlType access$2700(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$2800(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$2900(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$3000(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$3100(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$3200(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$3300(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$3400(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$3500(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$3600(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$3700(MysqlDialect x0) {
        return x0.DATE_TIME;
    }

    static /* synthetic */ SqlType access$3800(MysqlDialect x0) {
        return x0.DATE_TIME;
    }

    static /* synthetic */ SqlType access$3900(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$4000(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$4100(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$4200(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$4300(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$4400(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$4500(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$4600(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$4700(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$4800(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$4900(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$5000(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$5100(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$5200(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$5300(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$5400(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$5500(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$5600(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$5700(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$5800(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$5900(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$6000(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$6100(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$6200(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$6300(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$6400(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$6500(MysqlDialect x0) {
        return x0.DATE_TIME;
    }

    static /* synthetic */ SqlType access$6600(MysqlDialect x0) {
        return x0.DATE_TIME;
    }

    static /* synthetic */ SqlType access$6700(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$6800(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$6900(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$7000(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$7100(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$7200(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$7300(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$7400(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$7500(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$7600(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$7700(MysqlDialect x0) {
        return x0.DATE_TIME;
    }

    static /* synthetic */ SqlType access$7800(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$7900(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$8000(MysqlDialect x0) {
        return x0.DATE_TIME;
    }

    static /* synthetic */ SqlType access$8100(MysqlDialect x0) {
        return x0.DATE_TIME;
    }

    static /* synthetic */ SqlType access$8200(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$8300(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$8400(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$8500(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$8600(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$8700(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$8800(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$8900(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$9000(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$9100(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$9200(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$9300(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$9400(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$9500(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$9600(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$9700(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$9800(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$9900(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$10000(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$10100(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$10200(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$10300(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$10400(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$10500(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$10600(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$10700(MysqlDialect x0) {
        return x0.INTEGER;
    }

    static /* synthetic */ SqlType access$10800(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$10900(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$11000(MysqlDialect x0) {
        return x0.STRING;
    }

    static /* synthetic */ SqlType access$11100(MysqlDialect x0) {
        return x0.INTEGER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mysql/MysqlDialect";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 9: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mysql/MysqlDialect";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelimiterAt";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalVariables";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "calcGlobalVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDelimiterAt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "supportsSql92CharSetSpecFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isMajorChild";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalVariables";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getVariableReferenceGrade";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getGlobalVariables$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final NullableFunction<String, IElementType> ourReservedTokens = SqlTokenRegistry.getTokenProvider(MysqlReservedKeywords.class);
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.MYSQL_DELIMITER_TOKEN})});
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_OP_CONCAT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_INVERT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_NULLSAFE_EQ, SqlElementTypes.SQL_OP_LEFT_SHIFT, SqlElementTypes.SQL_OP_RIGHT_SHIFT, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT2, SqlElementTypes.SQL_OP_ASSIGN, MysqlReservedKeywords.MYSQL_REGEXP, MysqlReservedKeywords.MYSQL_RLIKE, MysqlOptionalKeywords.MYSQL_SOUNDS, MysqlReservedKeywords.MYSQL_DIV, MysqlReservedKeywords.MYSQL_MOD, MysqlReservedKeywords.MYSQL_XOR, MysqlReservedKeywords.MYSQL_BINARY});
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).opt(new IElementType[]{SqlElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlElementTypes.SQL_LOOP, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "end loop", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(new IElementType[]{SqlElementTypes.SQL_LOOP}).opt(new IElementType[]{SqlElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlElementTypes.SQL_THEN, SqlElementTypes.SQL_THEN_CLAUSE, SqlElementTypes.SQL_IF_STATEMENT}, "", "end if", 2, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(new IElementType[]{SqlElementTypes.SQL_IF}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{MysqlTypes.MYSQL_DO, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "end while", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(new IElementType[]{MysqlReservedKeywords.MYSQL_WHILE}).opt(new IElementType[]{SqlElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{MysqlReservedKeywords.MYSQL_REPEAT, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "until  end repeat", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(new IElementType[]{MysqlReservedKeywords.MYSQL_REPEAT}).opt(new IElementType[]{SqlElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build())));
        static final Map<Pair<IElementType, IElementType>, ReservedEntity.Typed[]> RE_SHOW_COLUMNS_BY_TYPE = ContainerUtil.immutableMapBuilder().put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_CHARACTER, null), (Object)LazyData.cols(LazyData.col("Charset", MysqlDialect.access$10800(INSTANCE)), LazyData.col("Description", MysqlDialect.access$10900(INSTANCE)), LazyData.col("Default collation", MysqlDialect.access$11000(INSTANCE)), LazyData.col("Maxlen", MysqlDialect.access$11100(INSTANCE)))).put(LazyData.type((IElementType)Sql92ReservedKeywords.SQL_COLLATION, null), (Object)LazyData.cols(LazyData.col("Collation", MysqlDialect.access$10200(INSTANCE)), LazyData.col("Charset", MysqlDialect.access$10300(INSTANCE)), LazyData.col("Id", MysqlDialect.access$10400(INSTANCE)), LazyData.col("Default", MysqlDialect.access$10500(INSTANCE)), LazyData.col("Compiled", MysqlDialect.access$10600(INSTANCE)), LazyData.col("Sortlen", MysqlDialect.access$10700(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_COLUMNS, null), (Object)LazyData.cols(LazyData.col("Field", MysqlDialect.access$9700(INSTANCE)), LazyData.col("Type", MysqlDialect.access$9800(INSTANCE)), LazyData.col("Null", MysqlDialect.access$9900(INSTANCE)), LazyData.col("Default", MysqlDialect.access$10000(INSTANCE)), LazyData.col("Extra", MysqlDialect.access$10100(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_FULL, MysqlTypes.MYSQL_COLUMNS), (Object)LazyData.cols(LazyData.col("Field", MysqlDialect.access$8800(INSTANCE)), LazyData.col("Type", MysqlDialect.access$8900(INSTANCE)), LazyData.col("Collation", MysqlDialect.access$9000(INSTANCE)), LazyData.col("Null", MysqlDialect.access$9100(INSTANCE)), LazyData.col("Key", MysqlDialect.access$9200(INSTANCE)), LazyData.col("Default", MysqlDialect.access$9300(INSTANCE)), LazyData.col("Extra", MysqlDialect.access$9400(INSTANCE)), LazyData.col("Privileges", MysqlDialect.access$9500(INSTANCE)), LazyData.col("Comment", MysqlDialect.access$9600(INSTANCE)))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_DATABASES, null), (Object)LazyData.cols(LazyData.col("database", MysqlDialect.access$8700(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_EVENTS, null), (Object)LazyData.cols(LazyData.col("Db", MysqlDialect.access$7200(INSTANCE)), LazyData.col("Name", MysqlDialect.access$7300(INSTANCE)), LazyData.col("Definer", MysqlDialect.access$7400(INSTANCE)), LazyData.col("Time Zone", MysqlDialect.access$7500(INSTANCE)), LazyData.col("Type", MysqlDialect.access$7600(INSTANCE)), LazyData.col("Execute At", MysqlDialect.access$7700(INSTANCE)), LazyData.col("Interval Value", MysqlDialect.access$7800(INSTANCE)), LazyData.col("Interval Field", MysqlDialect.access$7900(INSTANCE)), LazyData.col("Starts", MysqlDialect.access$8000(INSTANCE)), LazyData.col("Ends", MysqlDialect.access$8100(INSTANCE)), LazyData.col("Status", MysqlDialect.access$8200(INSTANCE)), LazyData.col("Originator", MysqlDialect.access$8300(INSTANCE)), LazyData.col("character_set_client", MysqlDialect.access$8400(INSTANCE)), LazyData.col("collation_connection", MysqlDialect.access$8500(INSTANCE)), LazyData.col("Database Collation", MysqlDialect.access$8600(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_FUNCTION, MysqlTypes.MYSQL_STATUS), (Object)LazyData.cols(LazyData.col("Db", MysqlDialect.access$6100(INSTANCE)), LazyData.col("Name", MysqlDialect.access$6200(INSTANCE)), LazyData.col("Type", MysqlDialect.access$6300(INSTANCE)), LazyData.col("Definer", MysqlDialect.access$6400(INSTANCE)), LazyData.col("Modified", MysqlDialect.access$6500(INSTANCE)), LazyData.col("Created", MysqlDialect.access$6600(INSTANCE)), LazyData.col("Security_type", MysqlDialect.access$6700(INSTANCE)), LazyData.col("Comment", MysqlDialect.access$6800(INSTANCE)), LazyData.col("character_set_client", MysqlDialect.access$6900(INSTANCE)), LazyData.col("collation_connection", MysqlDialect.access$7000(INSTANCE)), LazyData.col("Database Collation", MysqlDialect.access$7100(INSTANCE)))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_INDEX, null), (Object)LazyData.cols(LazyData.col("Table", MysqlDialect.access$4800(INSTANCE)), LazyData.col("Non_unique", MysqlDialect.access$4900(INSTANCE)), LazyData.col("Key_name", MysqlDialect.access$5000(INSTANCE)), LazyData.col("Seq_in_index", MysqlDialect.access$5100(INSTANCE)), LazyData.col("Column_name", MysqlDialect.access$5200(INSTANCE)), LazyData.col("Collation", MysqlDialect.access$5300(INSTANCE)), LazyData.col("Cardinality", MysqlDialect.access$5400(INSTANCE)), LazyData.col("Sub_part", MysqlDialect.access$5500(INSTANCE)), LazyData.col("Packed", MysqlDialect.access$5600(INSTANCE)), LazyData.col("Null", MysqlDialect.access$5700(INSTANCE)), LazyData.col("Index_type", MysqlDialect.access$5800(INSTANCE)), LazyData.col("Comment", MysqlDialect.access$5900(INSTANCE)), LazyData.col("Index_comment", MysqlDialect.access$6000(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_OPEN, MysqlTypes.MYSQL_TABLES), (Object)LazyData.cols(LazyData.col("Database", MysqlDialect.access$4400(INSTANCE)), LazyData.col("Table", MysqlDialect.access$4500(INSTANCE)), LazyData.col("In_use", MysqlDialect.access$4600(INSTANCE)), LazyData.col("Name_locked", MysqlDialect.access$4700(INSTANCE)))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_PROCEDURE, MysqlTypes.MYSQL_STATUS), (Object)LazyData.cols(LazyData.col("Db", MysqlDialect.access$3300(INSTANCE)), LazyData.col("Name", MysqlDialect.access$3400(INSTANCE)), LazyData.col("Type", MysqlDialect.access$3500(INSTANCE)), LazyData.col("Definer", MysqlDialect.access$3600(INSTANCE)), LazyData.col("Modified", MysqlDialect.access$3700(INSTANCE)), LazyData.col("Created", MysqlDialect.access$3800(INSTANCE)), LazyData.col("Security_type", MysqlDialect.access$3900(INSTANCE)), LazyData.col("Comment", MysqlDialect.access$4000(INSTANCE)), LazyData.col("character_set_client", MysqlDialect.access$4100(INSTANCE)), LazyData.col("collation_connection", MysqlDialect.access$4200(INSTANCE)), LazyData.col("Database Collation", MysqlDialect.access$4300(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_STATUS, null), (Object)LazyData.cols(LazyData.col("Variable_name", MysqlDialect.access$3100(INSTANCE)), LazyData.col("Value", MysqlDialect.access$3200(INSTANCE)))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_TABLE, null), (Object)LazyData.cols(LazyData.col("Name", MysqlDialect.access$1300(INSTANCE)), LazyData.col("Engine", MysqlDialect.access$1400(INSTANCE)), LazyData.col("Version", MysqlDialect.access$1500(INSTANCE)), LazyData.col("Row_format", MysqlDialect.access$1600(INSTANCE)), LazyData.col("Rows", MysqlDialect.access$1700(INSTANCE)), LazyData.col("Avg_row_length", MysqlDialect.access$1800(INSTANCE)), LazyData.col("Data_length", MysqlDialect.access$1900(INSTANCE)), LazyData.col("Max_data_length", MysqlDialect.access$2000(INSTANCE)), LazyData.col("Index_length", MysqlDialect.access$2100(INSTANCE)), LazyData.col("Data_free", MysqlDialect.access$2200(INSTANCE)), LazyData.col("Auto_increment", MysqlDialect.access$2300(INSTANCE)), LazyData.col("Create_time", MysqlDialect.access$2400(INSTANCE)), LazyData.col("Update_time", MysqlDialect.access$2500(INSTANCE)), LazyData.col("Check_time", MysqlDialect.access$2600(INSTANCE)), LazyData.col("Collation", MysqlDialect.access$2700(INSTANCE)), LazyData.col("Checksum", MysqlDialect.access$2800(INSTANCE)), LazyData.col("Create_options", MysqlDialect.access$2900(INSTANCE)), LazyData.col("Comment", MysqlDialect.access$3000(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_TRIGGERS, null), (Object)LazyData.cols(LazyData.col("Trigger", MysqlDialect.access$200(INSTANCE)), LazyData.col("Event", MysqlDialect.access$300(INSTANCE)), LazyData.col("Table", MysqlDialect.access$400(INSTANCE)), LazyData.col("Statement", MysqlDialect.access$500(INSTANCE)), LazyData.col("Timing", MysqlDialect.access$600(INSTANCE)), LazyData.col("Created", MysqlDialect.access$700(INSTANCE)), LazyData.col("sql_mode", MysqlDialect.access$800(INSTANCE)), LazyData.col("Definer", MysqlDialect.access$900(INSTANCE)), LazyData.col("character_set_client", MysqlDialect.access$1000(INSTANCE)), LazyData.col("collation_connection", MysqlDialect.access$1100(INSTANCE)), LazyData.col("Database Collation", MysqlDialect.access$1200(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_VARIABLES, null), (Object)LazyData.cols(LazyData.col("Variable_name", MysqlDialect.access$000(INSTANCE)), LazyData.col("Value", MysqlDialect.access$100(INSTANCE)))).build();

        private LazyData() {
        }

        private static ReservedEntity.Typed[] cols(ReservedEntity.Typed ... entities) {
            return entities;
        }

        private static ReservedEntity.Typed col(@NotNull String name, @NotNull SqlType type) {
            if (name == null) {
                LazyData.$$$reportNull$$$0(0);
            }
            if (type == null) {
                LazyData.$$$reportNull$$$0(1);
            }
            return new ReservedEntity.Typed(name, ObjectKind.COLUMN, type);
        }

        private static Pair<IElementType, IElementType> type(IElementType f, IElementType s) {
            return Pair.create((Object)f, (Object)s);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/dialects/mysql/MysqlDialect$LazyData";
            objectArray[2] = "col";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

