/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.psi;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPivotedQueryExpressionImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraPivotedQueryExpressionImpl
extends SqlPivotedQueryExpressionImpl {
    public OraPivotedQueryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            OraPivotedQueryExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    protected SqlTableType getPivotedType(@NotNull SqlClause columnsClause, @NotNull SqlClause forClause, @NotNull SqlClause inClause) {
        if (columnsClause == null) {
            OraPivotedQueryExpressionImpl.$$$reportNull$$$0(1);
        }
        if (forClause == null) {
            OraPivotedQueryExpressionImpl.$$$reportNull$$$0(2);
        }
        if (inClause == null) {
            OraPivotedQueryExpressionImpl.$$$reportNull$$$0(3);
        }
        SqlTableType sqlTableType = (SqlTableType)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcPivotedType(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
        if (sqlTableType == null) {
            OraPivotedQueryExpressionImpl.$$$reportNull$$$0(4);
        }
        return sqlTableType;
    }

    @NotNull
    private SqlTableType calcPivotedType() {
        SqlClause columnsClause = this.getColumnsClause();
        SqlClause inClause = this.getInClause();
        List values2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)columnsClause, SqlExpression.class);
        List columns2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)inClause, SqlExpression.class);
        if (values2.isEmpty() || columns2.isEmpty()) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            if (sqlTableType == null) {
                OraPivotedQueryExpressionImpl.$$$reportNull$$$0(5);
            }
            return sqlTableType;
        }
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)(values2.size() * columns2.size()));
        for (SqlExpression column : columns2) {
            for (SqlExpression value : values2) {
                result2.add(MyFakeDefinition.create((PsiElement)this, value, column));
            }
        }
        TableBasedSqlTableTypeImpl tableBasedSqlTableTypeImpl = new TableBasedSqlTableTypeImpl(result2, (PsiElement)this);
        if (tableBasedSqlTableTypeImpl == null) {
            OraPivotedQueryExpressionImpl.$$$reportNull$$$0(6);
        }
        return tableBasedSqlTableTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsClause";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forClause";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inClause";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/psi/OraPivotedQueryExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/psi/OraPivotedQueryExpressionImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPivotedType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPivotedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPivotedType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFakeDefinition
    extends SqlFileImpl.FakeDefinition
    implements SqlTypedDefinition {
        private final boolean myQuoted;
        private final SqlExpression myValue;
        private final SqlExpression myColumn;

        public static MyFakeDefinition create(@NotNull PsiElement parent, @NotNull SqlExpression value, @NotNull SqlExpression column) {
            String vName;
            if (parent == null) {
                MyFakeDefinition.$$$reportNull$$$0(0);
            }
            if (value == null) {
                MyFakeDefinition.$$$reportNull$$$0(1);
            }
            if (column == null) {
                MyFakeDefinition.$$$reportNull$$$0(2);
            }
            boolean columnQuoted = DbSqlUtil.isQuoted((DasObject)ObjectUtils.tryCast((Object)column, DasObject.class));
            boolean valueQuoted = DbSqlUtil.isQuoted((DasObject)ObjectUtils.tryCast((Object)value, DasObject.class));
            String cName = column.getName();
            String string = vName = value instanceof DasObject ? value.getName() : null;
            if (valueQuoted != columnQuoted) {
                SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe(parent);
                Casing casing = language.getCasing(ObjectKind.COLUMN, null);
                if (casing.quoted == Case.EXACT) {
                    if (!columnQuoted) {
                        cName = casing.plain.apply(cName);
                    }
                    if (!valueQuoted) {
                        vName = casing.plain.apply(vName);
                    }
                }
            }
            String name = cName == null || vName == null ? cName : cName + "_" + vName;
            return new MyFakeDefinition(parent, name, columnQuoted || valueQuoted, value, column);
        }

        public MyFakeDefinition(@NotNull PsiElement parent, @Nullable String name, boolean quoted, @NotNull SqlExpression value, @NotNull SqlExpression column) {
            if (parent == null) {
                MyFakeDefinition.$$$reportNull$$$0(3);
            }
            if (value == null) {
                MyFakeDefinition.$$$reportNull$$$0(4);
            }
            if (column == null) {
                MyFakeDefinition.$$$reportNull$$$0(5);
            }
            super(parent, StringUtil.notNullize((String)name), name);
            this.myQuoted = quoted;
            this.myValue = value;
            this.myColumn = column;
        }

        public boolean isNameQuoted() {
            return this.myQuoted;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                MyFakeDefinition.$$$reportNull$$$0(6);
            }
            return objectKind;
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            SqlExpression sqlExpression = this.myColumn;
            if (sqlExpression == null) {
                MyFakeDefinition.$$$reportNull$$$0(7);
            }
            return sqlExpression;
        }

        @NotNull
        public SqlType getSqlType() {
            SqlType sqlType = this.myValue.getSqlType();
            if (sqlType == null) {
                MyFakeDefinition.$$$reportNull$$$0(8);
            }
            return sqlType;
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = this.getSqlType().getDataType();
            if (dataType == null) {
                MyFakeDefinition.$$$reportNull$$$0(9);
            }
            return dataType;
        }

        public boolean isNotNull() {
            return false;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/oracle/psi/OraPivotedQueryExpressionImpl$MyFakeDefinition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/oracle/psi/OraPivotedQueryExpressionImpl$MyFakeDefinition";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlType";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

