/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.postgres.PostgresModForeignDataWrapper;
import com.intellij.database.model.postgres.PostgresModForeignServer;
import com.intellij.database.model.postgres.PostgresModRole;
import com.intellij.database.model.postgres.PostgresModRoutine;
import com.intellij.database.model.postgres.PostgresModSequence;
import com.intellij.database.model.postgres.PostgresModUserMapping;
import com.intellij.database.model.properties.PostgresRoutineConcurrencyKind;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.database.SqlObjectBuilderImpl;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.PostgresBaseObjectBuilder;
import com.intellij.sql.dialects.postgres.PostgresElementTypes;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateSequenceStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateUserStatementImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0007\u001a\u00020\u0015H\u0002J\u0019\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0019\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0015H\u0002J\u0014\u0010&\u001a\u0004\u0018\u00010%2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0015H\u0002J\u0014\u0010'\u001a\u0004\u0018\u00010%2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0015H\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/sql/dialects/postgres/PostgresObjectBuilder;", "Lcom/intellij/sql/dialects/postgres/PostgresBaseObjectBuilder;", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "buildForeignDataWrapper", "Lcom/intellij/database/model/postgres/PostgresModForeignDataWrapper;", "buildForeignServer", "Lcom/intellij/database/model/postgres/PostgresModForeignServer;", "buildRole", "Lcom/intellij/database/model/postgres/PostgresModRole;", "buildRoutine", "Lcom/intellij/database/model/postgres/PostgresModRoutine;", "buildSequence", "Lcom/intellij/database/model/postgres/PostgresModSequence;", "buildSequenceIdentity", "Lcom/intellij/database/model/SequenceIdentity;", "Lcom/intellij/psi/PsiElement;", "buildUserMapping", "Lcom/intellij/database/model/postgres/PostgresModUserMapping;", "findConcurrencyKind", "Lcom/intellij/database/model/properties/PostgresRoutineConcurrencyKind;", "element", "findFunctionReference", "Lcom/intellij/sql/dialects/postgres/PostgresObjectBuilder$Reference;", "findNumber", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Long;", "findNumberInSiblings", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Float;", "findOptions", "", "", "findString", "findUser", "Reference", "sql-dialects"})
public class PostgresObjectBuilder
extends PostgresBaseObjectBuilder {
    @Override
    public void build(@NotNull BasicModElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof PostgresModSequence) {
            this.buildSequence((PostgresModSequence)obj, source);
        } else if (basicModElement instanceof PostgresModRoutine) {
            this.buildRoutine((PostgresModRoutine)obj, source);
        } else if (basicModElement instanceof PostgresModForeignDataWrapper) {
            this.buildForeignDataWrapper((PostgresModForeignDataWrapper)obj, source);
        } else if (basicModElement instanceof PostgresModForeignServer) {
            this.buildForeignServer((PostgresModForeignServer)obj, source);
        } else if (basicModElement instanceof PostgresModUserMapping) {
            this.buildUserMapping((PostgresModUserMapping)obj, source);
        } else if (basicModElement instanceof PostgresModRole) {
            this.buildRole((PostgresModRole)obj, source);
        } else {
            super.build(obj, source);
        }
    }

    private final void buildRole(PostgresModRole obj, DasObject source) {
        if (source instanceof SqlCreateStatement) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            boolean isSuper = false;
            boolean isInherit = true;
            boolean canCreateRole = false;
            boolean canCreateDb = false;
            boolean canLogin = source instanceof SqlCreateUserStatementImpl;
            boolean isReplication = false;
            long connectionLimit = -1L;
            String validUntil = null;
            boolean isBypassRls = false;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement it = tmp$iv$iv;
                if (!(it instanceof SqlClause)) continue;
                PsiElement c = ((SqlClause)it).getFirstChild();
                ASTNode aSTNode = c.getNode();
                Object object = iElementType = aSTNode != null ? aSTNode.getElementType() : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SUPERUSER)) {
                    isSuper = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_NOINHERIT)) {
                    isInherit = false;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CREATEROLE)) {
                    canCreateRole = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CREATEDB)) {
                    canCreateDb = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_LOGIN)) {
                    canLogin = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_NOLOGIN)) {
                    canLogin = false;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_REPLICATION)) {
                    isReplication = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CONNECTION)) {
                    IElementType iElementType2 = PgTypes.PG_LIMIT;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"PG_LIMIT");
                    Float f = this.findNumberInSiblings(this.findSibling(c, iElementType2));
                    connectionLimit = f != null ? (long)f.floatValue() : -1L;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_VALID)) {
                    IElementType iElementType3 = PgTypes.PG_UNTIL;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"PG_UNTIL");
                    validUntil = this.findString(this.findSibling(c, iElementType3));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_BYPASSRLS)) continue;
                isBypassRls = true;
            }
            obj.setSuperRole(isSuper);
            obj.setInherit(isInherit);
            obj.setCreateRole(canCreateRole);
            obj.setCreateDb(canCreateDb);
            obj.setCanLogin(canLogin);
            obj.setReplication(isReplication);
            obj.setConnectionLimit(connectionLimit);
            obj.setValidUntil(validUntil);
            obj.setBypassRls(isBypassRls);
        }
    }

    private final void buildForeignDataWrapper(PostgresModForeignDataWrapper obj, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            Reference handler = null;
            Reference validator = null;
            List<String> options = CollectionsKt.emptyList();
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement it = tmp$iv$iv;
                ASTNode aSTNode = it.getNode();
                Object object = iElementType = aSTNode != null ? aSTNode.getElementType() : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_HANDLER)) {
                    handler = this.findFunctionReference(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_VALIDATOR)) {
                    validator = this.findFunctionReference(it);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it);
            }
            Reference reference = handler;
            obj.setHandler(reference != null ? reference.getName() : null);
            Reference reference2 = handler;
            obj.setHandlerSchema(reference2 != null ? reference2.getQualifier() : null);
            Reference reference3 = validator;
            obj.setValidator(reference3 != null ? reference3.getName() : null);
            Reference reference4 = validator;
            obj.setValidatorSchema(reference4 != null ? reference4.getQualifier() : null);
            obj.setOptions(options);
        }
    }

    private final void buildForeignServer(PostgresModForeignServer obj, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            String type = null;
            List<String> options = CollectionsKt.emptyList();
            String version = null;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement it = tmp$iv$iv;
                ASTNode aSTNode = it.getNode();
                Object object = iElementType = aSTNode != null ? aSTNode.getElementType() : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) {
                    IElementType iElementType2;
                    PsiElement first;
                    if (it.getFirstChild() == null) {
                        continue;
                    }
                    ASTNode aSTNode2 = first.getNode();
                    Object object2 = iElementType2 = aSTNode2 != null ? aSTNode2.getElementType() : null;
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_TYPE)) {
                        type = this.findString(first);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_VERSION)) continue;
                    version = this.findString(first);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it);
            }
            obj.setType(type);
            obj.setOptions(options);
            obj.setVersion(version);
        }
    }

    private final void buildUserMapping(PostgresModUserMapping obj, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            String user = null;
            List<String> options = CollectionsKt.emptyList();
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement it = tmp$iv$iv;
                ASTNode aSTNode = it.getNode();
                Object object = iElementType = aSTNode != null ? aSTNode.getElementType() : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_FOR)) {
                    user = this.findUser(it);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it);
            }
            obj.setUser(user);
            obj.setOptions(options);
        }
    }

    private final void buildSequence(PostgresModSequence obj, DasObject source) {
        this.buildBasicElement(obj, source);
        if (source instanceof SqlCreateSequenceStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            obj.setSequenceIdentity(this.buildSequenceIdentity((PsiElement)source));
            boolean cycle = false;
            boolean owned = false;
            long cacheSize = 1L;
            String dataType = null;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement type;
                PsiElement it = tmp$iv$iv;
                if (!(it instanceof SqlClause)) continue;
                PsiElement psiElement = ((SqlClause)it).getFirstChild();
                if (psiElement == null || (psiElement = psiElement.getNode()) == null || (psiElement = psiElement.getElementType()) == null) {
                    continue;
                }
                PsiElement psiElement2 = type = psiElement;
                if (Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_CYCLE)) {
                    cycle = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_OWNED)) {
                    SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlCompositeElementTypes.SQL_COLUMN_REFERENCE");
                    owned = this.findChild(it, (IElementType)sqlReferenceElementType) != null;
                    continue;
                }
                if (Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_CACHE)) {
                    Long l = this.findNumber(it);
                    cacheSize = l != null ? l : 1L;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_AS)) continue;
                SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_TYPE_ELEMENT;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_TYPE_ELEMENT");
                PsiElement psiElement3 = this.findChild(it, (IElementType)sqlCompositeElementType);
                if (!(psiElement3 instanceof SqlTypeElement)) {
                    psiElement3 = null;
                }
                SqlTypeElement sqlTypeElement = (SqlTypeElement)psiElement3;
                dataType = sqlTypeElement != null ? sqlTypeElement.getDisplayName() : null;
            }
            obj.setCycled(cycle);
            obj.setBelongsToColumn(owned);
            obj.setCacheSize(cacheSize);
            obj.setDataType(dataType);
        }
    }

    private final void buildRoutine(PostgresModRoutine obj, DasObject source) {
        super.buildRoutine(obj, source);
        if (source instanceof SqlCreateFunctionStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            ArrayList<String> assignments = new ArrayList<String>();
            PostgresRoutineConcurrencyKind concurrencyKind = null;
            boolean isLeakproof = false;
            boolean isWindow = false;
            boolean isStrict = false;
            boolean isSecurityDefiner = false;
            float cost = 0.0f;
            float rows = 0.0f;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement first$iv$iv2;
                PostgresObjectBuilder this_$iv2;
                PsiElement createChild = tmp$iv$iv;
                ASTNode aSTNode = createChild.getNode();
                if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)PostgresElementTypes.PG_LAZY_CODE_BLOCK_PARENT)) continue;
                PostgresObjectBuilder postgresObjectBuilder2 = this_$iv2 = this;
                for (PsiElement tmp$iv$iv2 = first$iv$iv2 = createChild.getFirstChild(); tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    IElementType iElementType;
                    PsiElement it = tmp$iv$iv2;
                    PsiElement s = it.getFirstChild();
                    PsiElement psiElement = s;
                    IElementType iElementType2 = psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : (iElementType = null);
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SET)) {
                        PostgresObjectBuilder this_$iv3 = this;
                        for (PsiElement tmp$iv = s; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                            PsiElement it2 = tmp$iv;
                            ASTNode aSTNode2 = it2.getNode();
                            if (!Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)PgTypes.PG_SET_ASSIGNMENT)) continue;
                            assignments.add(it2.getText());
                        }
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PARALLEL)) {
                        PsiElement psiElement2 = s;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"s");
                        concurrencyKind = this.findConcurrencyKind(psiElement2);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_NOT)) {
                        isLeakproof = false;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_LEAKPROOF)) {
                        isLeakproof = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_WINDOW)) {
                        isWindow = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_STRICT)) {
                        isStrict = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SECURITY) || Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_EXTERNAL)) {
                        IElementType iElementType3 = PgTypes.PG_DEFINER;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"PG_DEFINER");
                        isSecurityDefiner = this.findSibling(s, iElementType3) != null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_COST)) {
                        Float f = this.findNumberInSiblings(s);
                        cost = f != null ? f.floatValue() : 0.0f;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_ROWS)) continue;
                    Float f = this.findNumberInSiblings(s);
                    rows = f != null ? f.floatValue() : 0.0f;
                }
            }
            obj.setConfigurationParameters((List<String>)assignments);
            obj.setConcurrencyKind(concurrencyKind);
            obj.setLeakproof(isLeakproof);
            obj.setWindow(isWindow);
            obj.setStrict(isStrict);
            obj.setSecurityDefiner(isSecurityDefiner);
            obj.setCost(cost);
            obj.setRows(rows);
        }
    }

    private final SequenceIdentity buildSequenceIdentity(PsiElement source) {
        Long startVal;
        Long maxVal;
        Long minVal;
        PsiElement first$iv$iv;
        Long[] longArray = new Long[4];
        Object object = longArray;
        Object object2 = object[0];
        Long l = (Long)object2;
        object = longArray;
        object2 = object[1];
        Long l2 = (Long)object2;
        object = longArray;
        object2 = object[2];
        Long l3 = (Long)object2;
        object = longArray;
        object2 = object[3];
        Long incVal = (Long)object2;
        PostgresObjectBuilder this_$iv = this;
        object = this_$iv;
        PsiElement psiElement = source;
        for (PsiElement tmp$iv$iv = first$iv$iv = (v1597047) != null ? (v1597047).getFirstChild() : null; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            PsiElement type;
            PsiElement it = tmp$iv$iv;
            if (!(it instanceof SqlClause)) continue;
            PsiElement psiElement2 = ((SqlClause)it).getFirstChild();
            if (psiElement2 == null || (psiElement2 = psiElement2.getNode()) == null || (psiElement2 = psiElement2.getElementType()) == null) {
                continue;
            }
            PsiElement psiElement3 = type = psiElement2;
            if (Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_MINVALUE)) {
                minVal = this.findNumber(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_MAXVALUE)) {
                maxVal = this.findNumber(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_START)) {
                startVal = this.findNumber(it);
                continue;
            }
            if (!Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_INCREMENT)) continue;
            incVal = this.findNumber(it);
        }
        SequenceIdentity sequenceIdentity = SequenceIdentity.of(minVal, startVal, incVal, maxVal);
        Intrinsics.checkExpressionValueIsNotNull((Object)sequenceIdentity, (String)"SequenceIdentity.of(minV\u2026startVal, incVal, maxVal)");
        return sequenceIdentity;
    }

    private final PostgresRoutineConcurrencyKind findConcurrencyKind(PsiElement element) {
        PostgresObjectBuilder this_$iv = this;
        for (PsiElement tmp$iv = element; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            PsiElement it = tmp$iv;
            IElementType iElementType = it.getNode().getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SAFE)) {
                return PostgresRoutineConcurrencyKind.SAFE;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_RESTRICTED)) {
                return PostgresRoutineConcurrencyKind.RESTRICTED;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_UNSAFE)) continue;
            return PostgresRoutineConcurrencyKind.UNSAFE;
        }
        return null;
    }

    private final Long findNumber(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_NUMERIC_LITERAL");
        PsiElement num = this.findChild(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toLongOrNull((String)object) : null;
    }

    private final Float findNumberInSiblings(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_NUMERIC_LITERAL");
        PsiElement num = this.findSibling(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toFloatOrNull((String)object) : null;
    }

    private final Reference findFunctionReference(PsiElement source) {
        SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_FUNCTION_REFERENCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlElementTypes.SQL_FUNCTION_REFERENCE");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlReferenceElementType);
        if (!(psiElement instanceof SqlReferenceExpression)) {
            psiElement = null;
        }
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)psiElement;
        if (sqlReferenceExpression == null) {
            return null;
        }
        SqlReferenceExpression reference = sqlReferenceExpression;
        Object object = reference.getIdentifier();
        if (object == null || (object = object.getName()) == null) {
            return null;
        }
        Object name = object;
        SqlExpression sqlExpression = reference.getQualifierExpression();
        String qualifier = sqlExpression != null ? sqlExpression.getName() : null;
        Object object2 = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"name");
        return new Reference(qualifier, (String)object2);
    }

    private final String findString(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_STRING_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_STRING_LITERAL");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlCompositeElementType);
        if (!(psiElement instanceof SqlStringLiteralExpressionImpl)) {
            psiElement = null;
        }
        SqlStringLiteralExpressionImpl sqlStringLiteralExpressionImpl = (SqlStringLiteralExpressionImpl)psiElement;
        return sqlStringLiteralExpressionImpl != null ? sqlStringLiteralExpressionImpl.getValue() : null;
    }

    private final String findUser(PsiElement source) {
        SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_USER_REFERENCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlElementTypes.SQL_USER_REFERENCE");
        PsiElement userReference = this.findSibling(source, (IElementType)sqlReferenceElementType);
        if (userReference instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)userReference).getName();
        }
        PostgresObjectBuilder this_$iv = this;
        for (PsiElement tmp$iv = source; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            PsiElement it = tmp$iv;
            IElementType iElementType = it.getNode().getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_USER_REFERENCE)) {
                if (!(userReference instanceof SqlReferenceExpression)) continue;
                return ((SqlReferenceExpression)userReference).getName();
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_USER)) {
                return "user";
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CURRENT_USER)) {
                return "current_user";
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PUBLIC)) continue;
            return "public";
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final List<String> findOptions(PsiElement source) {
        result = new ArrayList<E>();
        v0 = SqlElementTypes.SQL_LEFT_PAREN;
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"SqlElementTypes.SQL_LEFT_PAREN");
        v1 = this.findSibling(source, (IElementType)v0);
        if (v1 == null) {
            return result;
        }
        current = leftParen = v1;
        while (((v2 = current) != null && (v2 = v2.getNode()) != null ? v2.getElementType() : null) != null && Intrinsics.areEqual((Object)current.getNode().getElementType(), (Object)SqlElementTypes.SQL_RIGHT_PAREN) ^ true) {
            block14: {
                block13: {
                    var6_6 = this;
                    var7_7 = current;
                    direction$iv = SqlObjectBuilderImpl.Direction.NEXT;
                    tmp$iv = element$iv;
                    while (tmp$iv != null) {
                        it = tmp$iv;
                        if (!(Intrinsics.areEqual((Object)it, (Object)current) ^ true)) ** GOTO lbl-1000
                        v3 = it.getNode();
                        if (!(Intrinsics.areEqual((Object)(v3 != null ? v3.getElementType() : null), (Object)SqlElementTypes.SQL_STRING_LITERAL) ^ true)) ** GOTO lbl-1000
                        v4 = it.getNode();
                        if (Intrinsics.areEqual((Object)(v4 != null ? v4.getElementType() : null), (Object)SqlElementTypes.WHITE_SPACE) ^ true) {
                            v5 = true;
                        } else lbl-1000:
                        // 3 sources

                        {
                            v5 = false;
                        }
                        if (v5) {
                            v6 = tmp$iv;
                            break block13;
                        }
                        tmp$iv = direction$iv.next(tmp$iv);
                    }
                    v6 = null;
                }
                if (v6 == null) {
                    return result;
                }
                option = v6;
                v7 = SqlElementTypes.SQL_STRING_LITERAL;
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"SqlElementTypes.SQL_STRING_LITERAL");
                if (this.findSibling(option, (IElementType)v7) == null) {
                    return result;
                }
                v8 = literal;
                if (v8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl");
                }
                result.add(option.getText() + "=" + ((SqlStringLiteralExpressionImpl)v8).getValue());
                element$iv = this;
                direction$iv = SqlObjectBuilderImpl.Direction.NEXT;
                tmp$iv = literal;
                while (tmp$iv != null) {
                    it = tmp$iv;
                    if (!(Intrinsics.areEqual((Object)it, (Object)literal) ^ true)) ** GOTO lbl-1000
                    v9 = it.getNode();
                    if (Intrinsics.areEqual((Object)(v9 != null ? v9.getElementType() : null), (Object)SqlElementTypes.WHITE_SPACE) ^ true) {
                        v10 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v10 = false;
                    }
                    if (v10) {
                        v11 = tmp$iv;
                        break block14;
                    }
                    tmp$iv = direction$iv.next(tmp$iv);
                }
                v11 = null;
            }
            current = var13_11 = v11;
        }
        return result;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/dialects/postgres/PostgresObjectBuilder$Reference;", "", "qualifier", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getQualifier", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "sql-dialects"})
    private static final class Reference {
        @Nullable
        private final String qualifier;
        @NotNull
        private final String name;

        @Nullable
        public final String getQualifier() {
            return this.qualifier;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public Reference(@Nullable String qualifier, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.qualifier = qualifier;
            this.name = name;
        }

        @Nullable
        public final String component1() {
            return this.qualifier;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final Reference copy(@Nullable String qualifier, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new Reference(qualifier, name);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Reference copy$default(Reference reference, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = reference.qualifier;
            }
            if ((n & 2) != 0) {
                string2 = reference.name;
            }
            return reference.copy(string, string2);
        }

        public String toString() {
            return "Reference(qualifier=" + this.qualifier + ", name=" + this.name + ")";
        }

        public int hashCode() {
            String string = this.qualifier;
            String string2 = this.name;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Reference)) break block3;
                    Reference reference = (Reference)object;
                    if (!Intrinsics.areEqual((Object)this.qualifier, (Object)reference.qualifier) || !Intrinsics.areEqual((Object)this.name, (Object)reference.name)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

