/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlEditorOptionsProvider
implements EditorOptionsProvider {
    private JBCheckBox myConcatenateOnEnterCheckBox;
    private JPanel myMainPanel;
    private ComboBox<SqlEditorOptions.QualificationType> myNamespaceQualification;
    private ComboBox<SqlEditorOptions.QualificationType> myTableQualification;
    private ComboBox<SqlEditorOptions.QualificationType> myAliasQualification;

    public SqlEditorOptionsProvider() {
        this.$$$setupUI$$$();
    }

    @NotNull
    public String getId() {
        if ("editor.preferences.sqlOptions" == null) {
            SqlEditorOptionsProvider.$$$reportNull$$$0(0);
        }
        return "editor.preferences.sqlOptions";
    }

    @Nullable
    public JComponent createComponent() {
        ((GridLayoutManager)this.myMainPanel.getLayout()).setVGap(JBUI.scale((int)4));
        this.myConcatenateOnEnterCheckBox.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
        return this.myMainPanel;
    }

    public boolean isModified() {
        return !this.extract(new SqlEditorOptions()).equals(SqlEditorOptions.getInstance());
    }

    public void apply() throws ConfigurationException {
        this.extract(SqlEditorOptions.getInstance());
    }

    protected SqlEditorOptions extract(SqlEditorOptions options) {
        options.setConcatenateStringsOnEnter(this.myConcatenateOnEnterCheckBox.isSelected());
        options.setNamespaceQualification((SqlEditorOptions.QualificationType)((Object)this.myNamespaceQualification.getSelectedItem()));
        options.setTableQualification((SqlEditorOptions.QualificationType)((Object)this.myTableQualification.getSelectedItem()));
        options.setAliasQualification((SqlEditorOptions.QualificationType)((Object)this.myAliasQualification.getSelectedItem()));
        return options;
    }

    public void reset() {
        SqlEditorOptions instance = SqlEditorOptions.getInstance();
        this.myConcatenateOnEnterCheckBox.setSelected(instance.isConcatenateStringsOnEnter());
        this.myNamespaceQualification.setSelectedItem((Object)instance.getNamespaceQualification());
        this.myTableQualification.setSelectedItem((Object)instance.getTableQualification());
        this.myAliasQualification.setSelectedItem((Object)instance.getAliasQualification());
    }

    @Nls
    public String getDisplayName() {
        return "Sql";
    }

    private void createUIComponents() {
        this.myNamespaceQualification = new ComboBox((Object[])SqlEditorOptions.QualificationType.values());
        this.myTableQualification = new ComboBox((Object[])SqlEditorOptions.QualificationType.values());
        this.myAliasQualification = new ComboBox((Object[])SqlEditorOptions.QualificationType.values());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/editor/SqlEditorOptionsProvider", "getId"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"SQL", (int)0, (int)0, null, null));
        this.myConcatenateOnEnterCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Insert string concatenation on Enter");
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Database/Schema:");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        ComboBox<SqlEditorOptions.QualificationType> comboBox = this.myNamespaceQualification;
        jPanel.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 2, 4, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Table:");
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Qualify object on code completion with:");
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        ComboBox<SqlEditorOptions.QualificationType> comboBox2 = this.myTableQualification;
        jPanel.add((Component)comboBox2, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Alias");
        jPanel.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        ComboBox<SqlEditorOptions.QualificationType> comboBox3 = this.myAliasQualification;
        jPanel.add((Component)comboBox3, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

