/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.highlighting.SqlSyntaxHighlighter;
import gnu.trove.THashMap;
import icons.DatabaseIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SqlColorSettingsPage
implements ColorSettingsPage {
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor("External command", SqlSyntaxHighlighter.SQL_EXTERNAL_TOOL), new AttributesDescriptor("Comment", SqlSyntaxHighlighter.SQL_COMMENT), new AttributesDescriptor("Database object", SqlSyntaxHighlighter.SQL_DATABASE_OBJECT), new AttributesDescriptor("Schema", SqlSyntaxHighlighter.SQL_SCHEMA), new AttributesDescriptor("Table", SqlSyntaxHighlighter.SQL_TABLE), new AttributesDescriptor("Column", SqlSyntaxHighlighter.SQL_COLUMN), new AttributesDescriptor("Type", SqlSyntaxHighlighter.SQL_TYPE), new AttributesDescriptor("Procedure or function", SqlSyntaxHighlighter.SQL_PROCEDURE), new AttributesDescriptor("Parameter", SqlSyntaxHighlighter.SQL_PARAMETER), new AttributesDescriptor("Variable", SqlSyntaxHighlighter.SQL_VARIABLE), new AttributesDescriptor("Label", SqlSyntaxHighlighter.SQL_LABEL), new AttributesDescriptor("Table or column alias", SqlSyntaxHighlighter.SQL_LOCAL_ALIAS), new AttributesDescriptor("Synthetic entity", SqlSyntaxHighlighter.SQL_SYNTHETIC_ENTITY), new AttributesDescriptor("Number token", SqlSyntaxHighlighter.SQL_NUMBER), new AttributesDescriptor("Keyword", SqlSyntaxHighlighter.SQL_KEYWORD), new AttributesDescriptor("String token", SqlSyntaxHighlighter.SQL_STRING), new AttributesDescriptor("Semicolon", SqlSyntaxHighlighter.SQL_SEMICOLON), new AttributesDescriptor("Comma", SqlSyntaxHighlighter.SQL_COMMA), new AttributesDescriptor("Dot", SqlSyntaxHighlighter.SQL_DOT), new AttributesDescriptor("Parentheses", SqlSyntaxHighlighter.SQL_PARENS), new AttributesDescriptor("Brackets", SqlSyntaxHighlighter.SQL_BRACKETS), new AttributesDescriptor("Braces", SqlSyntaxHighlighter.SQL_BRACES), new AttributesDescriptor("Bad token", SqlSyntaxHighlighter.SQL_BAD_CHARACTER)};

    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("sql.color.page.title", new Object[0]);
        if (string == null) {
            SqlColorSettingsPage.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return DatabaseIcons.Sql;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (ATTRS == null) {
            SqlColorSettingsPage.$$$reportNull$$$0(1);
        }
        return ATTRS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            SqlColorSettingsPage.$$$reportNull$$$0(2);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        SqlSyntaxHighlighter sqlSyntaxHighlighter = new SqlSyntaxHighlighter(DbSqlUtil.getGenericDialect(), null);
        if (sqlSyntaxHighlighter == null) {
            SqlColorSettingsPage.$$$reportNull$$$0(3);
        }
        return sqlSyntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        if ("-- DDL section\ncreate table <schema>crm</schema>.<table>product</table> (\n  <column>id</column> numeric primary key,\n  <column>title</column> varchar(255) character set <obj>utf8</obj>\n);\n-- DML section\ninsert into <table>product</table>\n  values (1, 'Product1');\n\nselect <proc>count</proc>(*) from <schema>crm</schema>.<table>product</table>;\nselect <column>id</column> as <alias>ProductID</alias>, <column>title</column> as <alias>ProductName</alias>\n  from <schema>crm</schema>.<table>product</table> where <column>id</column> = :<parameter>id</parameter>;\n\n<tool>\\set content `cat data.txt`</tool>\n" == null) {
            SqlColorSettingsPage.$$$reportNull$$$0(4);
        }
        return "-- DDL section\ncreate table <schema>crm</schema>.<table>product</table> (\n  <column>id</column> numeric primary key,\n  <column>title</column> varchar(255) character set <obj>utf8</obj>\n);\n-- DML section\ninsert into <table>product</table>\n  values (1, 'Product1');\n\nselect <proc>count</proc>(*) from <schema>crm</schema>.<table>product</table>;\nselect <column>id</column> as <alias>ProductID</alias>, <column>title</column> as <alias>ProductName</alias>\n  from <schema>crm</schema>.<table>product</table> where <column>id</column> = :<parameter>id</parameter>;\n\n<tool>\\set content `cat data.txt`</tool>\n";
    }

    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        THashMap map2 = new THashMap();
        map2.put("obj", SqlSyntaxHighlighter.SQL_DATABASE_OBJECT);
        map2.put("schema", SqlSyntaxHighlighter.SQL_SCHEMA);
        map2.put("table", SqlSyntaxHighlighter.SQL_TABLE);
        map2.put("column", SqlSyntaxHighlighter.SQL_COLUMN);
        map2.put("alias", SqlSyntaxHighlighter.SQL_LOCAL_ALIAS);
        map2.put("parameter", SqlSyntaxHighlighter.SQL_PARAMETER);
        map2.put("proc", SqlSyntaxHighlighter.SQL_PROCEDURE);
        map2.put("tool", SqlSyntaxHighlighter.SQL_EXTERNAL_TOOL);
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/highlighting/SqlColorSettingsPage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDemoText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

