/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectName;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.intentions.SqlQualificationIntentionBase;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQualifyIdentifierIntention
extends SqlQualificationIntentionBase {
    @NotNull
    public String getFamilyName() {
        if ("Qualify identifier" == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(0);
        }
        return "Qualify identifier";
    }

    @NotNull
    private static JBIterable<ObjectName> getParentObjectNames(@Nullable SqlIdentifier identifier) {
        JBIterable jBIterable = JBIterable.from(SqlQualifyIdentifierIntention.getParentObjects(identifier)).filterMap(o -> SqlQualifyIdentifierIntention.getName(o));
        if (jBIterable == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @NotNull
    private static Collection<Object> getParentObjects(@Nullable SqlIdentifier identifier) {
        DasObject res;
        if (identifier == null) {
            List<Object> list = Collections.emptyList();
            if (list == null) {
                SqlQualifyIdentifierIntention.$$$reportNull$$$0(2);
            }
            return list;
        }
        LinkedHashSet parents = ContainerUtil.newLinkedHashSet();
        PsiElement parent = identifier.getParent();
        PsiPolyVariantReference ref = (PsiPolyVariantReference)ObjectUtils.tryCast((Object)parent.getReference(), PsiPolyVariantReference.class);
        if (ref != null) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ref.multiResolve(false)) {
                PsiElement qualifier = SqlImplUtil.getQualifier(result2);
                if (qualifier != null) {
                    ContainerUtil.addIfNotNull((Collection)parents, (Object)qualifier);
                    continue;
                }
                DasObject object = (DasObject)ObjectUtils.tryCast((Object)result2.getElement(), DasObject.class);
                if (object != null) {
                    object = object.getDasParent();
                }
                ContainerUtil.addIfNotNull((Collection)parents, (Object)object);
            }
        }
        if ((res = (DasObject)ObjectUtils.tryCast((Object)parent, DasObject.class)) != null) {
            res = res.getDasParent();
        }
        if (res != null) {
            ContainerUtil.addIfNotNull((Collection)parents, (Object)res);
        }
        LinkedHashSet linkedHashSet = parents;
        if (linkedHashSet == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(4);
        }
        if (!(file instanceof SqlFile)) {
            return false;
        }
        return !JBIterable.from((Iterable)editor.getCaretModel().getAllCarets()).flatten(c -> SqlQualifyIdentifierIntention.getTopmostIdentifiers(file, c)).flatten(id -> SqlQualifyIdentifierIntention.getParentObjectNames(id)).isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(5);
        }
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        int depth = 0;
        MultiMap names = MultiMap.createLinkedSet();
        for (SqlIdentifier identifier : JBIterable.from((Iterable)editor.getCaretModel().getAllCarets()).flatten(c -> SqlQualifyIdentifierIntention.getTopmostIdentifiers(file, c))) {
            for (Object p : SqlQualifyIdentifierIntention.getParentObjects(identifier)) {
                ObjectName name;
                int d = SqlQualifyIdentifierIntention.getDepth(language.getDatabaseDialect(), SqlQualifyIdentifierIntention.getKind(p));
                if (depth > d) continue;
                if (depth < d) {
                    depth = d;
                    names.clear();
                }
                if ((name = SqlQualifyIdentifierIntention.getName(p)) == null) continue;
                names.putValue((Object)identifier, (Object)name);
            }
        }
        if (!names.isEmpty()) {
            this.performQualification((MultiMap<SqlIdentifier, ObjectName>)names, editor, file, language);
        }
    }

    protected void performQualification(MultiMap<SqlIdentifier, ObjectName> names, Editor editor, PsiFile file, SqlLanguageDialectEx language) {
        Document document = editor.getDocument();
        ArrayList unique = ContainerUtil.newArrayList();
        ArrayList nonUnique = ContainerUtil.newArrayList();
        for (Map.Entry entry : names.entrySet()) {
            RangeMarker marker = document.createRangeMarker(((SqlIdentifier)entry.getKey()).getTextRange());
            Collection variants = (Collection)entry.getValue();
            if (variants.size() == 1) {
                unique.add(Pair.create((Object)marker, (Object)variants));
                continue;
            }
            if (variants.size() <= 1) continue;
            nonUnique.add(Pair.create((Object)marker, (Object)variants));
        }
        if (!unique.isEmpty()) {
            this.runCommand(file.getProject(), editor, () -> {
                for (Pair pair : unique) {
                    SqlIntentionUtil.qualifyReference((RangeMarker)pair.first, (Iterable)pair.second, language.getDatabaseDialect());
                }
            });
        }
        if (!nonUnique.isEmpty()) {
            this.qualifyWithChooser(file.getProject(), editor, language, nonUnique, 0);
        }
    }

    private void runCommand(Project project, Editor editor, Runnable runnable) {
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)this.getText(), (String)this.getText(), (Runnable)runnable, (PsiFile[])new PsiFile[]{PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())});
    }

    private void qualifyWithChooser(Project project, Editor editor, SqlLanguageDialectEx language, List<Pair<RangeMarker, Collection<ObjectName>>> nonUnique, int i2) {
        RangeMarker identifier = (RangeMarker)nonUnique.get((int)i2).first;
        List variants = JBIterable.from((Iterable)((Iterable)nonUnique.get((int)i2).second)).transform(Collections::singletonList).toList();
        SqlIntentionUtil.chooseQualifier(editor, identifier, variants, language.getDatabaseDialect(), (Consumer<Iterable<ObjectName>>)((Consumer)v -> {
            this.runCommand(project, editor, () -> SqlIntentionUtil.qualifyReference(identifier, v, language.getDatabaseDialect()));
            if (i2 + 1 < nonUnique.size()) {
                this.qualifyWithChooser(project, editor, language, nonUnique, i2 + 1);
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlQualifyIdentifierIntention";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentObjectNames";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentObjects";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlQualifyIdentifierIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

