/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlSpecificStubElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDefinitionImpl
extends SqlCompositeElementImpl
implements SqlDefinition,
ItemPresentation {
    private volatile String myCachedName;

    public SqlDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlDefinitionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        if (this instanceof SqlCreateStatement) {
            visitor.visitSqlCreateStatement((SqlCreateStatement)this);
        } else {
            visitor.visitSqlDefinition((SqlDefinition)this);
        }
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedName = null;
    }

    @Nullable
    public String getPresentableText() {
        return null;
    }

    @Nullable
    public String getLocationString() {
        return null;
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return this.getIcon();
    }

    @Nullable
    public Icon getIcon() {
        return DbPresentation.getIcon((DasObject)this);
    }

    @Nullable
    public Icon getIcon(int flags) {
        return this.getIcon();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        SqlNameElement element;
        if (name == null) {
            SqlDefinitionImpl.$$$reportNull$$$0(1);
        }
        if ((element = this.getNameElement()) != null) {
            element.setName(name);
        }
        return this;
    }

    @Override
    @NotNull
    public String getName() {
        String cachedName = this.myCachedName;
        if (cachedName != null) {
            String string = cachedName;
            if (string == null) {
                SqlDefinitionImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        SqlNameElement element = this.getNameElement();
        String name = element == null ? null : element.getName();
        this.myCachedName = (String)ObjectUtils.notNull((Object)name, (Object)SqlImplUtil.NULL_STRING);
        if (this.myCachedName == null) {
            SqlDefinitionImpl.$$$reportNull$$$0(3);
        }
        return this.myCachedName;
    }

    protected SqlReferenceExpression findReferenceByType(SqlReferenceElementType type) {
        return (SqlReferenceExpression)this.findChildByType((IElementType)type);
    }

    @Nullable
    public SqlNameElement getNameElement() {
        SqlReferenceElementType type = this.getExpectedNameReferenceElementType();
        if (type != null) {
            return (SqlNameElement)this.findChildrenByType((IElementType)type);
        }
        return (SqlNameElement)this.findChildByClass(SqlReferenceExpression.class);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getNameElement();
    }

    @NotNull
    public ObjectKind getKind() {
        SqlReferenceElementType type = this.getExpectedNameReferenceElementType();
        if (type != null) {
            ObjectKind objectKind = type.getTargetKind();
            if (objectKind == null) {
                SqlDefinitionImpl.$$$reportNull$$$0(4);
            }
            return objectKind;
        }
        SqlNameElement element = this.getNameElement();
        if (element == null) {
            SqlDialectImplUtil.LOG.error(((Object)((Object)this)).getClass() + "/" + this.getNode().getElementType() + "/" + (Object)((Object)SqlImplUtil.getSqlDialectSafe((PsiElement)this)) + "\n" + this.getParent().getText());
            ObjectKind objectKind = SqlDbElementType.ANY;
            if (objectKind == null) {
                SqlDefinitionImpl.$$$reportNull$$$0(5);
            }
            return objectKind;
        }
        ObjectKind objectKind = ((SqlReferenceExpression)element).getReferenceElementType().getTargetKind();
        if (objectKind == null) {
            SqlDefinitionImpl.$$$reportNull$$$0(6);
        }
        return objectKind;
    }

    @Override
    public ObjectKind getExpectedReferenceTargetType(SqlElement referenceElement) {
        if (this.getNameElement() == referenceElement) {
            return this.getKind();
        }
        return super.getExpectedReferenceTargetType(referenceElement);
    }

    @Nullable
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        SqlSpecificStubElementType type = (SqlSpecificStubElementType)((Object)ObjectUtils.tryCast((Object)PsiUtilCore.getElementType((PsiElement)this), SqlSpecificStubElementType.class));
        return type == null ? null : type.getType();
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlExpression qualifier;
        SqlNameElement nameElement = this.getNameElement();
        if (lastParent != nameElement && nameElement instanceof SqlReferenceExpression && PsiTreeUtil.isContextAncestor((PsiElement)this, (PsiElement)lastParent, (boolean)true) && (qualifier = ((SqlReferenceExpression)nameElement).getQualifierExpression()) instanceof SqlReferenceExpression && !SqlImplUtil.processQualifier((SqlReferenceExpression)qualifier, processor, state, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    public boolean isNameQuoted() {
        return DbSqlUtil.isQuoted(this.getNameElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlDefinitionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlDefinitionImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

