/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation.inspections.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.psi.XPathBinaryExpression;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.intellij.lang.xpath.validation.ExpectedTypeUtil;
import org.intellij.lang.xpath.validation.inspections.quickfix.ReplaceElementFix;
import org.jetbrains.annotations.NotNull;

public class RemoveExplicitConversionFix
extends ReplaceElementFix<XPathExpression> {
    public RemoveExplicitConversionFix(XPathExpression expression) {
        super(ExpectedTypeUtil.unparenthesize(expression));
    }

    @NotNull
    public String getText() {
        if ("Remove Explicit Type Conversion" == null) {
            RemoveExplicitConversionFix.$$$reportNull$$$0(0);
        }
        return "Remove Explicit Type Conversion";
    }

    @NotNull
    public String getFamilyName() {
        if ("ImplicitTypeConversion" == null) {
            RemoveExplicitConversionFix.$$$reportNull$$$0(1);
        }
        return "ImplicitTypeConversion";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            RemoveExplicitConversionFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            RemoveExplicitConversionFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            RemoveExplicitConversionFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            RemoveExplicitConversionFix.$$$reportNull$$$0(5);
        }
        return super.isAvailable(project, file, startElement, endElement) && ((XPathFunctionCall)startElement).getArgumentList().length == 1;
    }

    @Override
    public void invokeImpl(Project project, PsiFile file) throws IncorrectOperationException {
        PsiElement myElement = this.getStartElement();
        XPathExpression arg0 = ((XPathFunctionCall)myElement).getArgumentList()[0];
        XPathExpression outer = (XPathExpression)PsiTreeUtil.getParentOfType((PsiElement)myElement, XPathExpression.class);
        if (arg0 instanceof XPathBinaryExpression && outer instanceof XPathBinaryExpression) {
            this.replace("(" + arg0.getText() + ")");
        } else {
            this.replace(arg0.getText());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/validation/inspections/quickfix/RemoveExplicitConversionFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/validation/inspections/quickfix/RemoveExplicitConversionFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

