/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.text.DateFormatUtil;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSChangeList;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.TfsRevisionNumber;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;

public class TFSFileAnnotation
extends FileAnnotation {
    private final TFSVcs myVcs;
    private final WorkspaceInfo myWorkspace;
    private final String myAnnotatedContent;
    private final VcsFileRevision[] myLineRevisions;
    private final VirtualFile myFile;
    private final LineAnnotationAspect REVISION_ASPECT = new TFSAnnotationAspect(TFSAnnotationAspect.REVISION, false){

        public String getValue(int lineNumber) {
            VcsFileRevision fileRevision = TFSFileAnnotation.this.getLineRevision(lineNumber);
            if (fileRevision == null) {
                return "";
            }
            return ((TfsRevisionNumber)fileRevision.getRevisionNumber()).getChangesetString();
        }
    };
    private final LineAnnotationAspect DATE_ASPECT = new TFSAnnotationAspect(TFSAnnotationAspect.DATE, true){

        public String getValue(int lineNumber) {
            VcsFileRevision fileRevision = TFSFileAnnotation.this.getLineRevision(lineNumber);
            if (fileRevision == null) {
                return "";
            }
            return DateFormatUtil.formatPrettyDate((Date)fileRevision.getRevisionDate());
        }
    };
    private final LineAnnotationAspect AUTHOR_ASPECT = new TFSAnnotationAspect(TFSAnnotationAspect.AUTHOR, true){

        public String getValue(int lineNumber) {
            VcsFileRevision fileRevision = TFSFileAnnotation.this.getLineRevision(lineNumber);
            if (fileRevision == null) {
                return "";
            }
            return TfsUtil.getNameWithoutDomain(fileRevision.getAuthor());
        }
    };
    private final TFSVcs.RevisionChangedListener myListener = new TFSVcs.RevisionChangedListener(){

        @Override
        public void revisionChanged() {
            try {
                GuiUtils.runOrInvokeAndWait(() -> TFSFileAnnotation.this.close());
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };
    private static final Comparator<VcsFileRevision> REVISION_COMPARATOR = (revision1, revision2) -> -1 * revision1.getRevisionNumber().compareTo((Object)revision2.getRevisionNumber());

    public TFSFileAnnotation(TFSVcs vcs, WorkspaceInfo workspace, String annotatedContent, VcsFileRevision[] lineRevisions, VirtualFile file) {
        super(vcs.getProject());
        this.myVcs = vcs;
        this.myWorkspace = workspace;
        this.myAnnotatedContent = annotatedContent;
        this.myLineRevisions = lineRevisions;
        this.myFile = file;
        this.myVcs.addRevisionChangedListener(this.myListener);
    }

    public void dispose() {
        this.myVcs.removeRevisionChangedListener(this.myListener);
    }

    public String getAnnotatedContent() {
        return this.myAnnotatedContent;
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    @Nullable
    private VcsFileRevision getLineRevision(int lineNumber) {
        if (lineNumber < 0 || lineNumber >= this.myLineRevisions.length) {
            return null;
        }
        return this.myLineRevisions[lineNumber];
    }

    public String getToolTip(int lineNumber) {
        VcsFileRevision fileRevision = this.getLineRevision(lineNumber);
        if (fileRevision == null) {
            return "";
        }
        String commitMessage = fileRevision.getCommitMessage() == null ? "(no comment)" : fileRevision.getCommitMessage();
        return MessageFormat.format("Changeset {0}: {1}", ((TfsRevisionNumber)fileRevision.getRevisionNumber()).getChangesetString(), commitMessage);
    }

    @Nullable
    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        VcsFileRevision fileRevision = this.getLineRevision(lineNumber);
        if (fileRevision == null) {
            return null;
        }
        return fileRevision.getRevisionNumber();
    }

    public Date getLineDate(int lineNumber) {
        VcsFileRevision fileRevision = this.getLineRevision(lineNumber);
        if (fileRevision == null) {
            return null;
        }
        return fileRevision.getRevisionDate();
    }

    public List<VcsFileRevision> getRevisions() {
        HashSet<VcsFileRevision> set = new HashSet<VcsFileRevision>(Arrays.asList(this.myLineRevisions));
        ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>(set);
        Collections.sort(result, REVISION_COMPARATOR);
        return result;
    }

    public int getLineCount() {
        return this.myLineRevisions.length;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return null;
    }

    public VcsKey getVcsKey() {
        return TFSVcs.getKey();
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    private abstract class TFSAnnotationAspect
    extends LineAnnotationAspectAdapter {
        public TFSAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        protected void showAffectedPaths(int lineNum) {
            VcsFileRevision revision = TFSFileAnnotation.this.getLineRevision(lineNum);
            if (revision == null) {
                return;
            }
            int changeset = ((VcsRevisionNumber.Int)revision.getRevisionNumber()).getValue();
            TFSChangeList changeList = new TFSChangeList(TFSFileAnnotation.this.myWorkspace, changeset, revision.getAuthor(), revision.getRevisionDate(), revision.getCommitMessage(), TFSFileAnnotation.this.myVcs);
            String changesetString = ((TfsRevisionNumber)revision.getRevisionNumber()).getChangesetString();
            String progress = MessageFormat.format("Loading changeset {0}...", changesetString);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> changeList.getChanges(), progress, false, TFSFileAnnotation.this.myVcs.getProject());
            String title = MessageFormat.format("Changeset {0}", changesetString);
            AbstractVcsHelper.getInstance((Project)TFSFileAnnotation.this.myVcs.getProject()).showChangesListBrowser((CommittedChangeList)changeList, title);
        }
    }
}

