/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ChangeType_type0;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.GetOperation;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.PendingChange;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.ChangeTypeMask;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.ResultWithFailures;
import org.jetbrains.tfsIntegration.core.tfs.RootsCollection;
import org.jetbrains.tfsIntegration.core.tfs.ServerStatus;
import org.jetbrains.tfsIntegration.core.tfs.StatusProvider;
import org.jetbrains.tfsIntegration.core.tfs.StatusVisitor;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkstationHelper;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyProgress;
import org.jetbrains.tfsIntegration.core.tfs.operations.ScheduleForAddition;
import org.jetbrains.tfsIntegration.core.tfs.operations.ScheduleForDeletion;
import org.jetbrains.tfsIntegration.core.tfs.operations.UndoPendingChanges;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class TFSFileListener
extends VcsVFSListener {
    public TFSFileListener(Project project, TFSVcs vcs) {
        super(project, (AbstractVcs)vcs);
    }

    protected String getAddTitle() {
        return TFSBundle.message("add.items", new Object[0]);
    }

    protected String getSingleFileAddTitle() {
        return TFSBundle.message("add.item", new Object[0]);
    }

    protected String getSingleFileAddPromptTemplate() {
        return TFSBundle.message("add.item.prompt", new Object[0]);
    }

    protected void executeAdd() {
        try {
            WorkstationHelper.processByWorkspaces(TfsFileUtil.getFilePaths(this.myAddedFiles), false, this.myProject, new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                    StatusProvider.visitByStatus(workspace, paths, false, null, new StatusVisitor(){

                        @Override
                        public void unversioned(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(1);
                            }
                        }

                        @Override
                        public void checkedOutForEdit(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(3);
                            }
                        }

                        @Override
                        public void scheduledForAddition(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(4);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(5);
                            }
                            TFSFileListener.this.myAddedFiles.remove(localPath.getVirtualFile());
                        }

                        @Override
                        public void scheduledForDeletion(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(6);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(7);
                            }
                        }

                        @Override
                        public void outOfDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(8);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(9);
                            }
                        }

                        @Override
                        public void deleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(10);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(11);
                            }
                        }

                        @Override
                        public void upToDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatusm) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(12);
                            }
                            if (serverStatusm == null) {
                                1.$$$reportNull$$$0(13);
                            }
                        }

                        @Override
                        public void renamed(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(14);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(15);
                            }
                        }

                        @Override
                        public void renamedCheckedOut(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(16);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(17);
                            }
                        }

                        @Override
                        public void undeleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(18);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(19);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "localPath";
                                    break;
                                }
                                case 1: 
                                case 3: 
                                case 5: 
                                case 7: 
                                case 9: 
                                case 11: 
                                case 15: 
                                case 17: 
                                case 19: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "serverStatus";
                                    break;
                                }
                                case 13: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "serverStatusm";
                                    break;
                                }
                            }
                            objectArray2[1] = "org/jetbrains/tfsIntegration/core/TFSFileListener$1$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "unversioned";
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "checkedOutForEdit";
                                    break;
                                }
                                case 4: 
                                case 5: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "scheduledForAddition";
                                    break;
                                }
                                case 6: 
                                case 7: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "scheduledForDeletion";
                                    break;
                                }
                                case 8: 
                                case 9: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "outOfDate";
                                    break;
                                }
                                case 10: 
                                case 11: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "deleted";
                                    break;
                                }
                                case 12: 
                                case 13: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "upToDate";
                                    break;
                                }
                                case 14: 
                                case 15: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "renamed";
                                    break;
                                }
                                case 16: 
                                case 17: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "renamedCheckedOut";
                                    break;
                                }
                                case 18: 
                                case 19: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "undeleted";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }, TFSFileListener.this.myProject);
                }
            });
        }
        catch (TfsException e) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showError(new VcsException((Throwable)e), "TFS");
        }
        if (!this.myAddedFiles.isEmpty()) {
            super.executeAdd();
        }
    }

    protected void executeDelete() {
        ArrayList<FilePath> deletedFiles = new ArrayList<FilePath>(this.myDeletedFiles);
        deletedFiles.addAll(this.myDeletedWithoutConfirmFiles);
        try {
            WorkstationHelper.processByWorkspaces(deletedFiles, false, this.myProject, new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                    RootsCollection.ItemPathRootsCollection roots = new RootsCollection.ItemPathRootsCollection(paths);
                    Collection<PendingChange> pendingChanges = workspace.getServer().getVCS().queryPendingSetsByLocalPaths(workspace.getName(), workspace.getOwnerName(), (Collection<ItemPath>)((Object)roots), RecursionType.Full, TFSFileListener.this.myProject, TFSBundle.message("loading.changes", new Object[0]));
                    ArrayList<String> revertImmediately = new ArrayList<String>();
                    ArrayList<ItemPath> pathsToProcess = new ArrayList<ItemPath>(paths);
                    for (PendingChange pendingChange : pendingChanges) {
                        ChangeTypeMask changeType = new ChangeTypeMask(pendingChange.getChg());
                        if (!changeType.containsAny(ChangeType_type0.Add, ChangeType_type0.Undelete)) continue;
                        revertImmediately.add(pendingChange.getItem());
                        FilePath localPath = VersionControlPath.getFilePath(pendingChange.getLocal(), pendingChange.getType() == ItemType.Folder);
                        TFSFileListener.this.excludeFromFurtherProcessing(localPath);
                        ItemPath itemPath = new ItemPath(localPath, pendingChange.getItem());
                        pathsToProcess.remove(itemPath);
                    }
                    UndoPendingChanges.UndoPendingChangesResult undoResult = UndoPendingChanges.execute(TFSFileListener.this.myProject, workspace, revertImmediately, true, ApplyProgress.EMPTY, false);
                    if (!undoResult.errors.isEmpty()) {
                        AbstractVcsHelper.getInstance((Project)TFSFileListener.this.myProject).showErrors(new ArrayList<VcsException>(undoResult.errors), "TFS");
                    }
                    StatusProvider.visitByStatus(workspace, pathsToProcess, false, null, new StatusVisitor(){

                        @Override
                        public void scheduledForAddition(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            TFSVcs.error("Cannot revert an item scheduled for addition: " + localPath.getPresentableUrl());
                        }

                        @Override
                        public void unversioned(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            TFSFileListener.this.excludeFromFurtherProcessing(localPath);
                        }

                        @Override
                        public void deleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(4);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(5);
                            }
                            TFSFileListener.this.excludeFromFurtherProcessing(localPath);
                        }

                        @Override
                        public void scheduledForDeletion(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(6);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(7);
                            }
                            TFSFileListener.this.excludeFromFurtherProcessing(localPath);
                        }

                        @Override
                        public void checkedOutForEdit(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(8);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(9);
                            }
                        }

                        @Override
                        public void outOfDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(10);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(11);
                            }
                        }

                        @Override
                        public void upToDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(12);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(13);
                            }
                        }

                        @Override
                        public void renamed(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(14);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(15);
                            }
                        }

                        @Override
                        public void renamedCheckedOut(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(16);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(17);
                            }
                        }

                        @Override
                        public void undeleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(18);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(19);
                            }
                            TFSVcs.error("Cannot revert undeleted: " + localPath.getPresentableUrl());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "localPath";
                                    break;
                                }
                                case 1: 
                                case 3: 
                                case 5: 
                                case 7: 
                                case 9: 
                                case 11: 
                                case 13: 
                                case 15: 
                                case 17: 
                                case 19: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "serverStatus";
                                    break;
                                }
                            }
                            objectArray2[1] = "org/jetbrains/tfsIntegration/core/TFSFileListener$2$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "scheduledForAddition";
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "unversioned";
                                    break;
                                }
                                case 4: 
                                case 5: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "deleted";
                                    break;
                                }
                                case 6: 
                                case 7: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "scheduledForDeletion";
                                    break;
                                }
                                case 8: 
                                case 9: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "checkedOutForEdit";
                                    break;
                                }
                                case 10: 
                                case 11: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "outOfDate";
                                    break;
                                }
                                case 12: 
                                case 13: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "upToDate";
                                    break;
                                }
                                case 14: 
                                case 15: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "renamed";
                                    break;
                                }
                                case 16: 
                                case 17: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "renamedCheckedOut";
                                    break;
                                }
                                case 18: 
                                case 19: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "undeleted";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }, TFSFileListener.this.myProject);
                }
            });
        }
        catch (TfsException e) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showError(new VcsException((Throwable)e), "TFS");
        }
        if (!this.myDeletedFiles.isEmpty() || !this.myDeletedWithoutConfirmFiles.isEmpty()) {
            super.executeDelete();
        }
    }

    protected void performDeletion(List<FilePath> filesToDelete) {
        final ArrayList<VcsException> errors = new ArrayList<VcsException>();
        try {
            WorkstationHelper.processByWorkspaces(filesToDelete, false, this.myProject, new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) {
                    Collection<VcsException> scheduleErrors = ScheduleForDeletion.execute(TFSFileListener.this.myProject, workspace, paths);
                    errors.addAll(scheduleErrors);
                }
            });
        }
        catch (TfsException e) {
            errors.add(new VcsException((Throwable)e));
        }
        if (!errors.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(errors, "TFS");
        }
    }

    private void excludeFromFurtherProcessing(FilePath localPath) {
        if (!this.myDeletedFiles.remove(localPath)) {
            this.myDeletedWithoutConfirmFiles.remove(localPath);
        }
    }

    protected void performAdding(Collection<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copyFromMap) {
        final ArrayList<VcsException> errors = new ArrayList<VcsException>();
        try {
            List<FilePath> orphans = WorkstationHelper.processByWorkspaces(TfsFileUtil.getFilePaths(addedFiles), false, this.myProject, new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) {
                    Collection<VcsException> schedulingErrors = ScheduleForAddition.execute(TFSFileListener.this.myProject, workspace, paths);
                    errors.addAll(schedulingErrors);
                }
            });
            if (!orphans.isEmpty()) {
                StringBuilder s = new StringBuilder();
                for (FilePath orpan : orphans) {
                    if (s.length() > 0) {
                        s.append("\n");
                    }
                    s.append(orpan.getPresentableUrl());
                }
                errors.add(new VcsException("Team Foundation Server mappings not found for: " + s.toString()));
            }
        }
        catch (TfsException e) {
            errors.add(new VcsException((Throwable)e));
        }
        if (!errors.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(errors, "TFS");
        }
    }

    protected String getDeleteTitle() {
        return "Do you want to schedule these items for deletion from TFS?";
    }

    protected String getSingleFileDeleteTitle() {
        return null;
    }

    protected String getSingleFileDeletePromptTemplate() {
        return null;
    }

    protected void performMoveRename(List<VcsVFSListener.MovedFileInfo> movedFiles) {
        final HashMap<FilePath, FilePath> movedPaths = new HashMap<FilePath, FilePath>(movedFiles.size());
        for (VcsVFSListener.MovedFileInfo movedFileInfo : movedFiles) {
            movedPaths.put(VcsUtil.getFilePath((String)movedFileInfo.myOldPath), VcsUtil.getFilePath((String)movedFileInfo.myNewPath));
        }
        final ArrayList<VcsException> errors = new ArrayList<VcsException>();
        final HashMap scheduleMove = new HashMap();
        try {
            WorkstationHelper.processByWorkspaces(movedPaths.keySet(), false, this.myProject, new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                    StatusProvider.visitByStatus(workspace, paths, false, null, new StatusVisitor(){

                        @Override
                        public void unversioned(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(1);
                            }
                        }

                        @Override
                        public void checkedOutForEdit(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            scheduleMove.put(localPath, movedPaths.get(localPath));
                        }

                        @Override
                        public void scheduledForAddition(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(4);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(5);
                            }
                            scheduleMove.put(localPath, movedPaths.get(localPath));
                        }

                        @Override
                        public void scheduledForDeletion(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(6);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(7);
                            }
                            TFSVcs.error("Cannot rename a file that does not exist on local machine: " + localPath.getPresentableUrl());
                        }

                        @Override
                        public void outOfDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(8);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(9);
                            }
                            scheduleMove.put(localPath, movedPaths.get(localPath));
                        }

                        @Override
                        public void deleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(10);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(11);
                            }
                        }

                        @Override
                        public void upToDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(12);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(13);
                            }
                            scheduleMove.put(localPath, movedPaths.get(localPath));
                        }

                        @Override
                        public void renamed(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(14);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(15);
                            }
                            scheduleMove.put(localPath, movedPaths.get(localPath));
                        }

                        @Override
                        public void renamedCheckedOut(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(16);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(17);
                            }
                            scheduleMove.put(localPath, movedPaths.get(localPath));
                        }

                        @Override
                        public void undeleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                            if (localPath == null) {
                                1.$$$reportNull$$$0(18);
                            }
                            if (serverStatus == null) {
                                1.$$$reportNull$$$0(19);
                            }
                            scheduleMove.put(localPath, movedPaths.get(localPath));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "localPath";
                                    break;
                                }
                                case 1: 
                                case 3: 
                                case 5: 
                                case 7: 
                                case 9: 
                                case 11: 
                                case 13: 
                                case 15: 
                                case 17: 
                                case 19: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "serverStatus";
                                    break;
                                }
                            }
                            objectArray2[1] = "org/jetbrains/tfsIntegration/core/TFSFileListener$5$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "unversioned";
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "checkedOutForEdit";
                                    break;
                                }
                                case 4: 
                                case 5: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "scheduledForAddition";
                                    break;
                                }
                                case 6: 
                                case 7: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "scheduledForDeletion";
                                    break;
                                }
                                case 8: 
                                case 9: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "outOfDate";
                                    break;
                                }
                                case 10: 
                                case 11: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "deleted";
                                    break;
                                }
                                case 12: 
                                case 13: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "upToDate";
                                    break;
                                }
                                case 14: 
                                case 15: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "renamed";
                                    break;
                                }
                                case 16: 
                                case 17: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "renamedCheckedOut";
                                    break;
                                }
                                case 18: 
                                case 19: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "undeleted";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }, TFSFileListener.this.myProject);
                    ResultWithFailures<GetOperation> renameResult = workspace.getServer().getVCS().renameAndUpdateLocalVersion(workspace.getName(), workspace.getOwnerName(), scheduleMove, TFSFileListener.this.myProject, TFSBundle.message("renaming", new Object[0]));
                    errors.addAll(TfsUtil.getVcsExceptions(renameResult.getFailures()));
                    ArrayList<FilePath> invalidate = new ArrayList<FilePath>(renameResult.getResult().size());
                    for (GetOperation getOperation : renameResult.getResult()) {
                        invalidate.add(VersionControlPath.getFilePath(getOperation.getTlocal(), getOperation.getType() == ItemType.Folder));
                    }
                    TfsFileUtil.markDirtyRecursively(TFSFileListener.this.myProject, invalidate);
                }
            });
        }
        catch (TfsException e) {
            errors.add(new VcsException((Throwable)e));
        }
        if (!errors.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(errors, "TFS");
        }
    }

    protected boolean isDirectoryVersioningSupported() {
        return true;
    }
}

