/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ObjectUtils;
import com.microsoft.tfs.core.config.persistence.DefaultPersistenceStoreProvider;
import com.microsoft.tfs.core.httpclient.DefaultNTCredentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.configuration.Credentials;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;

public class TfsSdkManager {
    private TfsSdkManager() {
        TfsSdkManager.setupNativeLibrariesPath();
    }

    @NotNull
    public Path getCacheFile() {
        Path path = DefaultPersistenceStoreProvider.INSTANCE.getCachePersistenceStore().getStoreFile().toPath().resolve("VersionControl.config");
        if (path == null) {
            TfsSdkManager.$$$reportNull$$$0(0);
        }
        return path;
    }

    @NotNull
    public com.microsoft.tfs.core.httpclient.Credentials getCredentials(@NotNull ServerInfo server) {
        DefaultNTCredentials result;
        if (server == null) {
            TfsSdkManager.$$$reportNull$$$0(1);
        }
        Credentials credentials = (Credentials)ObjectUtils.assertNotNull((Object)TFSConfigurationManager.getInstance().getCredentials(server.getUri()));
        switch (credentials.getType()) {
            case NtlmNative: {
                result = new DefaultNTCredentials();
                break;
            }
            case NtlmExplicit: 
            case Alternate: {
                result = new UsernamePasswordCredentials(credentials.getQualifiedUsername(), credentials.getPassword());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown credentials type " + (Object)((Object)credentials.getType()));
            }
        }
        DefaultNTCredentials defaultNTCredentials = result;
        if (defaultNTCredentials == null) {
            TfsSdkManager.$$$reportNull$$$0(2);
        }
        return defaultNTCredentials;
    }

    @NotNull
    public static TfsSdkManager getInstance() {
        TfsSdkManager tfsSdkManager = (TfsSdkManager)ServiceManager.getService(TfsSdkManager.class);
        if (tfsSdkManager == null) {
            TfsSdkManager.$$$reportNull$$$0(3);
        }
        return tfsSdkManager;
    }

    public static void activate() {
        TfsSdkManager.getInstance();
    }

    private static void setupNativeLibrariesPath() {
        File nativeLibrariesPath = new File(TfsSdkManager.getPluginDirectory(), FileUtil.toSystemDependentName((String)"lib/native"));
        System.setProperty("com.microsoft.tfs.jni.native.base-directory", nativeLibrariesPath.getPath());
    }

    @NotNull
    private static File getPluginDirectory() {
        PluginId pluginId = PluginId.getId((String)"TFS");
        IdeaPluginDescriptor pluginDescriptor = (IdeaPluginDescriptor)ObjectUtils.assertNotNull((Object)PluginManager.getPlugin((PluginId)pluginId));
        File file = pluginDescriptor.isBundled() ? PluginPathManager.getPluginHome((String)"tfsIntegration") : (File)ObjectUtils.assertNotNull((Object)pluginDescriptor.getPath());
        if (file == null) {
            TfsSdkManager.$$$reportNull$$$0(4);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/tfsIntegration/core/TfsSdkManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/tfsIntegration/core/TfsSdkManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentials";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCredentials";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

