/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.diagnostic.Logger;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Workspace;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TfsBeansHolder;
import org.jetbrains.tfsIntegration.core.configuration.Credentials;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlServer;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.Workstation;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.exceptions.WorkspaceNotFoundException;

public class ServerInfo {
    private static final Logger LOG = Logger.getInstance((String)ServerInfo.class.getName());
    private final URI myUri;
    private final String myGuid;
    private VersionControlServer myServer;
    private final List<WorkspaceInfo> myWorkspaceInfos = new ArrayList<WorkspaceInfo>();
    private final TfsBeansHolder myBeans;

    public ServerInfo(URI uri, String guid, TfsBeansHolder beans) {
        this.myUri = uri;
        this.myGuid = guid;
        this.myBeans = beans;
    }

    public ServerInfo(URI uri, String guid, @Nullable Workspace[] workspaces, String authorizedUsername, TfsBeansHolder beans) {
        this(uri, guid, beans);
        if (workspaces != null) {
            for (Workspace workspace : workspaces) {
                WorkspaceInfo workspaceInfo = new WorkspaceInfo(this, authorizedUsername, Workstation.getComputerName());
                WorkspaceInfo.fromBean(workspace, workspaceInfo);
                this.addWorkspaceInfo(workspaceInfo);
            }
        }
    }

    public void addWorkspaceInfo(@NotNull WorkspaceInfo workspaceInfo) {
        if (workspaceInfo == null) {
            ServerInfo.$$$reportNull$$$0(0);
        }
        this.myWorkspaceInfos.add(workspaceInfo);
    }

    public URI getUri() {
        return this.myUri;
    }

    public String getPresentableUri() {
        return TfsUtil.getPresentableUri(this.myUri);
    }

    public String getGuid() {
        return this.myGuid;
    }

    @Nullable
    public String getQualifiedUsername() {
        Credentials credentials = TFSConfigurationManager.getInstance().getCredentials(this.getUri());
        return credentials != null ? credentials.getQualifiedUsername() : null;
    }

    public List<WorkspaceInfo> getWorkspacesForCurrentOwnerAndComputer() {
        ArrayList<WorkspaceInfo> result = new ArrayList<WorkspaceInfo>();
        List<WorkspaceInfo> workspaces = this.getWorkspaces();
        for (WorkspaceInfo workspaceInfo : workspaces) {
            if (!workspaceInfo.hasCurrentOwnerAndComputer()) continue;
            result.add(workspaceInfo);
        }
        return Collections.unmodifiableList(result);
    }

    public List<WorkspaceInfo> getWorkspaces() {
        return Collections.unmodifiableList(this.myWorkspaceInfos);
    }

    public void deleteWorkspace(WorkspaceInfo workspaceInfo, Object projectOrComponent, boolean force) throws TfsException {
        try {
            this.getVCS().deleteWorkspace(workspaceInfo.getName(), workspaceInfo.getOwnerName(), projectOrComponent, force);
        }
        catch (WorkspaceNotFoundException workspaceNotFoundException) {
            // empty catch block
        }
        this.myWorkspaceInfos.remove(workspaceInfo);
        Workstation.getInstance().update();
    }

    @NotNull
    public VersionControlServer getVCS() {
        if (this.myServer == null) {
            this.myServer = new VersionControlServer(this.myUri, this.myBeans, this.myGuid);
        }
        VersionControlServer versionControlServer = this.myServer;
        if (versionControlServer == null) {
            ServerInfo.$$$reportNull$$$0(1);
        }
        return versionControlServer;
    }

    public void refreshWorkspacesForCurrentOwnerAndComputer(Object projectOrComponent, boolean force) throws TfsException {
        Workspace[] newWorkspaces = this.getVCS().queryWorkspaces(Workstation.getComputerName(), projectOrComponent, force);
        String owner = this.getQualifiedUsername();
        LOG.assertTrue(owner != null);
        Iterator<WorkspaceInfo> i = this.myWorkspaceInfos.iterator();
        while (i.hasNext()) {
            WorkspaceInfo workspaceInfo = i.next();
            if (!workspaceInfo.hasCurrentOwnerAndComputer()) continue;
            i.remove();
        }
        for (Workspace workspace : newWorkspaces) {
            WorkspaceInfo workspaceInfo = new WorkspaceInfo(this, owner, Workstation.getComputerName());
            WorkspaceInfo.fromBean(workspace, workspaceInfo);
            this.addWorkspaceInfo(workspaceInfo);
        }
        Workstation.getInstance().update();
    }

    public void replaceWorkspace(@NotNull WorkspaceInfo existingWorkspace, @NotNull WorkspaceInfo newWorkspace) {
        if (existingWorkspace == null) {
            ServerInfo.$$$reportNull$$$0(2);
        }
        if (newWorkspace == null) {
            ServerInfo.$$$reportNull$$$0(3);
        }
        this.myWorkspaceInfos.set(this.myWorkspaceInfos.indexOf(existingWorkspace), newWorkspace);
    }

    public String toString() {
        return "ServerInfo[uri=" + this.getUri() + ",guid=" + this.getGuid() + "," + this.getWorkspaces().size() + " workspaces]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerInfo that = (ServerInfo)o;
        return this.myGuid.equals(that.myGuid);
    }

    public int hashCode() {
        return this.myGuid.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/tfsIntegration/core/tfs/ServerInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingWorkspace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newWorkspace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/ServerInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVCS";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addWorkspaceInfo";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceWorkspace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

