/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.vcs.FilePath;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.PendingChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.StatusVisitor;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public abstract class ServerStatus {
    public final int localVer;
    public final int itemId;
    public final boolean isDirectory;
    @Nullable
    public final String sourceItem;
    @Nullable
    public final String targetItem;

    protected ServerStatus(int localVer, int itemId, boolean isDirectory, String sourceItem, String targetItem) {
        this.localVer = localVer;
        this.itemId = itemId;
        this.isDirectory = isDirectory;
        this.sourceItem = sourceItem;
        this.targetItem = targetItem;
    }

    protected ServerStatus(@NotNull PendingChange pendingChange) {
        if (pendingChange == null) {
            ServerStatus.$$$reportNull$$$0(0);
        }
        this(pendingChange.getVer(), pendingChange.getItemid(), pendingChange.getType() == ItemType.Folder, pendingChange.getSrcitem(), pendingChange.getItem());
    }

    protected ServerStatus(@NotNull ExtendedItem extendedItem) {
        if (extendedItem == null) {
            ServerStatus.$$$reportNull$$$0(1);
        }
        this(extendedItem.getLver(), extendedItem.getItemid(), extendedItem.getType() == ItemType.Folder, extendedItem.getSitem(), extendedItem.getTitem());
    }

    public abstract void visitBy(@NotNull FilePath var1, boolean var2, @NotNull StatusVisitor var3) throws TfsException;

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf("$") + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "pendingChange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "extendedItem";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/tfsIntegration/core/tfs/ServerStatus";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Undeleted
    extends ServerStatus {
        protected Undeleted(@NotNull PendingChange pendingChange) {
            if (pendingChange == null) {
                Undeleted.$$$reportNull$$$0(0);
            }
            super(pendingChange);
        }

        public Undeleted(@NotNull ExtendedItem item) {
            if (item == null) {
                Undeleted.$$$reportNull$$$0(1);
            }
            super(item);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                Undeleted.$$$reportNull$$$0(2);
            }
            if (statusVisitor == null) {
                Undeleted.$$$reportNull$$$0(3);
            }
            statusVisitor.undeleted(localPath, localItemExists, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pendingChange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusVisitor";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$Undeleted";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RenamedCheckedOut
    extends ServerStatus {
        protected RenamedCheckedOut(@NotNull PendingChange pendingChange) {
            if (pendingChange == null) {
                RenamedCheckedOut.$$$reportNull$$$0(0);
            }
            super(pendingChange);
        }

        public RenamedCheckedOut(@NotNull ExtendedItem item) {
            if (item == null) {
                RenamedCheckedOut.$$$reportNull$$$0(1);
            }
            super(item);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                RenamedCheckedOut.$$$reportNull$$$0(2);
            }
            if (statusVisitor == null) {
                RenamedCheckedOut.$$$reportNull$$$0(3);
            }
            statusVisitor.renamedCheckedOut(localPath, localItemExists, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pendingChange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusVisitor";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$RenamedCheckedOut";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Renamed
    extends ServerStatus {
        protected Renamed(@NotNull PendingChange pendingChange) {
            if (pendingChange == null) {
                Renamed.$$$reportNull$$$0(0);
            }
            super(pendingChange);
        }

        public Renamed(@NotNull ExtendedItem item) {
            if (item == null) {
                Renamed.$$$reportNull$$$0(1);
            }
            super(item);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                Renamed.$$$reportNull$$$0(2);
            }
            if (statusVisitor == null) {
                Renamed.$$$reportNull$$$0(3);
            }
            statusVisitor.renamed(localPath, localItemExists, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pendingChange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusVisitor";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$Renamed";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UpToDate
    extends ServerStatus {
        protected UpToDate(@NotNull ExtendedItem extendedItem) {
            if (extendedItem == null) {
                UpToDate.$$$reportNull$$$0(0);
            }
            super(extendedItem);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                UpToDate.$$$reportNull$$$0(1);
            }
            if (statusVisitor == null) {
                UpToDate.$$$reportNull$$$0(2);
            }
            statusVisitor.upToDate(localPath, localItemExists, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extendedItem";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusVisitor";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$UpToDate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OutOfDate
    extends ServerStatus {
        protected OutOfDate(@NotNull ExtendedItem extendedItem) {
            if (extendedItem == null) {
                OutOfDate.$$$reportNull$$$0(0);
            }
            super(extendedItem);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                OutOfDate.$$$reportNull$$$0(1);
            }
            if (statusVisitor == null) {
                OutOfDate.$$$reportNull$$$0(2);
            }
            statusVisitor.outOfDate(localPath, localItemExists, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extendedItem";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusVisitor";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$OutOfDate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ScheduledForDeletion
    extends ServerStatus {
        protected ScheduledForDeletion(@NotNull PendingChange pendingChange) {
            if (pendingChange == null) {
                ScheduledForDeletion.$$$reportNull$$$0(0);
            }
            super(pendingChange);
        }

        public ScheduledForDeletion(@NotNull ExtendedItem item) {
            if (item == null) {
                ScheduledForDeletion.$$$reportNull$$$0(1);
            }
            super(item);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                ScheduledForDeletion.$$$reportNull$$$0(2);
            }
            if (statusVisitor == null) {
                ScheduledForDeletion.$$$reportNull$$$0(3);
            }
            statusVisitor.scheduledForDeletion(localPath, localItemExists, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pendingChange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusVisitor";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$ScheduledForDeletion";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ScheduledForAddition
    extends ServerStatus {
        protected ScheduledForAddition(@NotNull PendingChange pendingChange) {
            if (pendingChange == null) {
                ScheduledForAddition.$$$reportNull$$$0(0);
            }
            super(pendingChange);
        }

        protected ScheduledForAddition(@NotNull ExtendedItem extendedItem) {
            if (extendedItem == null) {
                ScheduledForAddition.$$$reportNull$$$0(1);
            }
            super(extendedItem);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                ScheduledForAddition.$$$reportNull$$$0(2);
            }
            if (statusVisitor == null) {
                ScheduledForAddition.$$$reportNull$$$0(3);
            }
            statusVisitor.scheduledForAddition(localPath, localItemExists, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pendingChange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extendedItem";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusVisitor";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$ScheduledForAddition";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CheckedOutForEdit
    extends ServerStatus {
        protected CheckedOutForEdit(@NotNull PendingChange pendingChange) {
            if (pendingChange == null) {
                CheckedOutForEdit.$$$reportNull$$$0(0);
            }
            super(pendingChange);
        }

        public CheckedOutForEdit(@NotNull ExtendedItem item) {
            if (item == null) {
                CheckedOutForEdit.$$$reportNull$$$0(1);
            }
            super(item);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                CheckedOutForEdit.$$$reportNull$$$0(2);
            }
            if (statusVisitor == null) {
                CheckedOutForEdit.$$$reportNull$$$0(3);
            }
            statusVisitor.checkedOutForEdit(localPath, localItemExists, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pendingChange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusVisitor";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$CheckedOutForEdit";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Unversioned
    extends ServerStatus {
        public static final ServerStatus INSTANCE = new Unversioned();

        private Unversioned() {
            super(0, 0, false, null, null);
        }

        @Override
        public void visitBy(@NotNull FilePath localPath, boolean localItemExists, @NotNull StatusVisitor statusVisitor) throws TfsException {
            if (localPath == null) {
                Unversioned.$$$reportNull$$$0(0);
            }
            if (statusVisitor == null) {
                Unversioned.$$$reportNull$$$0(1);
            }
            statusVisitor.unversioned(localPath, localItemExists, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "statusVisitor";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/tfsIntegration/core/tfs/ServerStatus$Unversioned";
            objectArray[2] = "visitBy";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

