/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.UriUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ArrayOfString;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.DeletedState;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Failure;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.SeverityType;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.revision.TFSContentRevision;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.TfsRevisionNumber;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.Workstation;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class TfsUtil {
    private static final Logger LOG = Logger.getInstance((String)TfsUtil.class.getName());
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"TFS", (String)ToolWindowId.VCS);

    @Nullable
    public static Pair<WorkspaceInfo, ExtendedItem> getWorkspaceAndExtendedItem(FilePath localPath, Object projectOrComponent, String progressTitle) throws TfsException {
        Collection<WorkspaceInfo> workspaces = Workstation.getInstance().findWorkspaces(localPath, false, projectOrComponent);
        if (workspaces.isEmpty()) {
            return null;
        }
        WorkspaceInfo workspace = workspaces.iterator().next();
        ExtendedItem item = workspace.getServer().getVCS().getExtendedItem(workspace.getName(), workspace.getOwnerName(), localPath, RecursionType.None, DeletedState.Any, projectOrComponent, progressTitle);
        return Pair.create((Object)workspace, (Object)item);
    }

    public static VcsRevisionNumber getCurrentRevisionNumber(FilePath path, Object projectOrComponent, String progressTitle) {
        try {
            Pair<WorkspaceInfo, ExtendedItem> workspaceAndItem = TfsUtil.getWorkspaceAndExtendedItem(path, projectOrComponent, progressTitle);
            return workspaceAndItem != null && workspaceAndItem.second != null ? TfsUtil.getCurrentRevisionNumber((ExtendedItem)workspaceAndItem.second) : VcsRevisionNumber.NULL;
        }
        catch (TfsException e) {
            return VcsRevisionNumber.NULL;
        }
    }

    @Nullable
    public static TFSContentRevision getCurrentRevision(Project project, FilePath path, String progressTitle) throws TfsException {
        Pair<WorkspaceInfo, ExtendedItem> workspaceAndItem = TfsUtil.getWorkspaceAndExtendedItem(path, project, progressTitle);
        if (workspaceAndItem != null && workspaceAndItem.second != null) {
            return TFSContentRevision.create(project, (WorkspaceInfo)workspaceAndItem.first, ((ExtendedItem)workspaceAndItem.second).getLver(), ((ExtendedItem)workspaceAndItem.second).getItemid());
        }
        return null;
    }

    public static VcsRevisionNumber getCurrentRevisionNumber(@NotNull ExtendedItem item) {
        if (item == null) {
            TfsUtil.$$$reportNull$$$0(0);
        }
        return item.getLver() != Integer.MIN_VALUE ? new TfsRevisionNumber(item.getLver(), item.getItemid()) : VcsRevisionNumber.NULL;
    }

    public static VcsException collectExceptions(Collection<VcsException> exceptions) {
        if (exceptions.isEmpty()) {
            throw new IllegalArgumentException("No exceptions to collect");
        }
        if (exceptions.size() == 1) {
            return exceptions.iterator().next();
        }
        StringBuilder s = new StringBuilder();
        for (VcsException exception : exceptions) {
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append(exception.getMessage());
        }
        return new VcsException(s.toString());
    }

    public static List<FilePath> getLocalPaths(List<ItemPath> paths) {
        ArrayList<FilePath> localPaths = new ArrayList<FilePath>(paths.size());
        for (ItemPath path : paths) {
            localPaths.add(path.getLocalPath());
        }
        return localPaths;
    }

    public static Calendar getZeroCalendar() {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.set(1, 0, 1, 0, 0, 0);
        return calendar;
    }

    public static List<VcsException> getVcsExceptions(Collection<Failure> failures) {
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        for (Failure failure : failures) {
            if (failure.getSev() == SeverityType.Warning) continue;
            exceptions.add(new VcsException(failure.getMessage()));
        }
        return exceptions;
    }

    public static String getNameWithoutDomain(String qualifiedName) {
        int slashIndex = qualifiedName.indexOf(92);
        if (slashIndex > -1 && slashIndex < qualifiedName.length() - 1) {
            return qualifiedName.substring(slashIndex + 1);
        }
        return qualifiedName;
    }

    @Nullable
    public static URI getUrl(String uriText, boolean complainOnPath, boolean trimPath) {
        int i = uriText.indexOf("://");
        try {
            URI uri = i == -1 ? new URI("http", "//" + uriText, null).normalize() : new URI(uriText.substring(0, i), "//" + uriText.substring(i + "://".length()), null).normalize();
            if (StringUtil.isEmpty((String)uri.getHost())) {
                return null;
            }
            int port = uri.getPort();
            if (port > 65535) {
                return null;
            }
            if (complainOnPath && uri.getPath() != null && !uri.getPath().isEmpty() && !"/".equals(uri.getPath())) {
                return null;
            }
            if (trimPath) {
                return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), "/", null, null);
            }
            return uri;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static void showBalloon(Project project, MessageType messageType, String messageHtml) {
        NOTIFICATION_GROUP.createNotification(messageHtml, messageType).notify(project);
    }

    public static String getPresentableUri(URI uri) {
        try {
            return URLDecoder.decode(uri.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static String getQualifiedUsername(String domain, String userName) {
        return domain + "\\" + userName;
    }

    public static <T, E extends Throwable> void consumeInParts(List<T> items, int maxPartSize, ThrowableConsumer<List<T>, E> consumer) throws E {
        for (int group = 0; group <= items.size() / maxPartSize; ++group) {
            List<T> subList = items.subList(group * maxPartSize, Math.min((group + 1) * maxPartSize, items.size()));
            if (subList.isEmpty()) continue;
            consumer.consume(subList);
        }
    }

    public static String appendPath(URI serverUri, String path) {
        path = StringUtil.trimStart((String)path, (String)"/");
        return UriUtil.trimTrailingSlashes((String)serverUri.toString()) + "/" + path.replace(" ", "%20");
    }

    public static <T, E extends Throwable> T forcePluginClassLoader(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            TfsUtil.$$$reportNull$$$0(1);
        }
        return (T)ClassLoaderUtil.runWithClassLoader(null, computable);
    }

    public static <E extends Throwable> void forcePluginClassLoader(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            TfsUtil.$$$reportNull$$$0(2);
        }
        ClassLoaderUtil.runWithClassLoader(null, runnable);
    }

    @Contract(pure=true, value="null -> null; !null -> !null")
    public static ArrayOfString toArrayOfString(@Nullable Collection<String> values) {
        ArrayOfString result = null;
        if (values != null) {
            result = new ArrayOfString();
            result.setString(ArrayUtil.toStringArray(values));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/TfsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentRevisionNumber";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "forcePluginClassLoader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

