/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.config.TfsServerConnectionHelper;
import org.jetbrains.tfsIntegration.core.TfsSdkManager;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.WorkingFolderInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkstationCacheReader;
import org.jetbrains.tfsIntegration.exceptions.DuplicateMappingException;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.exceptions.WorkspaceHasNoMappingException;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class Workstation {
    public static boolean PRESERVE_CONFIG_FILE = false;
    private static final Logger LOG = Logger.getInstance((String)Workstation.class.getName());
    @NotNull
    private final List<ServerInfo> myServerInfos = Workstation.loadCache();
    @Nullable
    private Ref<FilePath> myDuplicateMappedPath;
    private static String ourComputerName;

    private Workstation() {
    }

    @NotNull
    public static Workstation getInstance() {
        Workstation workstation = WorkstationHolder.ourInstance;
        if (workstation == null) {
            Workstation.$$$reportNull$$$0(0);
        }
        return workstation;
    }

    @NotNull
    public List<ServerInfo> getServers() {
        List<ServerInfo> list = Collections.unmodifiableList(this.myServerInfos);
        if (list == null) {
            Workstation.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public ServerInfo getServer(@NotNull URI uri) {
        if (uri == null) {
            Workstation.$$$reportNull$$$0(2);
        }
        return (ServerInfo)ContainerUtil.find(this.getServers(), serverInfo -> {
            if (uri == null) {
                Workstation.$$$reportNull$$$0(20);
            }
            return serverInfo.getUri().equals(uri);
        });
    }

    @NotNull
    private List<WorkspaceInfo> getAllWorkspacesForCurrentOwnerAndComputer(boolean showLoginIfNoCredentials) {
        ArrayList result = ContainerUtil.newArrayList();
        for (ServerInfo server : this.getServers()) {
            if (showLoginIfNoCredentials && server.getQualifiedUsername() == null) {
                try {
                    TfsServerConnectionHelper.ensureAuthenticated(null, server.getUri(), false);
                }
                catch (TfsException e) {
                    continue;
                }
            }
            result.addAll(server.getWorkspacesForCurrentOwnerAndComputer());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            Workstation.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private static List<ServerInfo> loadCache() {
        Path cacheFile = Workstation.getCacheFile(true);
        if (cacheFile != null) {
            List<ServerInfo> list;
            try {
                WorkstationCacheReader reader = new WorkstationCacheReader();
                try (BufferedReader stream = Files.newBufferedReader(cacheFile);){
                    TfsUtil.forcePluginClassLoader(() -> SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(stream), (DefaultHandler)reader));
                }
                list = reader.getServers();
            }
            catch (Exception e) {
                LOG.info("Cannot read workspace cache", (Throwable)e);
            }
            if (list == null) {
                Workstation.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList arrayList = ContainerUtil.newArrayList();
        if (arrayList == null) {
            Workstation.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private static Path getCacheFile(boolean existingOnly) {
        if (PRESERVE_CONFIG_FILE) {
            return null;
        }
        Path cacheFile = TfsSdkManager.getInstance().getCacheFile();
        return Files.exists(cacheFile, new LinkOption[0]) || !existingOnly ? cacheFile : null;
    }

    void update() {
        this.invalidateDuplicateMappedPath();
        Path cacheFile = Workstation.getCacheFile(false);
        if (cacheFile != null) {
            try {
                Element serversElement = new Element("Servers");
                for (ServerInfo serverInfo : this.getServers()) {
                    Element serverInfoElement = new Element("ServerInfo").setAttribute("uri", serverInfo.getUri().toString()).setAttribute("repositoryGuid", serverInfo.getGuid());
                    serversElement.addContent(serverInfoElement);
                    for (WorkspaceInfo workspaceInfo : serverInfo.getWorkspaces()) {
                        Element workspaceInfoElement = new Element("WorkspaceInfo").setAttribute("computer", workspaceInfo.getComputer()).setAttribute("ownerName", workspaceInfo.getOwnerName()).setAttribute("LastSavedCheckinTimeStamp", ConverterUtil.convertToString((Calendar)workspaceInfo.getTimestamp())).setAttribute("name", workspaceInfo.getName()).setAttribute("isLocalWorkspace", String.valueOf(workspaceInfo.isLocal())).setAttribute("options", String.valueOf(workspaceInfo.getOptions())).setAttribute("comment", StringUtil.notNullize((String)workspaceInfo.getComment())).setAttribute("ownerDisplayName", StringUtil.notNullize((String)workspaceInfo.getOwnerDisplayName()));
                        Workstation.setIfNotNull(workspaceInfoElement, "securityToken", workspaceInfo.getSecurityToken());
                        Workstation.addItems(workspaceInfoElement, "MappedPaths", "MappedPath", "path", workspaceInfo.getWorkingFoldersCached(), folderInfo -> folderInfo.getLocalPath().getPresentableUrl());
                        Workstation.addItems(workspaceInfoElement, "OwnerAliases", "OwnerAlias", "OwnerAlias", workspaceInfo.getOwnerAliases(), Functions.TO_STRING());
                        serverInfoElement.addContent(workspaceInfoElement);
                    }
                }
                JdomKt.write((Parent)new Element("VersionControlServer").addContent(serversElement), (Path)cacheFile);
            }
            catch (IOException e) {
                LOG.info("Cannot update workspace cache", (Throwable)e);
            }
        }
    }

    private static <T> void addItems(@NotNull Element parentElement, @NotNull String elementName, @NotNull String itemElementName, @NotNull String itemAttributeName, @NotNull List<T> items, @NotNull Function<T, String> valueProvider) {
        if (parentElement == null) {
            Workstation.$$$reportNull$$$0(6);
        }
        if (elementName == null) {
            Workstation.$$$reportNull$$$0(7);
        }
        if (itemElementName == null) {
            Workstation.$$$reportNull$$$0(8);
        }
        if (itemAttributeName == null) {
            Workstation.$$$reportNull$$$0(9);
        }
        if (items == null) {
            Workstation.$$$reportNull$$$0(10);
        }
        if (valueProvider == null) {
            Workstation.$$$reportNull$$$0(11);
        }
        Element element = new Element(elementName);
        parentElement.addContent(element);
        for (T item : items) {
            element.addContent(new Element(itemElementName).setAttribute(itemAttributeName, StringUtil.notNullize((String)((String)valueProvider.fun(item)))));
        }
    }

    private static void setIfNotNull(@NotNull Element element, @NotNull String attributeName, @Nullable String value) {
        if (element == null) {
            Workstation.$$$reportNull$$$0(12);
        }
        if (attributeName == null) {
            Workstation.$$$reportNull$$$0(13);
        }
        if (value != null) {
            element.setAttribute(attributeName, value);
        }
    }

    public void addServer(ServerInfo serverInfo) {
        this.myServerInfos.add(serverInfo);
        this.update();
    }

    public void removeServer(ServerInfo serverInfo) {
        this.myServerInfos.remove(serverInfo);
        TFSConfigurationManager.getInstance().remove(serverInfo.getUri());
        this.update();
    }

    public static synchronized String getComputerName() {
        if (ourComputerName == null) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                String hostName = address.getHostName();
                int i = hostName.indexOf(46);
                if (i != -1) {
                    hostName = hostName.substring(0, i);
                }
                ourComputerName = hostName;
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Cannot retrieve host name.");
            }
        }
        return ourComputerName;
    }

    @NotNull
    public Collection<WorkspaceInfo> findWorkspacesCached(@NotNull FilePath localPath, boolean considerChildMappings) {
        if (localPath == null) {
            Workstation.$$$reportNull$$$0(14);
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (WorkspaceInfo workspace : this.getAllWorkspacesForCurrentOwnerAndComputer(false)) {
            if (!workspace.hasMappingCached(localPath, considerChildMappings)) continue;
            result.add(workspace);
            if (considerChildMappings) continue;
            break;
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            Workstation.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public Collection<WorkspaceInfo> findWorkspaces(@NotNull FilePath localPath, boolean considerChildMappings, Object projectOrComponent) throws TfsException {
        if (localPath == null) {
            Workstation.$$$reportNull$$$0(16);
        }
        this.checkDuplicateMappings();
        Collection<WorkspaceInfo> resultCached = this.findWorkspacesCached(localPath, considerChildMappings);
        if (!resultCached.isEmpty()) {
            for (WorkspaceInfo workspace : resultCached) {
                if (workspace.hasMapping(localPath, considerChildMappings, projectOrComponent)) continue;
                throw new WorkspaceHasNoMappingException(workspace);
            }
            Collection<WorkspaceInfo> collection = resultCached;
            if (collection == null) {
                Workstation.$$$reportNull$$$0(17);
            }
            return collection;
        }
        ArrayList result = ContainerUtil.newArrayList();
        ArrayList serversToSkip = ContainerUtil.newArrayList();
        for (WorkspaceInfo workspace : this.getAllWorkspacesForCurrentOwnerAndComputer(true)) {
            ArrayList arrayList;
            if (serversToSkip.contains(workspace.getServer())) continue;
            try {
                if (!workspace.hasMapping(localPath, considerChildMappings, projectOrComponent)) continue;
                result.add(workspace);
                if (considerChildMappings) continue;
                arrayList = result;
            }
            catch (TfsException e) {
                serversToSkip.add(workspace.getServer());
                continue;
            }
            if (arrayList == null) {
                Workstation.$$$reportNull$$$0(18);
            }
            return arrayList;
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            Workstation.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    public void checkDuplicateMappings() throws DuplicateMappingException {
        if (this.myDuplicateMappedPath == null) {
            this.myDuplicateMappedPath = Ref.create((Object)this.findDuplicateMappedPath());
        }
        if (!this.myDuplicateMappedPath.isNull()) {
            throw new DuplicateMappingException((FilePath)this.myDuplicateMappedPath.get());
        }
    }

    private void invalidateDuplicateMappedPath() {
        this.myDuplicateMappedPath = null;
    }

    @Nullable
    private FilePath findDuplicateMappedPath() {
        ArrayList otherServersPaths = ContainerUtil.newArrayList();
        for (ServerInfo server : this.getServers()) {
            ArrayList currentServerPaths = ContainerUtil.newArrayList();
            for (WorkspaceInfo workspace : server.getWorkspacesForCurrentOwnerAndComputer()) {
                for (WorkingFolderInfo workingFolder : workspace.getWorkingFoldersCached()) {
                    FilePath currentServerPath = workingFolder.getLocalPath();
                    for (FilePath otherServerPath : otherServersPaths) {
                        if (currentServerPath.isUnder(otherServerPath, false)) {
                            return currentServerPath;
                        }
                        if (!otherServerPath.isUnder(currentServerPath, false)) continue;
                        return otherServerPath;
                    }
                    currentServerPaths.add(currentServerPath);
                }
            }
            otherServersPaths.addAll(currentServerPaths);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/tfsIntegration/core/tfs/Workstation";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemElementName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemAttributeName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getServers";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/Workstation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllWorkspacesForCurrentOwnerAndComputer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCache";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findWorkspacesCached";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findWorkspaces";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getServer";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addItems";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setIfNotNull";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findWorkspacesCached";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findWorkspaces";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getServer$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WorkstationHolder {
        private static final Workstation ourInstance = new Workstation();

        private WorkstationHolder() {
        }
    }
}

