/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.workitems;

import com.intellij.openapi.diagnostic.Logger;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.CheckinWorkItemAction;
import com.microsoft.schemas.teamfoundation._2005._06.workitemtracking.clientservices._03.Column_type0;
import com.microsoft.schemas.teamfoundation._2005._06.workitemtracking.clientservices._03.Columns_type0;
import com.microsoft.schemas.teamfoundation._2005._06.workitemtracking.clientservices._03.ComputedColumn_type0;
import com.microsoft.schemas.teamfoundation._2005._06.workitemtracking.clientservices._03.ComputedColumns_type0;
import com.microsoft.schemas.teamfoundation._2005._06.workitemtracking.clientservices._03.InsertResourceLink_type0;
import com.microsoft.schemas.teamfoundation._2005._06.workitemtracking.clientservices._03.InsertText_type0;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItem;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItemField;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItemState;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItemType;
import org.jetbrains.tfsIntegration.exceptions.OperationFailedException;

public class WorkItemSerialize {
    public static final List<WorkItemField> FIELDS = Arrays.asList(WorkItemField.ID, WorkItemField.STATE, WorkItemField.TITLE, WorkItemField.REVISION, WorkItemField.TYPE, WorkItemField.REASON, WorkItemField.ASSIGNED_TO);
    private static final String SERVER_DATE_TIME = "ServerDateTime";
    private static final Logger LOG = Logger.getInstance(WorkItemSerialize.class);

    public static WorkItem createFromFields(String[] workItemFieldsValues) throws OperationFailedException {
        try {
            int id = Integer.parseInt(workItemFieldsValues[FIELDS.indexOf((Object)WorkItemField.ID)]);
            WorkItemState state = WorkItemState.from(workItemFieldsValues[FIELDS.indexOf((Object)WorkItemField.STATE)]);
            String title = workItemFieldsValues[FIELDS.indexOf((Object)WorkItemField.TITLE)];
            int revision = Integer.parseInt(workItemFieldsValues[FIELDS.indexOf((Object)WorkItemField.REVISION)]);
            WorkItemType type = WorkItemType.from(workItemFieldsValues[FIELDS.indexOf((Object)WorkItemField.TYPE)]);
            String reason = workItemFieldsValues[FIELDS.indexOf((Object)WorkItemField.REASON)];
            String assignedTo = workItemFieldsValues.length > FIELDS.indexOf((Object)WorkItemField.ASSIGNED_TO) ? workItemFieldsValues[FIELDS.indexOf((Object)WorkItemField.ASSIGNED_TO)] : null;
            return new WorkItem(id, assignedTo, state, title, revision, type, reason);
        }
        catch (Exception e) {
            LOG.warn("Couldn't parse work items: " + Arrays.toString(workItemFieldsValues), (Throwable)e);
            throw new OperationFailedException("Cannot load work items: unexpected properties encountered", e);
        }
    }

    @Nullable
    public static Columns_type0 generateColumnsForUpdateRequest(WorkItemType type, String reason, CheckinWorkItemAction action, String identity) {
        if (action != CheckinWorkItemAction.Resolve) {
            return null;
        }
        ArrayList<Column_type0> columns = new ArrayList<Column_type0>();
        if (type == WorkItemType.BUG) {
            columns.add(WorkItemSerialize.createColumn(WorkItemField.STATE, null, WorkItemState.RESOLVED.getName()));
            columns.add(WorkItemSerialize.createColumn(WorkItemField.REASON, null, Reason.Fixed.name()));
            columns.add(WorkItemSerialize.createColumn(WorkItemField.STATE_CHANGE_DATE, SERVER_DATE_TIME, ""));
            columns.add(WorkItemSerialize.createColumn(WorkItemField.RESOLVED_DATE, SERVER_DATE_TIME, ""));
            columns.add(WorkItemSerialize.createColumn(WorkItemField.RESOLVED_BY, null, identity));
            columns.add(WorkItemSerialize.createColumn(WorkItemField.RESOLVED_REASON, null, reason));
        } else if (type == WorkItemType.TASK) {
            columns.add(WorkItemSerialize.createColumn(WorkItemField.STATE, null, WorkItemState.CLOSED.getName()));
            columns.add(WorkItemSerialize.createColumn(WorkItemField.REASON, null, Reason.Completed.name()));
            columns.add(WorkItemSerialize.createColumn(WorkItemField.STATE_CHANGE_DATE, SERVER_DATE_TIME, ""));
            columns.add(WorkItemSerialize.createColumn(WorkItemField.CLOSED_DATE, SERVER_DATE_TIME, ""));
            columns.add(WorkItemSerialize.createColumn(WorkItemField.CLOSED_BY, null, identity));
        } else {
            throw new IllegalArgumentException("Unexpected work item type " + type);
        }
        Columns_type0 columnsArray = new Columns_type0();
        columnsArray.setColumn(columns.toArray(new Column_type0[columns.size()]));
        return columnsArray;
    }

    public static InsertText_type0 generateInsertTextForUpdateRequest(CheckinWorkItemAction action, int changeSetId) {
        if (action == CheckinWorkItemAction.None) {
            throw new IllegalArgumentException("Unexpected action type " + action);
        }
        InsertText_type0 insertText = new InsertText_type0();
        insertText.setFieldDisplayName("History");
        insertText.setFieldName(WorkItemField.HISTORY.getSerialized());
        String text = MessageFormat.format("{0} with changeset {1}.", action == CheckinWorkItemAction.Resolve ? "Resolved" : "Associated", String.valueOf(changeSetId));
        insertText.setString(text);
        return insertText;
    }

    public static InsertResourceLink_type0 generateInsertResourceLinkforUpdateRequest(int changeSetId) {
        InsertResourceLink_type0 insertResourceLink = new InsertResourceLink_type0();
        insertResourceLink.setFieldName(WorkItemField.BISLINKS.getSerialized());
        insertResourceLink.setLinkType("Fixed in Changeset");
        insertResourceLink.setComment("Source control changeset " + changeSetId);
        insertResourceLink.setLocation("vstfs:///VersionControl/Changeset/" + changeSetId);
        return insertResourceLink;
    }

    public static ComputedColumns_type0 generateComputedColumnsForUpdateRequest(WorkItemType type, CheckinWorkItemAction action) {
        if (action == CheckinWorkItemAction.None) {
            throw new IllegalArgumentException("Unexpected action type " + action);
        }
        ArrayList<ComputedColumn_type0> computedColumns = new ArrayList<ComputedColumn_type0>();
        computedColumns.add(WorkItemSerialize.createComputedColumn(WorkItemField.REVISED_DATE));
        computedColumns.add(WorkItemSerialize.createComputedColumn(WorkItemField.CHANGED_DATE));
        computedColumns.add(WorkItemSerialize.createComputedColumn(WorkItemField.PERSON_ID));
        if (CheckinWorkItemAction.Resolve.equals((Object)action)) {
            computedColumns.add(WorkItemSerialize.createComputedColumn(WorkItemField.STATE_CHANGE_DATE));
            if (type == WorkItemType.BUG) {
                computedColumns.add(WorkItemSerialize.createComputedColumn(WorkItemField.RESOLVED_DATE));
            } else if (type == WorkItemType.TASK) {
                computedColumns.add(WorkItemSerialize.createComputedColumn(WorkItemField.CLOSED_DATE));
            } else {
                throw new IllegalArgumentException("Unexpected work item type " + type);
            }
        }
        ComputedColumns_type0 computedColumnsArray = new ComputedColumns_type0();
        computedColumnsArray.setComputedColumn(computedColumns.toArray(new ComputedColumn_type0[computedColumns.size()]));
        return computedColumnsArray;
    }

    private static Column_type0 createColumn(WorkItemField field, String type, String value) {
        Column_type0 column = new Column_type0();
        column.setColumn(field.getSerialized());
        column.setType(type);
        column.setValue(value);
        return column;
    }

    private static ComputedColumn_type0 createComputedColumn(WorkItemField field) {
        ComputedColumn_type0 column = new ComputedColumn_type0();
        column.setColumn(field.getSerialized());
        return column;
    }

    private static enum Reason {
        Fixed,
        Completed;

    }
}

