/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.LockLevel;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.locks.LockItemModel;
import org.jetbrains.tfsIntegration.ui.LockItemsForm;
import org.jetbrains.tfsIntegration.ui.LockItemsTableModel;

public class LockItemsDialog
extends DialogWrapper {
    public static final int LOCK_EXIT_CODE = 2;
    public static final int UNLOCK_EXIT_CODE = 3;
    private final LockItemsForm myLockItemsForm;
    private final Action myLockAction;
    private final Action myUnlockAction;

    public LockItemsDialog(Project project, List<LockItemModel> items) {
        super(project, false);
        this.myLockItemsForm = new LockItemsForm(items);
        this.setTitle("Lock/Unlock");
        this.myLockAction = new LockAction();
        this.myUnlockAction = new UnlockAction();
        this.init();
        this.myLockItemsForm.addListener(new LockItemsTableModel.Listener(){

            @Override
            public void selectionChanged() {
                LockItemsDialog.this.updateControls();
            }
        });
        this.updateControls();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myLockItemsForm.getContentPane();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getLockAction(), this.getUnlockAction(), this.getCancelAction()};
        if (actionArray == null) {
            LockItemsDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    private Action getLockAction() {
        return this.myLockAction;
    }

    private Action getUnlockAction() {
        return this.myUnlockAction;
    }

    private void setLockActionEnabled(boolean isEnabled) {
        this.myLockAction.setEnabled(isEnabled);
        this.myLockItemsForm.setRadioButtonsEnabled(isEnabled);
    }

    private void setUnlockActionEnabled(boolean isEnabled) {
        this.myUnlockAction.setEnabled(isEnabled);
    }

    private void updateControls() {
        List<LockItemModel> items = this.getSelectedItems();
        this.setLockActionEnabled(!items.isEmpty() && LockItemsDialog.canAllBeLocked(items));
        this.setUnlockActionEnabled(!items.isEmpty() && LockItemsDialog.canAllBeUnlocked(items));
    }

    private static boolean canAllBeLocked(List<LockItemModel> items) {
        for (LockItemModel item : items) {
            if (item.canBeLocked()) continue;
            return false;
        }
        return true;
    }

    private static boolean canAllBeUnlocked(List<LockItemModel> items) {
        for (LockItemModel item : items) {
            if (item.canBeUnlocked()) continue;
            return false;
        }
        return true;
    }

    public List<LockItemModel> getSelectedItems() {
        return this.myLockItemsForm.getSelectedItems();
    }

    public LockLevel getLockLevel() {
        return this.myLockItemsForm.getLockLevel();
    }

    protected String getDimensionServiceKey() {
        return "TFS.LockItems";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/LockItemsDialog", "createActions"));
    }

    private class UnlockAction
    extends AbstractAction {
        public UnlockAction() {
            super("Unlock");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (LockItemsDialog.this.myPerformAction) {
                return;
            }
            try {
                LockItemsDialog.this.myPerformAction = true;
                if (LockItemsDialog.this.getUnlockAction().isEnabled()) {
                    LockItemsDialog.this.close(3);
                }
            }
            finally {
                LockItemsDialog.this.myPerformAction = false;
            }
        }
    }

    private class LockAction
    extends AbstractAction {
        public LockAction() {
            super("Lock");
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (LockItemsDialog.this.myPerformAction) {
                return;
            }
            try {
                LockItemsDialog.this.myPerformAction = true;
                if (LockItemsDialog.this.getLockAction().isEnabled()) {
                    LockItemsDialog.this.close(2);
                }
            }
            finally {
                LockItemsDialog.this.myPerformAction = false;
            }
        }
    }
}

