/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.net.URI;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.configuration.Credentials;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.ui.ProxySettingsForm;

public class ProxySettingsDialog
extends DialogWrapper {
    private ProxySettingsForm myForm;
    @NotNull
    private final URI myServerUri;

    public ProxySettingsDialog(Project project, @NotNull URI serverUri) {
        if (serverUri == null) {
            ProxySettingsDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myServerUri = serverUri;
        String title = TFSBundle.message("proxy.dialog.title", TfsUtil.getPresentableUri(serverUri));
        this.setTitle(title);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        Credentials credentials = TFSConfigurationManager.getInstance().getCredentials(this.myServerUri);
        this.myForm = new ProxySettingsForm(TFSConfigurationManager.getInstance().getProxyUri(this.myServerUri), credentials != null ? credentials.getQualifiedUsername() : null);
        return this.myForm.getContentPane();
    }

    private void updateButtons() {
        String errorMessage = this.myForm.isValid() ? null : "Please enter valid proxy address.";
        this.myForm.setMessage(errorMessage);
        this.setOKActionEnabled(this.myForm.isValid());
    }

    protected void doOKAction() {
        if (this.myForm.isValid()) {
            super.doOKAction();
        } else {
            this.updateButtons();
            this.myForm.addListener(new ProxySettingsForm.Listener(){

                @Override
                public void stateChanged() {
                    ProxySettingsDialog.this.updateButtons();
                }
            });
        }
    }

    @Nullable
    public URI getProxyUri() {
        return this.myForm.getProxyUri();
    }

    protected String getDimensionServiceKey() {
        return "TFS.ProxySettings";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverUri", "org/jetbrains/tfsIntegration/ui/ProxySettingsDialog", "<init>"));
    }
}

