/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Conflict;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jetbrains.tfsIntegration.core.tfs.conflicts.ResolveConflictHelper;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.ConflictsTableModel;

public class ResolveConflictsForm {
    private JTable myItemsTable;
    private JPanel myContentPanel;
    private JButton myAcceptYoursButton;
    private JButton myAcceptTheirsButton;
    private JButton myMergeButton;
    private final ConflictsTableModel myItemsTableModel;
    private final ResolveConflictHelper myResolveConflictHelper;
    private final EventDispatcher<Listener> myEventDispatcher;
    private static final Comparator<? super Conflict> CONFLICTS_COMPARATOR = (o1, o2) -> {
        String path1 = ConflictsTableModel.Column.Name.getValue((Conflict)o1);
        String path2 = ConflictsTableModel.Column.Name.getValue((Conflict)o2);
        return path1.compareTo(path2);
    };

    public ResolveConflictsForm(ResolveConflictHelper resolveConflictHelper) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myResolveConflictHelper = resolveConflictHelper;
        this.myItemsTableModel = new ConflictsTableModel();
        this.myItemsTable.setModel(this.myItemsTableModel);
        this.myItemsTable.setSelectionMode(2);
        this.addListeners();
        this.updateConflictsTable();
    }

    private void updateConflictsTable() {
        ArrayList<Conflict> conflicts = new ArrayList<Conflict>(this.myResolveConflictHelper.getConflicts());
        Collections.sort(conflicts, CONFLICTS_COMPARATOR);
        this.myItemsTableModel.setConflicts(conflicts);
    }

    private void addListeners() {
        this.myItemsTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (ResolveConflictsForm.this.myItemsTableModel.getRowCount() == 0) {
                    ((Listener)ResolveConflictsForm.this.myEventDispatcher.getMulticaster()).close();
                }
            }
        });
        this.myItemsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent se) {
                int[] selectedIndices = ResolveConflictsForm.this.myItemsTable.getSelectedRows();
                ResolveConflictsForm.this.enableButtons(selectedIndices);
            }
        });
        this.myAcceptYoursButton.addActionListener(new MergeActionListener(){

            @Override
            protected void execute(Conflict conflict) throws TfsException, VcsException {
                ResolveConflictsForm.this.myResolveConflictHelper.acceptYours(conflict);
            }
        });
        this.myAcceptTheirsButton.addActionListener(new MergeActionListener(){

            @Override
            protected void execute(Conflict conflict) throws TfsException, IOException, VcsException {
                ResolveConflictsForm.this.myResolveConflictHelper.acceptTheirs(conflict);
            }
        });
        this.myMergeButton.addActionListener(new MergeActionListener(){

            @Override
            protected void execute(Conflict conflict) throws TfsException, VcsException {
                ResolveConflictsForm.this.myResolveConflictHelper.acceptMerge(conflict);
            }
        });
    }

    public JComponent getPanel() {
        return this.myContentPanel;
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    private void enableButtons(int[] selectedIndices) {
        this.myAcceptYoursButton.setEnabled(selectedIndices.length > 0);
        this.myAcceptTheirsButton.setEnabled(selectedIndices.length > 0);
        boolean mergeEnabled = selectedIndices.length > 0;
        for (int index : selectedIndices) {
            Conflict conflict = this.myItemsTableModel.getConflicts().get(index);
            if (ResolveConflictHelper.canMerge(conflict)) continue;
            mergeEnabled = false;
            break;
        }
        this.myMergeButton.setEnabled(mergeEnabled);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAcceptYoursButton = jButton3 = new JButton();
        ((Component)jButton3).setEnabled(false);
        jButton3.setText("Accept Yours");
        jButton3.setMnemonic('Y');
        jButton3.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAcceptTheirsButton = jButton2 = new JButton();
        ((Component)jButton2).setEnabled(false);
        jButton2.setText("Accept Theirs");
        jButton2.setMnemonic('T');
        jButton2.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myMergeButton = jButton = new JButton();
        ((Component)jButton).setEnabled(false);
        jButton.setText("Merge");
        jButton.setMnemonic('M');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = new JBTable();
        this.myItemsTable = jBTable;
        jBTable.putClientProperty((Object)"Table.isFileList", (Object)Boolean.FALSE);
        jBScrollPane.setViewportView((Component)jBTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private abstract class MergeActionListener
    implements ActionListener {
        private MergeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int[] selectedIndices = ResolveConflictsForm.this.myItemsTable.getSelectedRows();
            try {
                for (int index : selectedIndices) {
                    Conflict conflict = ResolveConflictsForm.this.myItemsTableModel.getConflicts().get(index);
                    this.execute(conflict);
                }
                ResolveConflictsForm.this.updateConflictsTable();
            }
            catch (TfsException e) {
                String message = "Failed to resolve conlict.\n" + e.getMessage();
                Messages.showErrorDialog((Component)ResolveConflictsForm.this.myContentPanel, (String)message, (String)"Resolve Conflicts");
            }
            catch (IOException e) {
                String message = "Failed to resolve conlict.\n" + e.getMessage();
                Messages.showErrorDialog((Component)ResolveConflictsForm.this.myContentPanel, (String)message, (String)"Resolve Conflicts");
            }
            catch (VcsException e) {
                String message = "Failed to resolve conlict.\n" + e.getMessage();
                Messages.showErrorDialog((Component)ResolveConflictsForm.this.myContentPanel, (String)message, (String)"Resolve Conflicts");
            }
        }

        protected abstract void execute(Conflict var1) throws TfsException, IOException, VcsException;
    }

    public static interface Listener
    extends EventListener {
        public void close();
    }
}

