/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.containers.ContainerUtil;
import com.microsoft.tfs.core.clients.workitem.WorkItemQueryUtils;
import com.microsoft.tfs.core.clients.workitem.exceptions.WorkItemException;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.query.BatchReadParameter;
import com.microsoft.tfs.core.clients.workitem.query.BatchReadParameterCollection;
import com.microsoft.tfs.core.clients.workitem.query.Query;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemCollection;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemLinkInfo;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryDefinition;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryType;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.tfs.TfsExecutionUtil;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItem;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItemSerialize;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.BaseQueryNode;
import org.jetbrains.tfsIntegration.ui.QueriesTreeContext;
import org.jetbrains.tfsIntegration.ui.WorkItemsQueryResult;

public class SavedQueryDefinitionNode
extends BaseQueryNode {
    private static String[] WORK_ITEM_FIELDS = (String[])ContainerUtil.map2Array(WorkItemSerialize.FIELDS, String.class, field -> field.getSerialized());
    private static String WORK_ITEMS_QUERY = "SELECT " + WorkItemQueryUtils.formatFieldList((String[])WORK_ITEM_FIELDS) + " FROM WorkItems";
    @NotNull
    private final QueryDefinition myQueryDefinition;

    public SavedQueryDefinitionNode(@NotNull QueriesTreeContext context, @NotNull QueryDefinition definition) {
        if (context == null) {
            SavedQueryDefinitionNode.$$$reportNull$$$0(0);
        }
        if (definition == null) {
            SavedQueryDefinitionNode.$$$reportNull$$$0(1);
        }
        super(context);
        this.myQueryDefinition = definition;
    }

    protected void doUpdate() {
        PresentationData presentation = this.getPresentation();
        presentation.addText(this.myQueryDefinition.getName(), this.getPlainAttributes());
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myQueryDefinition.getID()};
        if (objectArray == null) {
            SavedQueryDefinitionNode.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public SimpleNode[] getChildren() {
        return NO_CHILDREN;
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    public void handleSelection(@NotNull SimpleTree tree) {
        if (tree == null) {
            SavedQueryDefinitionNode.$$$reportNull$$$0(3);
        }
        final boolean isList = this.isListQuery();
        this.myQueriesTreeContext.queryWorkItems(new TfsExecutionUtil.Process<WorkItemsQueryResult>(){

            @Override
            @NotNull
            public WorkItemsQueryResult run() throws TfsException, VcsException {
                WorkItemsQueryResult workItemsQueryResult;
                try {
                    workItemsQueryResult = isList ? SavedQueryDefinitionNode.this.runListQuery() : SavedQueryDefinitionNode.this.runLinkQuery();
                }
                catch (WorkItemException e) {
                    throw new VcsException((Throwable)e);
                }
                catch (ProxyException e) {
                    throw new VcsException((Throwable)e);
                }
                if (workItemsQueryResult == null) {
                    1.$$$reportNull$$$0(0);
                }
                return workItemsQueryResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode$1", "run"));
            }
        });
    }

    private boolean isListQuery() {
        return QueryType.LIST.equals((Object)this.myQueryDefinition.getQueryType());
    }

    @NotNull
    private WorkItemsQueryResult runListQuery() throws WorkItemException, ProxyException {
        WorkItemCollection workItems = this.getWorkItemClient().query(this.myQueryDefinition.getQueryText(), this.buildQueryContext());
        WorkItemsQueryResult workItemsQueryResult = new WorkItemsQueryResult(SavedQueryDefinitionNode.toList(workItems));
        if (workItemsQueryResult == null) {
            SavedQueryDefinitionNode.$$$reportNull$$$0(4);
        }
        return workItemsQueryResult;
    }

    @NotNull
    private static List<WorkItem> toList(@NotNull WorkItemCollection workItems) throws WorkItemException, ProxyException {
        if (workItems == null) {
            SavedQueryDefinitionNode.$$$reportNull$$$0(5);
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (int i = 0; i < workItems.size(); ++i) {
            result.add(WorkItem.create(workItems.getWorkItem(i)));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            SavedQueryDefinitionNode.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private WorkItemsQueryResult runLinkQuery() throws WorkItemException, ProxyException {
        Query linksQuery = this.getWorkItemClient().createQuery(this.myQueryDefinition.getQueryText(), this.buildQueryContext());
        ArrayList links = ContainerUtil.newArrayList((Object[])linksQuery.runLinkQuery());
        Query workItemsQuery = this.getWorkItemClient().createQuery(WORK_ITEMS_QUERY, SavedQueryDefinitionNode.toBatchReadCollection(SavedQueryDefinitionNode.getWorkItemIds(links)));
        WorkItemsQueryResult workItemsQueryResult = new WorkItemsQueryResult(SavedQueryDefinitionNode.toList(workItemsQuery.runQuery()), links);
        if (workItemsQueryResult == null) {
            SavedQueryDefinitionNode.$$$reportNull$$$0(7);
        }
        return workItemsQueryResult;
    }

    @NotNull
    private static BatchReadParameterCollection toBatchReadCollection(@NotNull Iterable<Integer> ids) {
        if (ids == null) {
            SavedQueryDefinitionNode.$$$reportNull$$$0(8);
        }
        BatchReadParameterCollection result = new BatchReadParameterCollection();
        for (Integer id : ids) {
            result.add(new BatchReadParameter(id.intValue()));
        }
        BatchReadParameterCollection batchReadParameterCollection = result;
        if (batchReadParameterCollection == null) {
            SavedQueryDefinitionNode.$$$reportNull$$$0(9);
        }
        return batchReadParameterCollection;
    }

    @NotNull
    private static Set<Integer> getWorkItemIds(@NotNull Iterable<WorkItemLinkInfo> links) {
        if (links == null) {
            SavedQueryDefinitionNode.$$$reportNull$$$0(10);
        }
        HashSet result = ContainerUtil.newHashSet();
        for (WorkItemLinkInfo link : links) {
            SavedQueryDefinitionNode.addId(result, link.getSourceID());
            SavedQueryDefinitionNode.addId(result, link.getTargetID());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            SavedQueryDefinitionNode.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    private static void addId(@NotNull Set<Integer> ids, int id) {
        if (ids == null) {
            SavedQueryDefinitionNode.$$$reportNull$$$0(12);
        }
        if (id > 0) {
            ids.add(id);
        }
    }

    @NotNull
    private Map<String, Object> buildQueryContext() {
        Map map = WorkItemQueryUtils.makeContext((Project)this.myQueryDefinition.getProject(), null);
        if (map == null) {
            SavedQueryDefinitionNode.$$$reportNull$$$0(13);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workItems";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "links";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/tfsIntegration/ui/SavedQueryDefinitionNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "runListQuery";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "runLinkQuery";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toBatchReadCollection";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkItemIds";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildQueryContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleSelection";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toBatchReadCollection";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getWorkItemIds";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

