/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.treetable;

import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.ui.treetable.CellRenderer;
import org.jetbrains.tfsIntegration.ui.treetable.ContentProvider;
import org.jetbrains.tfsIntegration.ui.treetable.TreeTableColumn;

public class CustomTreeTable<T>
extends TreeTable {
    private List<? extends TreeTableColumn<T>> myColumns;
    private ContentProvider<T> myContentProvider;
    private final CellRenderer<T> myRenderer;
    private final boolean myShowCellFocus;
    private final boolean myShowSelection;
    private static final Object HIDDEN_ROOT = new Object();

    public CustomTreeTable(CellRenderer<T> renderer, boolean showCellFocus, boolean showSelection) {
        this(Arrays.asList(new FakeColumn()), new FakeContentProvider(), renderer, showCellFocus, showSelection);
    }

    public CustomTreeTable(List<? extends TreeTableColumn<T>> columns, ContentProvider<T> contentProvider, CellRenderer<T> renderer, boolean showCellFocus, boolean showSelection) {
        super(CustomTreeTable.createModel(columns, contentProvider));
        this.myColumns = columns;
        this.myContentProvider = contentProvider;
        this.myRenderer = renderer;
        this.myShowCellFocus = showCellFocus;
        this.myShowSelection = showSelection;
        this.initialize();
    }

    public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
        return new TreeTableCellRenderer(this, this.getTree()){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, value, CustomTreeTable.this.myShowSelection && isSelected, CustomTreeTable.this.myShowCellFocus && hasFocus, row, column);
            }
        };
    }

    private static <T> TreeTableModel createModel(Collection<? extends TreeTableColumn<T>> columns, ContentProvider<T> contentProvider) {
        DefaultMutableTreeNode root;
        ArrayList<Object> columnsInfos = new ArrayList<Object>(columns.size());
        boolean first = true;
        for (TreeTableColumn<T> column : columns) {
            if (first) {
                columnsInfos.add(new TreeColumnInfo(column.getCaption()));
            } else {
                columnsInfos.add(new ColumnInfo(column.getCaption()){

                    public Object valueOf(Object o) {
                        return o;
                    }

                    public Class getColumnClass() {
                        return TableColumnMarker.class;
                    }
                });
            }
            first = false;
        }
        Collection<T> rootObjects = contentProvider.getRoots();
        if (!rootObjects.isEmpty()) {
            if (rootObjects.size() == 1) {
                root = new DefaultMutableTreeNode(rootObjects.iterator().next());
                CustomTreeTable.addChildren(root, contentProvider);
            } else {
                root = new DefaultMutableTreeNode(HIDDEN_ROOT);
                for (T rootObject : rootObjects) {
                    DefaultMutableTreeNode subRoot = new DefaultMutableTreeNode(rootObject);
                    CustomTreeTable.addChildren(subRoot, contentProvider);
                    root.add(subRoot);
                }
            }
        } else {
            root = null;
        }
        return new ListTreeTableModelOnColumns((TreeNode)root, columnsInfos.toArray(new ColumnInfo[columnsInfos.size()]));
    }

    private static <T> void addChildren(DefaultMutableTreeNode parentNode, ContentProvider<T> contentProvider) {
        Collection<Object> children = contentProvider.getChildren(parentNode.getUserObject());
        for (Object child : children) {
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
            parentNode.add(childNode);
            CustomTreeTable.addChildren(childNode, contentProvider);
        }
    }

    public void expandAll() {
        for (int i = 0; i < this.getTree().getRowCount(); ++i) {
            this.getTree().expandRow(i);
        }
    }

    public void initialize(List<TreeTableColumn<T>> columns, ContentProvider<T> contentProvider) {
        this.myColumns = columns;
        this.myContentProvider = contentProvider;
        this.setModel(CustomTreeTable.createModel(columns, contentProvider));
        this.initialize();
    }

    public void updateContent() {
        this.setModel(CustomTreeTable.createModel(this.myColumns, this.myContentProvider));
        this.initialize();
    }

    private void initialize() {
        this.setTreeCellRenderer(new TreeColumnRenderer());
        this.setDefaultRenderer(TableColumnMarker.class, new TableColumnRenderer());
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setPreferredWidth(this.myColumns.get(i).getWidth());
        }
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.getTableModel().getRoot();
        this.setRootVisible(rootNode == null || rootNode.getUserObject() != HIDDEN_ROOT);
    }

    public Collection<T> getSelectedItems() {
        int[] selectedRows = this.getSelectedRows();
        ArrayList<Object> result = new ArrayList<Object>(selectedRows.length);
        for (int row : selectedRows) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.getTree().getPathForRow(row).getLastPathComponent();
            Object userObject = treeNode.getUserObject();
            if (userObject == HIDDEN_ROOT) continue;
            result.add(userObject);
        }
        return result;
    }

    public void select(T userObject) {
        if (userObject != null) {
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.getTableModel().getRoot();
            if (rootNode == null) {
                return;
            }
            DefaultMutableTreeNode node = this.find(rootNode, userObject);
            if (node != null) {
                int row = this.getTree().getRowForPath(new TreePath(node.getPath()));
                this.getSelectionModel().setSelectionInterval(row, row);
            }
        } else {
            this.getSelectionModel().clearSelection();
        }
    }

    @Nullable
    private DefaultMutableTreeNode find(DefaultMutableTreeNode root, @NotNull T userObject) {
        if (userObject == null) {
            CustomTreeTable.$$$reportNull$$$0(0);
        }
        if (userObject.equals(root.getUserObject())) {
            return root;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode result = this.find((DefaultMutableTreeNode)root.getChildAt(i), userObject);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userObject", "org/jetbrains/tfsIntegration/ui/treetable/CustomTreeTable", "find"));
    }

    private static final class TableColumnMarker {
        private TableColumnMarker() {
        }
    }

    private class TableColumnRenderer
    extends DefaultTableCellRenderer {
        private TableColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, CustomTreeTable.this.myShowSelection && isSelected, CustomTreeTable.this.myShowCellFocus && hasFocus, row, column);
            JLabel label = (JLabel)c;
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            if (treeNode == null || HIDDEN_ROOT == treeNode.getUserObject()) {
                return c;
            }
            Object typedValue = treeNode.getUserObject();
            CustomTreeTable.this.myRenderer.render(CustomTreeTable.this, (TreeTableColumn)CustomTreeTable.this.myColumns.get(column), typedValue, label);
            return c;
        }
    }

    private class TreeColumnRenderer
    extends DefaultTreeCellRenderer {
        private TreeColumnRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, CustomTreeTable.this.myShowSelection && sel, expanded, leaf, row, CustomTreeTable.this.myShowCellFocus && hasFocus);
            JLabel label = (JLabel)c;
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            if (HIDDEN_ROOT == treeNode.getUserObject()) {
                return c;
            }
            Object typedValue = treeNode.getUserObject();
            CustomTreeTable.this.myRenderer.render(CustomTreeTable.this, (TreeTableColumn)CustomTreeTable.this.myColumns.get(0), typedValue, label);
            return c;
        }
    }

    private static final class FakeContentProvider<T>
    implements ContentProvider<T> {
        private FakeContentProvider() {
        }

        @Override
        public Collection<? extends T> getRoots() {
            return Collections.emptyList();
        }

        @Override
        public Collection<? extends T> getChildren(@NotNull T parent) {
            if (parent == null) {
                FakeContentProvider.$$$reportNull$$$0(0);
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/tfsIntegration/ui/treetable/CustomTreeTable$FakeContentProvider", "getChildren"));
        }
    }

    private static final class FakeColumn<T>
    extends TreeTableColumn<T> {
        public FakeColumn() {
            super(null, 0);
        }

        @Override
        public String getPresentableString(T value) {
            return "";
        }
    }
}

