/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.webservice;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.concurrency.Semaphore;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.config.TfsServerConnectionHelper;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.configuration.Credentials;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.exceptions.AuthCancelledException;
import org.jetbrains.tfsIntegration.exceptions.ConnectionFailedException;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.exceptions.TfsExceptionManager;
import org.jetbrains.tfsIntegration.exceptions.UnauthorizedException;
import org.jetbrains.tfsIntegration.exceptions.UserCancelledException;
import org.jetbrains.tfsIntegration.ui.TfsLoginDialog;

public class TfsRequestManager {
    private static final long POLL_TIMEOUT = 200L;
    private static final Map<URI, TfsRequestManager> ourInstances = new HashMap<URI, TfsRequestManager>();
    private static final Logger LOG = Logger.getInstance((String)TfsRequestManager.class.getName());
    @Nullable
    private final URI myServerUri;
    private static final ReentrantLock ourShowDialogLock = new ReentrantLock();
    private final ReentrantLock myRequestLock = new ReentrantLock();

    private TfsRequestManager(@Nullable URI serverUri) {
        this.myServerUri = serverUri;
    }

    public static synchronized TfsRequestManager getInstance(@Nullable URI serverUri) {
        TfsRequestManager result = ourInstances.get(serverUri);
        if (result == null) {
            result = new TfsRequestManager(serverUri);
            ourInstances.put(serverUri, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeRequestInBackground(Object projectOrComponent, boolean force, Request<T> request) throws TfsException {
        LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        LOG.assertTrue(this.myServerUri != null);
        boolean showDialog = this.shouldShowDialog(force);
        Ref message = new Ref();
        Ref credentials = new Ref((Object)TFSConfigurationManager.getInstance().getCredentials(this.myServerUri));
        while (true) {
            ProgressIndicator pi;
            if (showDialog || !message.isNull()) {
                try {
                    ourShowDialogLock.lock();
                    ProgressManager.checkCanceled();
                    showDialog = this.shouldShowDialog(force);
                    if (!message.isNull() || showDialog) {
                        pi = ProgressManager.getInstance().getProgressIndicator();
                        if (pi != null) {
                            WaitForProgressToShow.execute((ProgressIndicator)pi);
                        }
                        Ref ok = new Ref();
                        ApplicationManager.getApplication().invokeAndWait(() -> {
                            if (message.isNull()) {
                                try {
                                    if (!this.shouldShowDialog(force)) {
                                        ok.set((Object)true);
                                        return;
                                    }
                                }
                                catch (UserCancelledException e) {
                                    ok.set((Object)false);
                                    return;
                                }
                            }
                            TfsLoginDialog d = projectOrComponent instanceof JComponent ? new TfsLoginDialog((JComponent)projectOrComponent, this.myServerUri, (Credentials)credentials.get(), false, null) : new TfsLoginDialog((Project)projectOrComponent, this.myServerUri, (Credentials)credentials.get(), false, null);
                            d.setMessage((String)message.get());
                            if (d.showAndGet()) {
                                credentials.set((Object)d.getCredentials());
                                ok.set((Object)true);
                            } else {
                                ok.set((Object)false);
                            }
                        });
                        if (!((Boolean)ok.get()).booleanValue()) {
                            if (!force) {
                                TFSConfigurationManager.getInstance().setAuthCanceled(this.myServerUri, projectOrComponent);
                            }
                            throw new AuthCancelledException(this.myServerUri);
                        }
                    } else {
                        credentials.set((Object)TFSConfigurationManager.getInstance().getCredentials(this.myServerUri));
                    }
                }
                finally {
                    ourShowDialogLock.unlock();
                }
            }
            LOG.assertTrue(!credentials.isNull());
            try {
                this.myRequestLock.lock();
                ProgressManager.checkCanceled();
                pi = ProgressManager.getInstance().getProgressIndicator();
                T result = TfsRequestManager.executeRequestImpl(this.myServerUri, (Ref<Credentials>)credentials, request, pi);
                TFSConfigurationManager.getInstance().storeCredentials(this.myServerUri, (Credentials)credentials.get());
                T t = result;
                return t;
            }
            catch (Exception e) {
                TfsException tfsException = TfsExceptionManager.processException(e);
                LOG.warn((Throwable)tfsException);
                if (tfsException instanceof UnauthorizedException) {
                    message.set((Object)TfsRequestManager.getMessage(tfsException, ((Credentials)credentials.get()).getType()));
                    continue;
                }
                if (!(tfsException instanceof ConnectionFailedException)) {
                    TFSConfigurationManager.getInstance().storeCredentials(this.myServerUri, (Credentials)credentials.get());
                }
                throw tfsException;
            }
            finally {
                this.myRequestLock.unlock();
                continue;
            }
            break;
        }
    }

    public static <T> T executeRequest(URI serverUri, Object projectOrComponent, Request<T> request) throws TfsException {
        return TfsRequestManager.executeRequest(serverUri, projectOrComponent, false, request);
    }

    public static <T> T executeRequest(URI serverUri, Object projectOrComponent, boolean force, Request<T> request) throws TfsException {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return TfsRequestManager.getInstance(serverUri).executeRequestInForeground(projectOrComponent, false, null, force, request);
        }
        return TfsRequestManager.getInstance(serverUri).executeRequestInBackground(projectOrComponent, force, request);
    }

    public <T> T executeRequestInForeground(Object projectOrComponent, boolean reportErrorsInDialog, @Nullable Credentials overrideCredentials, boolean force, Request<T> request) throws TfsException {
        return this.executeRequestInForeground(projectOrComponent, request, null, reportErrorsInDialog, overrideCredentials, force);
    }

    private <T> T executeRequestInForeground(Object projectOrComponent, Request<T> request, @Nullable String errorMessage, boolean reportErrorsInDialog, @Nullable Credentials overrideCredentials, boolean force) throws TfsException {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        Ref result = new Ref();
        Ref fatalError = new Ref();
        if (errorMessage != null || overrideCredentials == null && this.shouldShowDialog(force)) {
            Ref credentials = new Ref((Object)(overrideCredentials != null ? overrideCredentials : (this.myServerUri != null ? TFSConfigurationManager.getInstance().getCredentials(this.myServerUri) : null)));
            Condition condition = dialog -> {
                ExecuteSession session = new ExecuteSession(dialog.getCredentials(), dialog.getContentPane(), request, dialog.getUri());
                if (!session.execute()) {
                    return false;
                }
                TfsException error = session.getError();
                if (error != null) {
                    if (error instanceof UnauthorizedException || this.myServerUri == null || reportErrorsInDialog) {
                        dialog.setMessage(TfsRequestManager.getMessage(error, dialog.getCredentials().getType()));
                        return false;
                    }
                    fatalError.set((Object)error);
                    if (!(error instanceof ConnectionFailedException)) {
                        TFSConfigurationManager.getInstance().storeCredentials(dialog.getUri(), session.getCredentials());
                    }
                } else {
                    TFSConfigurationManager.getInstance().storeCredentials(dialog.getUri(), session.getCredentials());
                    result.set(session.myResult);
                }
                return true;
            };
            TfsLoginDialog d = projectOrComponent instanceof JComponent ? new TfsLoginDialog((JComponent)projectOrComponent, this.myServerUri, (Credentials)credentials.get(), this.myServerUri == null, (Condition<TfsLoginDialog>)condition) : new TfsLoginDialog((Project)projectOrComponent, this.myServerUri, (Credentials)credentials.get(), this.myServerUri == null, (Condition<TfsLoginDialog>)condition);
            if (errorMessage != null) {
                d.setMessage(errorMessage);
            }
            if (d.showAndGet()) {
                if (fatalError.isNull()) {
                    return (T)result.get();
                }
                throw (TfsException)fatalError.get();
            }
            if (!force && this.myServerUri != null) {
                TFSConfigurationManager.getInstance().setAuthCanceled(this.myServerUri, projectOrComponent);
            }
            throw new AuthCancelledException(this.myServerUri);
        }
        LOG.assertTrue(this.myServerUri != null);
        Credentials credentials = overrideCredentials != null ? overrideCredentials : TFSConfigurationManager.getInstance().getCredentials(this.myServerUri);
        ExecuteSession<T> session = new ExecuteSession<T>(credentials, projectOrComponent, request, this.myServerUri);
        if (!session.execute()) {
            throw new UserCancelledException();
        }
        TfsException error = session.getError();
        if (error instanceof UnauthorizedException && credentials != null) {
            return this.executeRequestInForeground(projectOrComponent, request, TfsRequestManager.getMessage(error, credentials.getType()), reportErrorsInDialog, overrideCredentials, force);
        }
        TFSConfigurationManager.getInstance().storeCredentials(this.myServerUri, session.getCredentials());
        if (error == null) {
            return (T)((ExecuteSession)session).myResult;
        }
        throw error;
    }

    private static String getMessage(TfsException error, Credentials.Type type) {
        if (error instanceof ConnectionFailedException && ((ConnectionFailedException)error).getHttpStatusCode() == 302) {
            if (type == Credentials.Type.Alternate) {
                return TFSBundle.message("unauthorized", new Object[0]);
            }
            return TFSBundle.message("consider.using.alternate.credentials", error.getMessage());
        }
        return error.getMessage();
    }

    private boolean shouldShowDialog(boolean force) throws UserCancelledException {
        if (this.myServerUri == null) {
            return true;
        }
        if (!force && TFSConfigurationManager.getInstance().isAuthCanceled(this.myServerUri)) {
            throw new AuthCancelledException(this.myServerUri);
        }
        return TfsRequestManager.shouldShowLoginDialog(this.myServerUri);
    }

    public static boolean shouldShowLoginDialog(URI serverUri) {
        Credentials credentials = TFSConfigurationManager.getInstance().getCredentials(serverUri);
        return credentials == null || credentials.shouldShowLoginDialog() || TfsLoginDialog.shouldPromptForProxyPassword(true);
    }

    private static <T> T executeRequestImpl(final URI serverUri, final Ref<Credentials> credentialsRef, final Request<T> request, final ProgressIndicator pi) throws Exception {
        return (T)ClassLoaderUtil.runWithClassLoader((ClassLoader)TfsRequestManager.class.getClassLoader(), (ThrowableComputable)new ThrowableComputable<T, Exception>(){

            public T compute() throws Exception {
                boolean needsAuthentication;
                Credentials credentials = (Credentials)credentialsRef.get();
                boolean bl = needsAuthentication = credentials == null || request.retrieveAuthorizedCredentials() && (credentials.getUserName().length() == 0 || credentials.getDomain().length() == 0);
                if (needsAuthentication) {
                    TfsServerConnectionHelper.ServerDescriptor descriptor = TfsServerConnectionHelper.connect(serverUri, (Credentials)credentialsRef.get(), true, pi);
                    credentialsRef.set((Object)descriptor.authorizedCredentials);
                }
                return request.execute((Credentials)credentialsRef.get(), serverUri, pi);
            }
        });
    }

    private class ExecuteSession<T>
    implements Runnable {
        private final Ref<Credentials> myCredentials;
        private final Object myProjectOrComponent;
        private final Request<T> myRequest;
        private final URI myCurrentServerUri;
        private T myResult;
        private TfsException myError;

        public ExecuteSession(Credentials credentials, Object projectOrComponent, Request<T> request, URI currentServerUri) {
            this.myCredentials = Ref.create((Object)credentials);
            this.myProjectOrComponent = projectOrComponent;
            this.myRequest = request;
            this.myCurrentServerUri = currentServerUri;
        }

        public TfsException getError() {
            return this.myError;
        }

        public Credentials getCredentials() {
            return (Credentials)this.myCredentials.get();
        }

        @Override
        public void run() {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            Semaphore done = new Semaphore();
            pi.setIndeterminate(true);
            done.down();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    TfsRequestManager.this.myRequestLock.lock();
                    this.myResult = TfsRequestManager.executeRequestImpl(this.myCurrentServerUri, (Ref<Credentials>)this.myCredentials, this.myRequest, pi);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                    this.myError = TfsExceptionManager.processException(e);
                }
                finally {
                    TfsRequestManager.this.myRequestLock.unlock();
                    done.up();
                }
            });
            while (!done.waitFor(200L) && !pi.isCanceled()) {
            }
        }

        public boolean execute() {
            Project project = this.myProjectOrComponent instanceof Project ? (Project)this.myProjectOrComponent : null;
            JComponent component = this.myProjectOrComponent instanceof JComponent ? (JComponent)this.myProjectOrComponent : null;
            return ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)this, this.myRequest.getProgressTitle((Credentials)this.myCredentials.get(), this.myCurrentServerUri), true, project, component);
        }
    }

    public static abstract class Request<T> {
        private final String myProgressTitle;

        public Request(String progressTitle) {
            this.myProgressTitle = progressTitle;
        }

        public abstract T execute(Credentials var1, URI var2, @Nullable ProgressIndicator var3) throws Exception;

        @NotNull
        public String getProgressTitle(Credentials credentials, URI serverUri) {
            String string = this.myProgressTitle;
            if (string == null) {
                Request.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean retrieveAuthorizedCredentials() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/webservice/TfsRequestManager$Request", "getProgressTitle"));
        }
    }
}

