/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.webservice.compatibility;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.DetachableInputStream;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.jetbrains.tfsIntegration.webservice.compatibility.CustomStAXSOAPModelBuilder;

public class CustomSOAPBuilder
implements Builder {
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        try {
            String charSetEncoding = (String)messageContext.getProperty("CHARACTER_SET_ENCODING");
            DetachableInputStream is = new DetachableInputStream(inputStream);
            messageContext.setProperty("org.apache.axiom.om.util.DetachableInputStream", (Object)is);
            PushbackInputStream pis = BuilderUtil.getPushbackInputStream((InputStream)is);
            String actualCharSetEncoding = BuilderUtil.getCharSetEncoding((PushbackInputStream)pis, (String)charSetEncoding);
            XMLStreamReader streamReader = StAXUtils.createXMLStreamReader((InputStream)pis, (String)actualCharSetEncoding);
            CustomStAXSOAPModelBuilder builder = new CustomStAXSOAPModelBuilder(streamReader);
            SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
            BuilderUtil.validateSOAPVersion((String)BuilderUtil.getEnvelopeNamespace((String)contentType), (SOAPEnvelope)envelope);
            BuilderUtil.validateCharSetEncoding((String)charSetEncoding, (String)builder.getDocument().getCharsetEncoding(), (String)envelope.getNamespace().getNamespaceURI());
            return envelope;
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }
}

