/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFacetConfigurationImpl;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetData;
import com.intellij.spring.facet.SpringFileSetImpl;
import com.intellij.spring.facet.beans.CustomSetting;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringFacetImpl
extends SpringFacet {
    private final Set<SpringFileSet> myFileSets = new LinkedHashSet<SpringFileSet>();

    public SpringFacetImpl(FacetType facetType, Module module, String name, SpringFacetConfiguration configuration, Facet underlyingFacet) {
        super(facetType, module, name, configuration, underlyingFacet);
        for (SpringFileSetData fileSetData : ((SpringFacetConfigurationImpl)configuration).getFileSetDescriptors()) {
            SpringFileSetImpl fileSet = new SpringFileSetImpl(fileSetData, this);
            this.myFileSets.add(fileSet);
            Disposer.register((Disposable)this, (Disposable)fileSet);
        }
        Disposer.register((Disposable)this, (Disposable)configuration);
    }

    public Set<SpringFileSet> getFileSets() {
        return Collections.unmodifiableSet(this.myFileSets);
    }

    public SpringFileSet addFileSet(@NonNls @NotNull String id, @NotNull String name) {
        if (id == null) {
            SpringFacetImpl.$$$reportNull$$$0(0);
        }
        if (name == null) {
            SpringFacetImpl.$$$reportNull$$$0(1);
        }
        return this.addFileSet(new SpringFileSetImpl(id, name, this));
    }

    public SpringFileSet addFileSet(@NotNull SpringFileSet fileSet) {
        if (fileSet == null) {
            SpringFacetImpl.$$$reportNull$$$0(2);
        }
        SpringFacetImpl.assertValid(fileSet);
        this.myFileSets.add(fileSet);
        ((SpringFacetConfigurationImpl)this.getConfiguration()).addSpringFileSetData(fileSet.getData());
        Disposer.register((Disposable)this, (Disposable)fileSet);
        return fileSet;
    }

    public void removeFileSets() {
        this.myFileSets.clear();
        ((SpringFacetConfigurationImpl)this.getConfiguration()).removeFileSetDescriptors();
    }

    @Nullable
    public <S extends CustomSetting> S findSetting(@NotNull Key<S> settingsKey) {
        if (settingsKey == null) {
            SpringFacetImpl.$$$reportNull$$$0(3);
        }
        for (CustomSetting setting : ((SpringFacetConfiguration)this.getConfiguration()).getCustomSettings()) {
            if (!setting.getName().equals(settingsKey.toString())) continue;
            return (S)setting;
        }
        return null;
    }

    private static void assertValid(@NotNull SpringFileSet fileSet) {
        if (fileSet == null) {
            SpringFacetImpl.$$$reportNull$$$0(4);
        }
        String id = fileSet.getId();
        assert (StringUtil.isNotEmpty((String)id)) : "empty ID " + fileSet;
        String name = fileSet.getName();
        assert (StringUtil.isNotEmpty((String)name)) : "empty name " + fileSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsKey";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/facet/SpringFacetImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findSetting";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "assertValid";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

