/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.factories.resolvers.AbstractProxiedTypeResolver;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodInvokingFactoryBeanTypeResolver
extends AbstractProxiedTypeResolver {
    @Override
    @NotNull
    public Set<String> getObjectType(@Nullable CommonSpringBean context) {
        PsiClass psiClass;
        Module module;
        String methodName;
        SpringBean springBean;
        SpringPropertyDefinition targetMethod;
        if (context instanceof SpringBean && (targetMethod = SpringPropertyUtils.findPropertyByName((CommonSpringBean)(springBean = (SpringBean)context), (String)"targetMethod")) != null && StringUtil.isNotEmpty((String)(methodName = targetMethod.getValueAsString())) && (module = context.getModule()) != null && (psiClass = MethodInvokingFactoryBeanTypeResolver.getMethodInvokingPsiClass(null, module.getProject(), springBean)) != null) {
            PsiMethod[] methodsByName;
            for (PsiMethod method : methodsByName = psiClass.findMethodsByName(methodName, true)) {
                PsiType returnType = method.getReturnType();
                if (!(returnType instanceof PsiClassType)) continue;
                Set<String> set = Collections.singleton(returnType.getCanonicalText());
                if (set == null) {
                    MethodInvokingFactoryBeanTypeResolver.$$$reportNull$$$0(0);
                }
                return set;
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            MethodInvokingFactoryBeanTypeResolver.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Nullable
    public static PsiClass getMethodInvokingPsiClass(@Nullable GlobalSearchScope scope, @NotNull Project project, @NotNull SpringBean springBean) {
        String className;
        SpringPropertyDefinition targetClassProperty;
        SpringPropertyDefinition targetObjectProperty;
        if (project == null) {
            MethodInvokingFactoryBeanTypeResolver.$$$reportNull$$$0(2);
        }
        if (springBean == null) {
            MethodInvokingFactoryBeanTypeResolver.$$$reportNull$$$0(3);
        }
        if ((targetObjectProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)springBean, (String)"targetObject")) != null) {
            PsiType[] types;
            SpringBean bean;
            SpringBeanPointer springBeanPointer = targetObjectProperty.getRefValue();
            if (springBeanPointer != null) {
                PsiType[] types2 = springBeanPointer.getEffectiveBeanTypes();
                if (types2.length == 1) {
                    return PsiTypesUtil.getPsiClass((PsiType)types2[0]);
                }
            } else if (targetObjectProperty instanceof SpringProperty && DomUtil.hasXml((DomElement)(bean = ((SpringProperty)targetObjectProperty).getBean())) && (types = BeanService.getInstance().getEffectiveBeanTypes((CommonSpringBean)bean)).length == 1) {
                return PsiTypesUtil.getPsiClass((PsiType)types[0]);
            }
        }
        if ((targetClassProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)springBean, (String)"targetClass")) != null && (className = targetClassProperty.getValueAsString()) != null) {
            return JavaPsiFacade.getInstance((Project)project).findClass(className, scope != null ? scope : GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            MethodInvokingFactoryBeanTypeResolver.$$$reportNull$$$0(4);
        }
        return "org.springframework.beans.factory.config.MethodInvokingFactoryBean".equals(factoryClassName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/resolvers/MethodInvokingFactoryBeanTypeResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/resolvers/MethodInvokingFactoryBeanTypeResolver";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMethodInvokingPsiClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

