/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.jam.JamService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.gutter.NavigationGutterIconBuilderUtil;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.gutter.groups.SpringNavigationGutterIconBuilder;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import com.intellij.spring.model.jam.stereotype.SpringComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringImport;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScans;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextHierarchy;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.jam.testContexts.SpringTestingImplicitContextsProvider;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringClassAnnotator
extends RelatedItemLineMarkerProvider {
    public String getId() {
        return "SpringClassAnnotator";
    }

    public String getName() {
        return "Configuration (Java)";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.SpringJavaBean;
    }

    @Nullable
    protected PsiElement getElementToProcess(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            SpringClassAnnotator.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof PsiIdentifier) {
            return psiElement.getParent();
        }
        return null;
    }

    public void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringClassAnnotator.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SpringClassAnnotator.$$$reportNull$$$0(2);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringClassAnnotator.hasFacetsOrAutoConfigurationMode(psiElement) || !SpringLibraryUtil.hasSpringLibrary((Project)psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    private static boolean hasFacetsOrAutoConfigurationMode(PsiElement psiElement) {
        return SpringCommonUtils.hasSpringFacets((Project)psiElement.getProject()) || SpringGeneralSettings.getInstance((Project)psiElement.getProject()).isAllowAutoConfigurationMode();
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiElement element;
        if (psiElement == null) {
            SpringClassAnnotator.$$$reportNull$$$0(3);
        }
        if (result == null) {
            SpringClassAnnotator.$$$reportNull$$$0(4);
        }
        if ((element = this.getElementToProcess(psiElement)) instanceof PsiClass) {
            PsiIdentifier identifier = ((PsiClass)element).getNameIdentifier();
            if (identifier != null) {
                this.annotateClass(result, (PsiClass)element, identifier);
            }
        } else if (element instanceof PsiMethod) {
            PsiIdentifier identifier = ((PsiMethod)element).getNameIdentifier();
            if (identifier != null) {
                this.annotateMethod((PsiMethod)element, identifier, result);
            }
        } else if (element instanceof PsiField) {
            PsiIdentifier identifier = ((PsiField)element).getNameIdentifier();
            SpringClassAnnotator.annotateField(identifier, result, (PsiField)element);
        } else if (psiElement instanceof PsiAnnotation) {
            this.annotateComponentScan((PsiAnnotation)psiElement, result);
            this.annotateComponentScans((PsiAnnotation)psiElement, result);
        }
    }

    private void annotateClass(Collection<? super RelatedItemLineMarkerInfo> result, final @NotNull PsiClass psiClass, @NotNull PsiIdentifier identifier) {
        if (psiClass == null) {
            SpringClassAnnotator.$$$reportNull$$$0(5);
        }
        if (identifier == null) {
            SpringClassAnnotator.$$$reportNull$$$0(6);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return;
        }
        if (SpringTestContextUtil.getInstance().isTestContextConfigurationClass(psiClass)) {
            this.addTestConfigurationGutter(result, psiClass);
            return;
        }
        SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
        if (info.isMappedDomBean()) {
            SpringClassAnnotator.addSpringBeanGutterIcon(result, identifier, new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                @NotNull
                protected Collection<? extends SpringBeanPointer> compute() {
                    SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
                    List domBeans = info.getMappedDomBeans();
                    Collections.sort(domBeans, SpringBeanPointer.DISPLAY_COMPARATOR);
                    List list = domBeans;
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$1", "compute"));
                }
            });
        } else if (info.isStereotypeJavaBean()) {
            final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
            if (module == null) {
                return;
            }
            SpringClassAnnotator.addSpringJavaBeanGutterIcon(result, (PsiElement)identifier, new NotNullLazyValue<Collection<? extends CommonModelElement>>(){

                @NotNull
                protected Collection<? extends CommonModelElement> compute() {
                    SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
                    SmartList result = new SmartList();
                    List mappedBeans = info.getStereotypeMappedBeans();
                    for (JamSpringBeanPointer mappedBean : mappedBeans) {
                        if (!(mappedBean.getSpringBean() instanceof SpringJavaBean)) continue;
                        result.add(mappedBean.getSpringBean());
                    }
                    CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass);
                    ContainerUtil.addAllNotNull((Collection)result, (Iterable)SpringJamUtils.getInstance().findStereotypeConfigurationBeans(model, mappedBeans, module));
                    ContainerUtil.addAllNotNull((Collection)result, (Iterable)SpringClassAnnotator.getImportConfigurations(model, psiClass));
                    SmartList smartList = result;
                    if (smartList == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return smartList;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$2", "compute"));
                }
            }, SpringApiIcons.Gutter.SpringJavaBean);
        } else {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
            if (SpringCommonUtils.isSpringConfigured((Module)module) || SpringModelUtils.getInstance().hasAutoConfiguredModels(module)) {
                SpringClassAnnotator.annotatePsiClassSpringPropertyValues(result, psiClass, identifier, SpringModelUtils.getInstance().getSpringModel((PsiElement)psiClass).getConfigFiles());
            }
        }
    }

    private static void annotateField(@NotNull PsiIdentifier identifier, Collection<? super RelatedItemLineMarkerInfo> result, PsiField field) {
        CommonSpringModel processor;
        if (identifier == null) {
            SpringClassAnnotator.$$$reportNull$$$0(7);
        }
        if (SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)field) && (processor = SpringAutowireUtil.getProcessingSpringModel(field.getContainingClass())) != null) {
            SpringClassAnnotator.processVariable((PsiModifierListOwner)field, result, processor, identifier, field.getType());
        }
    }

    private static boolean isComponentScanAnno(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            SpringClassAnnotator.$$$reportNull$$$0(8);
        }
        if (!SpringClassAnnotator.isClassLevelAnnotation(psiAnnotation)) {
            return false;
        }
        if ("org.springframework.context.annotation.ComponentScan".equals(psiAnnotation.getQualifiedName())) {
            return true;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiClass.class);
        return psiClass != null && JamService.getJamService((Project)psiAnnotation.getProject()).getJamElement(SpringComponentScan.COMPONENT_SCAN_JAM_KEY, (PsiElement)psiClass) != null;
    }

    private static boolean isClassLevelAnnotation(PsiAnnotation psiElement) {
        PsiElement parent = psiElement.getParent();
        if (!(parent instanceof PsiModifierList)) {
            return false;
        }
        return parent.getParent() instanceof PsiClass;
    }

    private void annotateComponentScans(@NotNull PsiAnnotation psiAnnotation, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiClass psiClass;
        if (psiAnnotation == null) {
            SpringClassAnnotator.$$$reportNull$$$0(9);
        }
        if (result == null) {
            SpringClassAnnotator.$$$reportNull$$$0(10);
        }
        if ((psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiClass.class)) == null) {
            return;
        }
        JamService service = JamService.getJamService((Project)psiClass.getProject());
        SpringJamComponentScans springJamComponentScans = (SpringJamComponentScans)service.getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringJamComponentScans.META});
        if (springJamComponentScans != null) {
            for (SpringComponentScan componentScan : springJamComponentScans.getComponentScans()) {
                if (!psiAnnotation.equals(componentScan.getAnnotation())) continue;
                this.annotateSpringBeansPackagesScan(result, componentScan);
            }
        }
    }

    private void annotateComponentScan(@NotNull PsiAnnotation element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            SpringClassAnnotator.$$$reportNull$$$0(11);
        }
        if (result == null) {
            SpringClassAnnotator.$$$reportNull$$$0(12);
        }
        if (!SpringClassAnnotator.isComponentScanAnno(element)) {
            return;
        }
        PsiClass owner = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (owner != null) {
            List scans = SpringJamUtils.getInstance().getBeansPackagesScan(owner);
            for (SpringBeansPackagesScan scan : scans) {
                if (!(scan instanceof SpringComponentScan) || !element.equals(((SpringComponentScan)scan).getAnnotation())) continue;
                this.annotateSpringBeansPackagesScan(result, (SpringComponentScan)scan);
                return;
            }
        }
    }

    private void annotateSpringBeansPackagesScan(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, final SpringComponentScan scan) {
        PsiAnnotation psiAnnotation;
        if (result == null) {
            SpringClassAnnotator.$$$reportNull$$$0(13);
        }
        if ((psiAnnotation = scan.getAnnotation()) == null) {
            return;
        }
        PsiElement identifier = this.getIdentifierLocal(psiAnnotation);
        if (identifier == null) {
            return;
        }
        SpringClassAnnotator.addSpringJavaBeanGutterIcon(result, identifier, new NotNullLazyValue<Collection<? extends CommonModelElement>>(){

            @NotNull
            protected Collection<? extends CommonModelElement> compute() {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiAnnotation);
                if (module == null) {
                    Set set = Collections.emptySet();
                    if (set == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return set;
                }
                Set scannedElements = scan.getScannedElements(module);
                ArrayList beans = new ArrayList(BeanService.getInstance().mapSpringBeans((Collection)scannedElements));
                Collections.sort(beans, SpringBeanPointer.DISPLAY_COMPARATOR);
                List list = ContainerUtil.map(beans, (Function)SpringBeanPointer.TO_BEAN);
                if (list == null) {
                    3.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$3", "compute"));
            }
        }, SpringApiIcons.Gutter.SpringScan);
    }

    private void addTestConfigurationGutter(Collection<? super RelatedItemLineMarkerInfo> result, PsiClass psiClass) {
        SpringContextHierarchy hierarchy;
        JamService service = JamService.getJamService((Project)psiClass.getProject());
        ContextConfiguration contextConfiguration = (ContextConfiguration)service.getJamElement(ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY, (PsiElement)psiClass);
        if (contextConfiguration != null) {
            this.annotateContextConfiguration(result, contextConfiguration, psiClass);
        }
        if ((hierarchy = (SpringContextHierarchy)service.getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringContextHierarchy.META})) != null) {
            for (SpringContextConfiguration configuration : hierarchy.getContextConfigurations()) {
                this.annotateContextConfiguration(result, (ContextConfiguration)configuration, psiClass);
            }
        }
    }

    private void annotateContextConfiguration(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull ContextConfiguration contextConfiguration, @NotNull PsiClass psiClass) {
        PsiAnnotation annotation;
        if (result == null) {
            SpringClassAnnotator.$$$reportNull$$$0(14);
        }
        if (contextConfiguration == null) {
            SpringClassAnnotator.$$$reportNull$$$0(15);
        }
        if (psiClass == null) {
            SpringClassAnnotator.$$$reportNull$$$0(16);
        }
        if ((annotation = contextConfiguration.getAnnotation()) != null) {
            LinkedHashSet xmlContexts = ContainerUtil.newLinkedHashSet();
            LinkedHashSet javaContexts = ContainerUtil.newLinkedHashSet();
            SpringTestContextUtil.getInstance().discoverConfigFiles(contextConfiguration, (Set)xmlContexts, (Set)javaContexts, new PsiClass[]{psiClass});
            LinkedHashSet toNavigate = ContainerUtil.newLinkedHashSet();
            toNavigate.addAll(xmlContexts);
            toNavigate.addAll(javaContexts);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
            if (module != null) {
                for (SpringTestingImplicitContextsProvider provider : (SpringTestingImplicitContextsProvider[])Extensions.getExtensions((ExtensionPointName)SpringTestingImplicitContextsProvider.EP_NAME)) {
                    for (CommonSpringModel model : provider.getModels(module, contextConfiguration)) {
                        if (!(model instanceof LocalModel)) continue;
                        toNavigate.add(((LocalModel)model).getConfig());
                    }
                }
            }
            NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.Gutter.Spring).setTargets((Collection)toNavigate).setPopupTitle(SpringBundle.message("spring.app.context.to.navigate", new Object[0])).setTooltipText(SpringBundle.message("spring.app.context.navigate.tooltip", new Object[0]));
            PsiElement identifier = this.getIdentifierLocal(annotation);
            if (identifier != null) {
                result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(identifier));
            }
        }
    }

    protected PsiElement getIdentifierLocal(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            SpringClassAnnotator.$$$reportNull$$$0(17);
        }
        return SpringClassAnnotator.getIdentifier(annotation);
    }

    public static PsiElement getIdentifier(@NotNull PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement identifier;
        if (annotation == null) {
            SpringClassAnnotator.$$$reportNull$$$0(18);
        }
        return (identifier = annotation.getNameReferenceElement()) == null ? null : identifier.getReferenceNameElement();
    }

    private static void annotatePsiClassSpringPropertyValues(Collection<? super RelatedItemLineMarkerInfo> result, @NotNull PsiClass psiClass, @NotNull PsiIdentifier identifier, @NotNull Set<? extends PsiFile> xmlConfigFiles) {
        if (psiClass == null) {
            SpringClassAnnotator.$$$reportNull$$$0(19);
        }
        if (identifier == null) {
            SpringClassAnnotator.$$$reportNull$$$0(20);
        }
        if (xmlConfigFiles == null) {
            SpringClassAnnotator.$$$reportNull$$$0(21);
        }
        if (DumbService.isDumb((Project)psiClass.getProject())) {
            return;
        }
        if (xmlConfigFiles.isEmpty()) {
            return;
        }
        final List values = Collections.synchronizedList(new ArrayList());
        List springFiles = ContainerUtil.mapNotNull(xmlConfigFiles, psiFile -> psiFile instanceof XmlFile ? psiFile.getVirtualFile() : null);
        ReferencesSearch.search((PsiElement)psiClass, (SearchScope)GlobalSearchScope.filesScope((Project)psiClass.getProject(), (Collection)springFiles)).forEach(psiReference -> {
            SpringProperty value;
            DomElement domElement;
            PsiElement element = psiReference.getElement();
            if (element instanceof XmlElement && (domElement = DomUtil.getDomElement((PsiElement)element)) != null && !SpringClassAnnotator.isAnonymousBeanClass(domElement) && (value = (SpringProperty)domElement.getParentOfType(SpringProperty.class, false)) != null) {
                values.add(value);
            }
            return true;
        });
        if (!values.isEmpty()) {
            SpringClassAnnotator.addPropertiesGutterIcon(result, identifier, new NotNullLazyValue<Collection<? extends DomElement>>(){

                @NotNull
                protected Collection<? extends DomElement> compute() {
                    List list = values;
                    if (list == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$4", "compute"));
                }
            });
        }
    }

    private static boolean isAnonymousBeanClass(DomElement domElement) {
        GenericAttributeValue genericAttributeValue = (GenericAttributeValue)domElement.getParentOfType(GenericAttributeValue.class, false);
        if (genericAttributeValue != null && "class".equals(genericAttributeValue.getXmlElementName())) {
            return genericAttributeValue.getParent() instanceof SpringBean;
        }
        return false;
    }

    private void annotateMethod(final @NotNull PsiMethod method, @NotNull PsiIdentifier identifier, Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiClass psiClass;
        if (method == null) {
            SpringClassAnnotator.$$$reportNull$$$0(22);
        }
        if (identifier == null) {
            SpringClassAnnotator.$$$reportNull$$$0(23);
        }
        if (SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)(psiClass = method.getContainingClass()))) {
            Collection methodTypes;
            SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
            boolean autowired = false;
            if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) {
                if (info.isMappedProperty(method)) {
                    SpringClassAnnotator.addPropertiesGutterIcon(result, identifier, new NotNullLazyValue<Collection<? extends DomElement>>(){

                        @NotNull
                        protected Collection<? extends DomElement> compute() {
                            String propertyName = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)method);
                            SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
                            Collection collection = info.getMappedProperties(propertyName);
                            if (collection == null) {
                                5.$$$reportNull$$$0(0);
                            }
                            return collection;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$5", "compute"));
                        }
                    });
                } else {
                    autowired = info.isAutowired();
                    if (autowired) {
                        SpringClassAnnotator.checkAutowiredMethod(method, result, info, identifier);
                    }
                }
            } else if (method.isConstructor()) {
                if (info.isMappedConstructor(method)) {
                    SpringClassAnnotator.addConstructorArgsGutterIcon(result, identifier, new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                        @NotNull
                        protected Collection<? extends SpringBeanPointer> compute() {
                            SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
                            Collection collection = info.getMappedConstructorDefinitions(method);
                            if (collection == null) {
                                6.$$$reportNull$$$0(0);
                            }
                            return collection;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$6", "compute"));
                        }
                    });
                }
            } else {
                List externalBeans;
                ContextJavaBean bean = SpringClassAnnotator.getStereotypeBean(method);
                if (bean != null) {
                    this.addStereotypeBeanAutowiredCandidatesBeanGutterIcon(result, method, bean.getPsiAnnotation());
                }
                if (!(externalBeans = SpringOldJavaConfigurationUtil.findExternalBeans((PsiMethod)method)).isEmpty()) {
                    SpringClassAnnotator.addSpringBeanGutterIcon(result, identifier, new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                        @NotNull
                        protected Collection<? extends SpringBeanPointer> compute() {
                            List externalBeans = SpringOldJavaConfigurationUtil.findExternalBeans((PsiMethod)method);
                            Collections.sort(externalBeans, SpringBeanPointer.DISPLAY_COMPARATOR);
                            List list = externalBeans;
                            if (list == null) {
                                7.$$$reportNull$$$0(0);
                            }
                            return list;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$7", "compute"));
                        }
                    });
                }
            }
            if (!autowired) {
                SpringClassAnnotator.processAnnotatedMethod(method, result);
            }
            if (!(methodTypes = info.getMethodTypes(method)).isEmpty()) {
                SpringClassAnnotator.addMethodTypesGutterIcon(result, method, methodTypes);
            }
        }
    }

    private static ContextJavaBean getStereotypeBean(@NotNull PsiMethod method) {
        if (method == null) {
            SpringClassAnnotator.$$$reportNull$$$0(24);
        }
        return (ContextJavaBean)JamService.getJamService((Project)method.getProject()).getJamElement(ContextJavaBean.BEAN_JAM_KEY, (PsiElement)method);
    }

    public static boolean checkAutowiredMethod(PsiMethod method, @Nullable Collection<? super RelatedItemLineMarkerInfo> result, SpringJavaClassInfo info, @NotNull PsiIdentifier identifier) {
        CommonSpringModel model;
        if (identifier == null) {
            SpringClassAnnotator.$$$reportNull$$$0(25);
        }
        if ((model = SpringAutowireUtil.getProcessingSpringModel(method.getContainingClass())) != null) {
            for (Autowire autowire : info.getAutowires()) {
                if (autowire == Autowire.BY_TYPE) {
                    PsiType type = PropertyUtilBase.getPropertyType((PsiMember)method);
                    if (type == null) continue;
                    return SpringClassAnnotator.processVariable((PsiModifierListOwner)method, result, model, identifier, type);
                }
                if (autowire != Autowire.BY_NAME) continue;
                return SpringClassAnnotator.annotateByNameAutowiredMethod((PsiModifierListOwner)method, result, model, identifier);
            }
        }
        return false;
    }

    private static boolean annotateByNameAutowiredMethod(PsiModifierListOwner owner, @Nullable Collection<? super RelatedItemLineMarkerInfo> result, @NotNull CommonSpringModel model, @NotNull PsiIdentifier identifier) {
        Collection<SpringBeanPointer> collection;
        if (model == null) {
            SpringClassAnnotator.$$$reportNull$$$0(26);
        }
        if (identifier == null) {
            SpringClassAnnotator.$$$reportNull$$$0(27);
        }
        if ((collection = SpringClassAnnotator.getByNameAutowiredBean(owner, model)) != null && !collection.isEmpty()) {
            if (result != null) {
                NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(collection, result, (PsiElement)identifier, SpringBundle.message("navigate.to.by.name.autowired.dependencies", new Object[0]));
            }
            return true;
        }
        return false;
    }

    private static Collection<SpringBeanPointer> getByNameAutowiredBean(@NotNull PsiModifierListOwner owner, @NotNull CommonSpringModel model) {
        SpringBeanPointer bean;
        if (owner == null) {
            SpringClassAnnotator.$$$reportNull$$$0(28);
        }
        if (model == null) {
            SpringClassAnnotator.$$$reportNull$$$0(29);
        }
        String name = null;
        if (owner instanceof PsiMethod) {
            name = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)((PsiMethod)owner));
        } else if (owner instanceof PsiField) {
            name = ((PsiField)owner).getName();
        }
        if (name != null && (bean = SpringModelSearchers.findBean((CommonSpringModel)model, (String)name)) != null) {
            return Collections.singleton(bean.getBasePointer());
        }
        return Collections.emptySet();
    }

    private static void processAnnotatedMethod(PsiMethod method, Collection<? super RelatedItemLineMarkerInfo> result) {
        CommonSpringModel model;
        if (SpringAutowireUtil.isInjectionPoint(method) && (model = SpringAutowireUtil.getProcessingSpringModel(method.getContainingClass())) != null) {
            if (SpringAutowireUtil.getResourceAnnotation((PsiModifierListOwner)method) != null && PropertyUtil.isSimplePropertySetter((PsiMethod)method)) {
                PsiParameter parameter = method.getParameterList().getParameters()[0];
                PsiIdentifier identifier = parameter.getNameIdentifier();
                if (identifier != null) {
                    SpringClassAnnotator.processVariable((PsiModifierListOwner)method, result, model, identifier, parameter.getType());
                }
            } else {
                for (PsiParameter parameter : method.getParameterList().getParameters()) {
                    PsiIdentifier identifier = parameter.getNameIdentifier();
                    if (identifier == null) continue;
                    SpringClassAnnotator.processVariable((PsiModifierListOwner)parameter, result, model, identifier, parameter.getType());
                }
            }
        }
    }

    private static boolean processVariable(PsiModifierListOwner variable, @Nullable Collection<? super RelatedItemLineMarkerInfo> result, @NotNull CommonSpringModel model, @NotNull PsiIdentifier identifier, @NotNull PsiType type) {
        Set<SpringBeanPointer> list;
        if (model == null) {
            SpringClassAnnotator.$$$reportNull$$$0(30);
        }
        if (identifier == null) {
            SpringClassAnnotator.$$$reportNull$$$0(31);
        }
        if (type == null) {
            SpringClassAnnotator.$$$reportNull$$$0(32);
        }
        if (!(list = SpringAutowireUtil.getAutowiredBeansFor(variable, SpringClassAnnotator.getAutowiredType(type), model)).isEmpty()) {
            if (result != null) {
                NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(list, result, (PsiElement)identifier);
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static PsiType getAutowiredType(@NotNull PsiType type) {
        PsiType optionalType;
        if (type == null) {
            SpringClassAnnotator.$$$reportNull$$$0(33);
        }
        if (SpringAutowireUtil.isJavaUtilOptional(type) && (optionalType = SpringClassAnnotator.getOptionalType(type)) != null) {
            PsiType psiType = optionalType;
            if (psiType == null) {
                SpringClassAnnotator.$$$reportNull$$$0(34);
            }
            return psiType;
        }
        PsiType psiType = type;
        if (psiType == null) {
            SpringClassAnnotator.$$$reportNull$$$0(35);
        }
        return psiType;
    }

    @Nullable
    private static PsiType getOptionalType(@NotNull PsiType type) {
        if (type == null) {
            SpringClassAnnotator.$$$reportNull$$$0(36);
        }
        return PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Optional", (int)0, (boolean)false);
    }

    private static void addMethodTypesGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiMethod psiMethod, Collection<Pair<PsiElement, SpringJavaClassInfo.SpringMethodType>> targets) {
        String tooltipText = SpringBundle.message("spring.bean.methods.tooltip.navigate.declaration", new Object[0]);
        Icon icon = SpringApiIcons.Gutter.SpringBeanMethod;
        if (targets.size() == 1) {
            SpringJavaClassInfo.SpringMethodType methodType = (SpringJavaClassInfo.SpringMethodType)targets.iterator().next().second;
            tooltipText = SpringBundle.message("spring.bean.method.tooltip.navigate.declaration", methodType.getName());
            if (methodType == SpringJavaClassInfo.SpringMethodType.FACTORY) {
                icon = SpringApiIcons.Gutter.FactoryMethodBean;
            }
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)icon).setTargets((Collection)ContainerUtil.mapNotNull(targets, pair -> (PsiElement)pair.getFirst())).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setTooltipText(tooltipText);
        PsiIdentifier identifier = psiMethod.getNameIdentifier();
        if (identifier != null) {
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)identifier));
        }
    }

    private static void addPropertiesGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiIdentifier psiIdentifier, NotNullLazyValue<Collection<? extends DomElement>> targets) {
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.Gutter.SpringProperty, (NotNullFunction)NavigationGutterIconBuilder.DEFAULT_DOM_CONVERTOR, (NotNullFunction)NavigationGutterIconBuilder.DOM_GOTO_RELATED_ITEM_PROVIDER).setTargets(targets).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setPopupTitle(SpringBundle.message("spring.bean.property.navigate.choose.class.title", new Object[0])).setTooltipText(SpringBundle.message("spring.bean.property.tooltip.navigate.declaration", new Object[0]));
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)psiIdentifier));
    }

    private static void addConstructorArgsGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiIdentifier psiIdentifier, NotNullLazyValue<Collection<? extends SpringBeanPointer>> targets) {
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.Gutter.SpringBeanMethod, NavigationGutterIconBuilderUtil.BEAN_POINTER_CONVERTOR, NavigationGutterIconBuilderUtil.BEAN_POINTER_GOTO_PROVIDER).setTargets(targets).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setPopupTitle(SpringBundle.message("spring.bean.constructor.navigate.choose.class.title", new Object[0])).setTooltipText(SpringBundle.message("spring.bean.constructor.tooltip.navigate.declaration", new Object[0]));
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)psiIdentifier));
    }

    private static void addSpringJavaBeanGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends CommonModelElement>> targets, Icon icon) {
        NavigationGutterIconBuilder builder = new SpringNavigationGutterIconBuilder<CommonModelElement>(icon, NavigationGutterIconBuilderUtil.COMMON_MODEL_ELEMENT_CONVERTOR, NavigationGutterIconBuilderUtil.COMMON_MODEL_ELEMENT_GOTO_PROVIDER).setTargets(targets).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.beans", new Object[0])).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setTooltipText(SpringBundle.message("spring.bean.class.tooltip.navigate.declaration", new Object[0]));
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(psiIdentifier));
    }

    private static void addSpringBeanGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiIdentifier psiIdentifier, NotNullLazyValue<Collection<? extends SpringBeanPointer>> targets) {
        NavigationGutterIconBuilder builder = new SpringNavigationGutterIconBuilder<SpringBeanPointer>(SpringApiIcons.Gutter.SpringBean, NavigationGutterIconBuilderUtil.BEAN_POINTER_CONVERTOR, NavigationGutterIconBuilderUtil.BEAN_POINTER_GOTO_PROVIDER).setTargets(targets).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.beans", new Object[0])).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setTooltipText(SpringBundle.message("spring.bean.class.tooltip.navigate.declaration", new Object[0]));
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)psiIdentifier));
    }

    private void addStereotypeBeanAutowiredCandidatesBeanGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, final @NotNull PsiMethod method, @NotNull PsiAnnotation annotation) {
        if (method == null) {
            SpringClassAnnotator.$$$reportNull$$$0(37);
        }
        if (annotation == null) {
            SpringClassAnnotator.$$$reportNull$$$0(38);
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.Gutter.ShowAutowiredDependencies).setPopupTitle(SpringBundle.message("gutter.choose.autowired.candidates.title", new Object[0])).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.autowired.candidates", new Object[0])).setTooltipText(SpringBundle.message("gutter.navigate.to.autowired.candidates.title", new Object[0])).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends PsiElement>>(){

            @NotNull
            protected Collection<? extends PsiElement> compute() {
                PsiType type = method.getReturnType();
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)method);
                Set<Object> set = type != null && module != null ? SpringAutowireUtil.getAutowiredMembers(type, module, method) : Collections.emptySet();
                if (set == null) {
                    8.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringClassAnnotator$8", "compute"));
            }
        });
        PsiElement identifier = this.getIdentifierLocal(annotation);
        if (identifier != null) {
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(identifier));
        }
    }

    @Nullable
    public static SpringFileSet getFileset(@NotNull PsiFile psiFile, @NotNull Module module) {
        if (psiFile == null) {
            SpringClassAnnotator.$$$reportNull$$$0(39);
        }
        if (module == null) {
            SpringClassAnnotator.$$$reportNull$$$0(40);
        }
        Ref filesetResult = Ref.create();
        ModuleUtilCore.visitMeAndDependentModules((Module)module, depModule -> {
            SpringFacet springFacet;
            if (module == null) {
                SpringClassAnnotator.$$$reportNull$$$0(44);
            }
            if (psiFile == null) {
                SpringClassAnnotator.$$$reportNull$$$0(45);
            }
            if ((springFacet = SpringFacet.getInstance((Module)module)) == null) {
                return true;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            for (SpringFileSet fileSet : SpringFileSetService.getInstance().getAllSets(springFacet)) {
                if (!fileSet.hasFile(virtualFile)) continue;
                filesetResult.set((Object)fileSet);
                return false;
            }
            return true;
        });
        return (SpringFileSet)filesetResult.get();
    }

    private static List<CommonModelElement> getImportConfigurations(@NotNull CommonSpringModel model, @NotNull PsiClass psiClass) {
        Module module;
        if (model == null) {
            SpringClassAnnotator.$$$reportNull$$$0(41);
        }
        if (psiClass == null) {
            SpringClassAnnotator.$$$reportNull$$$0(42);
        }
        if ((module = model.getModule()) == null) {
            return Collections.emptyList();
        }
        List result = ContainerUtil.newSmartList();
        if (model instanceof SpringModel) {
            ((SpringModel)model).processModels(visitedModel -> {
                PsiClass clazz;
                SpringImport springImport;
                if (psiClass == null) {
                    SpringClassAnnotator.$$$reportNull$$$0(43);
                }
                if (visitedModel instanceof LocalAnnotationModel && (springImport = (SpringImport)SemService.getSemService((Project)(clazz = (PsiClass)((LocalAnnotationModel)visitedModel).getConfig()).getProject()).getSemElement(SpringImport.IMPORT_JAM_KEY, (PsiElement)clazz)) != null && springImport.getImportedClasses().contains(psiClass)) {
                    result.add(springImport);
                }
                return true;
            });
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 16: 
            case 19: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 6: 
            case 7: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextConfiguration";
                break;
            }
            case 17: 
            case 18: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlConfigFiles";
                break;
            }
            case 22: 
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 26: 
            case 29: 
            case 30: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 32: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/gutter/SpringClassAnnotator";
                break;
            }
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/gutter/SpringClassAnnotator";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutowiredType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementToProcess";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "annotateClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "annotateField";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isComponentScanAnno";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "annotateComponentScans";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "annotateComponentScan";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "annotateSpringBeansPackagesScan";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "annotateContextConfiguration";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifierLocal";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifier";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "annotatePsiClassSpringPropertyValues";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "annotateMethod";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getStereotypeBean";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkAutowiredMethod";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "annotateByNameAutowiredMethod";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getByNameAutowiredBean";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processVariable";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredType";
                break;
            }
            case 34: 
            case 35: {
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getOptionalType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addStereotypeBeanAutowiredCandidatesBeanGutterIcon";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getFileset";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getImportConfigurations";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getImportConfigurations$4";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFileset$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

