/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.facet.FacetFinder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.graph.LazyModelDependenciesGraph;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.util.Chunk;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.xml.DomService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAutoConfiguredModels {
    private static final List<String> bootAnnotations = Arrays.asList("org.springframework.boot.autoconfigure.SpringBootApplication", "org.springframework.boot.autoconfigure.EnableAutoConfiguration");

    @NotNull
    public static CachedValueProvider.Result<Set<SpringModel>> getAutoConfiguredModels(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(0);
        }
        Set<SpringModel> models = SpringAutoConfiguredModels.discoverAutoConfiguredModels(module);
        CachedValueProvider.Result result = CachedValueProvider.Result.create(models, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, FacetFinder.getInstance((Project)module.getProject()).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID)});
        if (result == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(1);
        }
        return result;
    }

    @NotNull
    public static Set<SpringModel> discoverAutoConfiguredModels(@NotNull Module module) {
        Set<SpringModel> springBootModels;
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(2);
        }
        if (!(springBootModels = SpringAutoConfiguredModels.getSpringBootModels(module)).isEmpty()) {
            Set<SpringModel> set = springBootModels;
            if (set == null) {
                SpringAutoConfiguredModels.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<LocalModel> autoConfiguredModels = SpringAutoConfiguredModels.getAutoConfiguredLocalModels(module);
        if (autoConfiguredModels.isEmpty()) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                SpringAutoConfiguredModels.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<SpringModel> set = Collections.singleton(new CombinedSpringModelImpl(SpringAutoConfiguredModels.getAutoConfiguredLocalModels(module), module));
        if (set == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public static Set<SpringModel> getSpringBootModels(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(6);
        }
        LinkedHashSet<SpringModel> bootApplications = new LinkedHashSet<SpringModel>();
        for (String bootAnno : bootAnnotations) {
            bootApplications.addAll(SpringAutoConfiguredModels.getAnnoConfiguredModels(module, bootAnno));
        }
        LinkedHashSet<SpringModel> linkedHashSet = bootApplications;
        if (linkedHashSet == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Set<LocalModel> getAutoConfiguredLocalModels(@NotNull Module module) {
        Set<LocalModel> localModels;
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(8);
        }
        if (!(localModels = SpringAutoConfiguredModels.getLocalModelCandidates(module)).isEmpty()) {
            Set<LocalModel> set = SpringAutoConfiguredModels.filterAutoConfiguredModelsSet(localModels, module);
            if (set == null) {
                SpringAutoConfiguredModels.$$$reportNull$$$0(9);
            }
            return set;
        }
        Set<LocalModel> set = Collections.emptySet();
        if (set == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public static Set<LocalModel> getLocalModelCandidates(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(11);
        }
        LinkedHashSet localModels = ContainerUtil.newLinkedHashSet();
        localModels.addAll(SpringAutoConfiguredModels.getLocalAnnotationModelCandidates(module));
        localModels.addAll(SpringAutoConfiguredModels.getLocalXmlModelCandidates(module));
        LinkedHashSet linkedHashSet = localModels;
        if (linkedHashSet == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(12);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<LocalModel> filterAutoConfiguredModelsSet(@NotNull Set<LocalModel> models, @NotNull Module module) {
        if (models == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(13);
        }
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(14);
        }
        LazyModelDependenciesGraph graph = SpringAutoConfiguredModels.getModelsGraph(models, module);
        HashSet configuredModels = ContainerUtil.newHashSet();
        Graph sccGraph = GraphAlgorithms.getInstance().computeSCCGraph((Graph)graph);
        for (Chunk chunk : sccGraph.getNodes()) {
            Set chunkNodes;
            if (sccGraph.getIn((Object)chunk).hasNext() || !(chunkNodes = chunk.getNodes()).iterator().hasNext()) continue;
            configuredModels.add(chunkNodes.iterator().next());
        }
        HashSet hashSet = configuredModels;
        if (hashSet == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    @NotNull
    private static LazyModelDependenciesGraph getModelsGraph(final @Nullable Set<LocalModel> models, @NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(16);
        }
        LazyModelDependenciesGraph lazyModelDependenciesGraph = new LazyModelDependenciesGraph(module, Collections.emptySet()){

            public Collection<LocalModel> getNodes() {
                return models;
            }
        };
        if (lazyModelDependenciesGraph == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(17);
        }
        return lazyModelDependenciesGraph;
    }

    @NotNull
    private static Set<LocalAnnotationModel> getLocalAnnotationModelCandidates(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(18);
        }
        List configurations = SpringJamModel.getModel((Module)module).getConfigurations(GlobalSearchScope.moduleWithDependenciesScope((Module)module));
        Set<LocalAnnotationModel> set = configurations.stream().filter(configuration -> {
            PsiFile file = configuration.getContainingFile();
            return file != null && !SpringAutoConfiguredModels.isInTestSourceContent(file.getProject(), file.getVirtualFile());
        }).filter(configuration -> SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)configuration.getPsiElement())).map(configuration -> {
            if (module == null) {
                SpringAutoConfiguredModels.$$$reportNull$$$0(30);
            }
            return SpringManager.getInstance((Project)module.getProject()).getLocalSpringModel(configuration.getPsiElement(), module);
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(19);
        }
        return set;
    }

    @NotNull
    private static Set<LocalXmlModel> getLocalXmlModelCandidates(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(20);
        }
        Project project = module.getProject();
        Collection springXmlCandidates = DomService.getInstance().getDomFileCandidates(Beans.class, project, GlobalSearchScope.moduleWithDependenciesScope((Module)module));
        Set<LocalXmlModel> set = springXmlCandidates.stream().filter(vf -> ApplicationManager.getApplication().isUnitTestMode() || !SpringAutoConfiguredModels.isInTestSourceContent(project, vf)).map(file -> {
            PsiFile psiFile;
            if (module == null) {
                SpringAutoConfiguredModels.$$$reportNull$$$0(29);
            }
            return (psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof XmlFile ? SpringManager.getInstance((Project)project).getLocalSpringModel((XmlFile)psiFile, module) : null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(21);
        }
        return set;
    }

    private static boolean isInTestSourceContent(@NotNull Project project, @Nullable VirtualFile vf) {
        if (project == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(22);
        }
        return vf != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(vf);
    }

    @NotNull
    private static Set<SpringModel> getAnnoConfiguredModels(@NotNull Module module, @NotNull String anno) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(23);
        }
        if (anno == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(24);
        }
        if (DumbService.isDumb((Project)module.getProject())) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                SpringAutoConfiguredModels.$$$reportNull$$$0(25);
            }
            return set;
        }
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        PsiClass psiAnno = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(anno, scope);
        if (psiAnno != null) {
            for (PsiMember member : AnnotatedMembersSearch.search((PsiClass)psiAnno, (SearchScope)scope).findAll()) {
                LocalAnnotationModel localAnnotationModel;
                if (!(member instanceof PsiClass) || !SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)((PsiClass)member)) || (localAnnotationModel = SpringManager.getInstance((Project)module.getProject()).getLocalSpringModel((PsiClass)member, module)) == null) continue;
                models.add(new CombinedSpringModelImpl(Collections.singleton(localAnnotationModel), localAnnotationModel.getModule()));
            }
        }
        LinkedHashSet linkedHashSet = models;
        if (linkedHashSet == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(26);
        }
        return linkedHashSet;
    }

    public static boolean isAllowAutoConfiguration(@NotNull Project project) {
        if (project == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(27);
        }
        return !project.isDisposed() && SpringGeneralSettings.getInstance((Project)project).isAllowAutoConfigurationMode();
    }

    public static boolean hasAutoConfiguredModels(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(28);
        }
        return SpringAutoConfiguredModels.isAllowAutoConfiguration(module.getProject()) && !((Set)SpringAutoConfiguredModels.getAutoConfiguredModels(module).getValue()).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/impl/SpringAutoConfiguredModels";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/impl/SpringAutoConfiguredModels";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfiguredModels";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverAutoConfiguredModels";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringBootModels";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfiguredLocalModels";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalModelCandidates";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAutoConfiguredModelsSet";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelsGraph";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalAnnotationModelCandidates";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalXmlModelCandidates";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnoConfiguredModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAutoConfiguredModels";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "discoverAutoConfiguredModels";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSpringBootModels";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAutoConfiguredLocalModels";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLocalModelCandidates";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "filterAutoConfiguredModelsSet";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getModelsGraph";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLocalAnnotationModelCandidates";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLocalXmlModelCandidates";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAnnoConfiguredModels";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isAllowAutoConfiguration";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasAutoConfiguredModels";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLocalXmlModelCandidates$4";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLocalAnnotationModelCandidates$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

