/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters.fixes.bean;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.CreateElementQuickFixProvider;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixProvider;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringInjection;
import com.intellij.spring.model.xml.beans.TypeHolder;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GenericSpringBeanResolveQuickFixProvider
implements SpringBeanResolveQuickFixProvider {
    GenericSpringBeanResolveQuickFixProvider() {
    }

    @Override
    @NotNull
    public List<LocalQuickFix> getQuickFixes(ConvertContext context, @NotNull Beans beans, @Nullable String beanId, List<PsiClassType> requiredClasses) {
        if (beans == null) {
            GenericSpringBeanResolveQuickFixProvider.$$$reportNull$$$0(0);
        }
        LocalQuickFix[] fixes = new CreateGenericBeanQuickFix(beans, beanId).getQuickFixes((GenericDomValue)context.getInvocationElement());
        List<LocalQuickFix> list = Arrays.asList(fixes);
        if (list == null) {
            GenericSpringBeanResolveQuickFixProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/fixes/bean/GenericSpringBeanResolveQuickFixProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/fixes/bean/GenericSpringBeanResolveQuickFixProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CreateGenericBeanQuickFix
    extends CreateElementQuickFixProvider<SpringBeanPointer> {
        private final Beans beans;
        @Nullable
        private final String beanId;

        private CreateGenericBeanQuickFix(Beans beans, @Nullable String beanId) {
            super(SpringBundle.message("model.bean.quickfix.message.family.name", new Object[0]));
            this.beans = beans;
            this.beanId = beanId;
        }

        @Override
        @Nullable
        protected String getElementName(@NotNull GenericDomValue<SpringBeanPointer> value) {
            if (value == null) {
                CreateGenericBeanQuickFix.$$$reportNull$$$0(0);
            }
            return this.beanId != null ? this.beanId : super.getElementName(value);
        }

        @Override
        protected void apply(String elementName, GenericDomValue<SpringBeanPointer> value) {
            PsiClass psiClass;
            PsiClassType classType;
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.beans.getXmlElement())) {
                return;
            }
            SpringBean springBean = this.beans.addBean();
            springBean.setName(elementName);
            DomElement parent = value.getParent();
            if (parent instanceof SpringInjection && (classType = TypeHolderUtil.getRequiredClassType((TypeHolder)((SpringInjection)parent))) != null && (psiClass = classType.resolve()) != null) {
                GenericAttributeValue clazzAttribute = springBean.getClazz();
                if (psiClass.isInterface()) {
                    clazzAttribute.setStringValue("");
                    PsiNavigateUtil.navigate((PsiElement)clazzAttribute.getXmlAttributeValue());
                    return;
                }
                clazzAttribute.setStringValue(psiClass.getQualifiedName());
            }
        }

        @Override
        @NotNull
        protected String getFixName(String elementName) {
            String string = SpringBundle.message("model.bean.quickfix.message", elementName);
            if (string == null) {
                CreateGenericBeanQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/converters/fixes/bean/GenericSpringBeanResolveQuickFixProvider$CreateGenericBeanQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/converters/fixes/bean/GenericSpringBeanResolveQuickFixProvider$CreateGenericBeanQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFixName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

