/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringContextIncludeRegexFilter
extends SpringContextFilter.IncludeExpression {
    public SpringContextIncludeRegexFilter(@Nullable String expression) {
        super(expression);
    }

    @NotNull
    public Set<SpringStereotypeElement> includeStereotypes(@NotNull Module module, @NotNull Set<PsiPackage> packages) {
        if (module == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(0);
        }
        if (packages == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(1);
        }
        LinkedHashSet components = ContainerUtil.newLinkedHashSet();
        String regexp = this.getExpression();
        if (!StringUtil.isEmptyOrSpaces((String)regexp)) {
            try {
                Pattern pattern = Pattern.compile(regexp);
                GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                for (PsiClass annotatedClass : SpringContextIncludeRegexFilter.findClassesByMask(searchScope, pattern, packages)) {
                    components.add(new CustomSpringComponent(annotatedClass));
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        LinkedHashSet linkedHashSet = components;
        if (linkedHashSet == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    private static Set<PsiClass> findClassesByMask(GlobalSearchScope searchScope, @NotNull Pattern pattern, @NotNull Set<PsiPackage> packages) {
        if (pattern == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(3);
        }
        if (packages == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(4);
        }
        LinkedHashSet classes = ContainerUtil.newLinkedHashSet();
        for (PsiPackage psiPackage : packages) {
            SpringContextIncludeRegexFilter.findClassesByMask(searchScope, pattern, classes, psiPackage);
        }
        return classes;
    }

    private static void findClassesByMask(@NotNull GlobalSearchScope searchScope, @NotNull Pattern pattern, @NotNull Set<PsiClass> classes, @NotNull PsiPackage psiPackage) {
        if (searchScope == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(5);
        }
        if (pattern == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(6);
        }
        if (classes == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(7);
        }
        if (psiPackage == null) {
            SpringContextIncludeRegexFilter.$$$reportNull$$$0(8);
        }
        for (PsiClass psiClass : psiPackage.getClasses(searchScope)) {
            String fqn = psiClass.getQualifiedName();
            if (fqn == null || !pattern.matcher(fqn).matches()) continue;
            classes.add(psiClass);
        }
        for (PsiClass psiClass : psiPackage.getSubPackages(searchScope)) {
            SpringContextIncludeRegexFilter.findClassesByMask(searchScope, pattern, classes, (PsiPackage)psiClass);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeRegexFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "includeStereotypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "includeStereotypes";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClassesByMask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

