/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.navigation;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringModelRelatedFileProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement psiElement) {
        PsiFile containingFile;
        if (psiElement == null) {
            SpringModelRelatedFileProvider.$$$reportNull$$$0(0);
        }
        if ((containingFile = psiElement.getContainingFile()) instanceof XmlFile && !SpringDomUtils.isSpringXml((XmlFile)((XmlFile)containingFile))) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringModelRelatedFileProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (!(containingFile instanceof PsiClassOwner)) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringModelRelatedFileProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (!SpringLibraryUtil.hasSpringLibrary((Project)psiElement.getProject())) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringModelRelatedFileProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<GotoRelatedItem> items = new ArrayList<GotoRelatedItem>();
        for (SpringModel model : SpringManager.getInstance((Project)psiElement.getProject()).getSpringModelsByFile(containingFile)) {
            SpringFileSet set = model.getFileSet();
            String groupName = set != null ? "Spring Context: \"" + set.getName() + "\"" : "Spring Application Contexts";
            SpringModelRelatedFileProvider.addItems(items, containingFile, (CommonSpringModel)model, groupName);
        }
        PsiClass type = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
        if (SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)type) && SpringTestContextUtil.getInstance().isTestContextConfigurationClass(type)) {
            SpringModelRelatedFileProvider.addItems(items, containingFile, SpringTestContextUtil.getInstance().getSpringTestingModel(type), "Spring Test Contexts");
        }
        if (!items.isEmpty()) {
            UsageTrigger.trigger((String)"spring.ModelRelatedProvider");
        }
        ArrayList<GotoRelatedItem> arrayList = items;
        if (arrayList == null) {
            SpringModelRelatedFileProvider.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static void addItems(@NotNull List<GotoRelatedItem> items, @NotNull PsiFile containingFile, @NotNull CommonSpringModel model, @NotNull String groupName) {
        if (items == null) {
            SpringModelRelatedFileProvider.$$$reportNull$$$0(5);
        }
        if (containingFile == null) {
            SpringModelRelatedFileProvider.$$$reportNull$$$0(6);
        }
        if (model == null) {
            SpringModelRelatedFileProvider.$$$reportNull$$$0(7);
        }
        if (groupName == null) {
            SpringModelRelatedFileProvider.$$$reportNull$$$0(8);
        }
        for (PsiFile file : model.getConfigFiles()) {
            if (file.equals(containingFile)) continue;
            items.add(new GotoRelatedItem((PsiElement)file, groupName));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/navigation/SpringModelRelatedFileProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/navigation/SpringModelRelatedFileProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

