/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Template;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.play.completion.beans.NameValueDescriptor;
import com.intellij.play.completion.beans.PlayTagDescriptor;
import com.intellij.play.language.psi.PlayTag;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import icons.PlayIcons;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayCompletionUtils {
    private static Set<PlayTagDescriptor> plays = new HashSet();

    public static Set<PlayTagDescriptor> getPredefinedTagDescriptors() {
        return plays;
    }

    public static Set<PlayTagDescriptor> getTagDescriptors(@Nullable Module module) {
        HashSet descriptors = new HashSet();
        descriptors.addAll(PlayCompletionUtils.getPredefinedTagDescriptors());
        if (module != null) {
            descriptors.addAll(PlayCompletionUtils.getCustomTagDescriptors(module));
            descriptors.addAll(PlayCompletionUtils.getFastTagDescriptors(module));
        }
        return descriptors;
    }

    public static Set<PlayTagDescriptor> getCustomTagDescriptors(@NotNull Module module) {
        if (module == null) {
            PlayCompletionUtils.$$$reportNull$$$0(0);
        }
        return ContainerUtil.map2Set(PlayPathUtils.getCustomTags(module).keySet(), fqn -> PlayTagDescriptor.create(fqn, true, new NameValueDescriptor[0]));
    }

    public static Set<PlayTagDescriptor> getFastTagDescriptors(@NotNull Module module) {
        if (module == null) {
            PlayCompletionUtils.$$$reportNull$$$0(1);
        }
        return ContainerUtil.map2Set(PlayPathUtils.getFastTags(module), fastTagDescriptor -> PlayTagDescriptor.create(fastTagDescriptor.getFqn(), true, new NameValueDescriptor[0]));
    }

    @Nullable
    public static PlayTagDescriptor findTagDescriptor(@Nullable PlayTag tag) {
        if (tag == null) {
            return null;
        }
        for (PlayTagDescriptor tagDescriptor : PlayCompletionUtils.getTagDescriptors(ModuleUtil.findModuleForPsiElement((PsiElement)tag))) {
            if (!tagDescriptor.getTagName().equals(tag.getName())) continue;
            return tagDescriptor;
        }
        return null;
    }

    public static LookupElementBuilder createLookupElement(@NotNull PlayTagDescriptor descriptor) {
        if (descriptor == null) {
            PlayCompletionUtils.$$$reportNull$$$0(2);
        }
        return PlayCompletionUtils.createLookupElement(descriptor, "");
    }

    public static LookupElementBuilder createTagNameLookupElement(@NotNull PlayTagDescriptor descriptor) {
        if (descriptor == null) {
            PlayCompletionUtils.$$$reportNull$$$0(3);
        }
        return LookupElementBuilder.create((String)descriptor.getTagName()).withPresentableText(descriptor.getTagName()).bold().withIcon(PlayIcons.PlayTag).withTypeText(descriptor.getPresentableText(), true);
    }

    public static LookupElementBuilder createLookupElement(@NotNull PlayTagDescriptor descriptor, @NotNull String prefix) {
        if (descriptor == null) {
            PlayCompletionUtils.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            PlayCompletionUtils.$$$reportNull$$$0(5);
        }
        return LookupElementBuilder.create((String)(prefix + descriptor.getTagName() + descriptor.getTailText())).withLookupString(descriptor.getTagName()).withPresentableText(descriptor.getTagName()).bold().withIcon(PlayIcons.PlayTag).withTypeText(descriptor.getPresentableText(), true).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                PsiElement nameElement;
                PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getEditor().getDocument());
                PsiElement current = context.getFile().findElementAt(context.getStartOffset());
                PlayTag tag = (PlayTag)PsiTreeUtil.getContextOfType((PsiElement)current, PlayTag.class, (boolean)true);
                if (tag == null) {
                    return;
                }
                PlayTagDescriptor tagDescriptor = PlayCompletionUtils.findTagDescriptor(tag);
                if (tagDescriptor != null && tagDescriptor.getDescriptors().length > 0 && (nameElement = tag.getNameElement()) != null) {
                    NameValueDescriptor valueDescriptor;
                    CaretModel caretModel = context.getEditor().getCaretModel();
                    caretModel.moveToOffset(nameElement.getTextOffset() + nameElement.getTextLength() + 1);
                    NameValueDescriptor[] nameValueDescriptors = tagDescriptor.getDescriptors();
                    if (nameValueDescriptors.length == 1 && (valueDescriptor = nameValueDescriptors[0]).getName() == null) {
                        if (valueDescriptor.isStringExpression()) {
                            context.getDocument().insertString(caretModel.getOffset(), (CharSequence)"''");
                        } else if (valueDescriptor.isActionPreferred()) {
                            context.getDocument().insertString(caretModel.getOffset(), (CharSequence)"@");
                        } else {
                            return;
                        }
                        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getEditor().getDocument());
                        caretModel.moveToOffset(caretModel.getOffset() + 1);
                    }
                    AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
                }
            }
        });
    }

    @Nullable
    private static Template getTemplate(@NotNull PlayTagDescriptor descriptor) {
        if (descriptor == null) {
            PlayCompletionUtils.$$$reportNull$$$0(6);
        }
        NameValueDescriptor[] descriptors = descriptor.getDescriptors();
        return null;
    }

    static {
        plays.add(PlayTagDescriptor.create("a", NameValueDescriptor.createAction()));
        plays.add(PlayTagDescriptor.create("authenticityToken", true, new NameValueDescriptor[0]));
        plays.add(PlayTagDescriptor.create("cache", NameValueDescriptor.createStringExpression()));
        plays.add(PlayTagDescriptor.create("doBody", true, new NameValueDescriptor[0]));
        plays.add(PlayTagDescriptor.create("doLayout", true, new NameValueDescriptor[0]));
        plays.add(PlayTagDescriptor.create("if", NameValueDescriptor.createExpression()));
        plays.add(PlayTagDescriptor.create("ifError", NameValueDescriptor.createStringExpression()));
        plays.add(PlayTagDescriptor.create("ifErrors", new NameValueDescriptor[0]));
        plays.add(PlayTagDescriptor.create("else", NameValueDescriptor.createExpression()));
        plays.add(PlayTagDescriptor.create("elseif", NameValueDescriptor.createExpression()));
        plays.add(PlayTagDescriptor.create("error", true, NameValueDescriptor.createStringExpression(), NameValueDescriptor.createStringExpression("field")));
        plays.add(PlayTagDescriptor.create("errorClass", true, NameValueDescriptor.createStringExpression()));
        plays.add(PlayTagDescriptor.create("errors", new NameValueDescriptor[0]));
        plays.add(PlayTagDescriptor.create("extends", true, NameValueDescriptor.createStringExpression()));
        plays.add(PlayTagDescriptor.create("field", NameValueDescriptor.createStringExpression()));
        plays.add(PlayTagDescriptor.create("form", NameValueDescriptor.createAction(), NameValueDescriptor.createStringExpression("method").setRequired(false), NameValueDescriptor.createStringExpression("enctype ").setRequired(false), NameValueDescriptor.createStringExpression("id").setRequired(false)));
        plays.add(PlayTagDescriptor.create("get", true, NameValueDescriptor.createStringExpression()));
        plays.add(PlayTagDescriptor.create("i18n", true, new NameValueDescriptor[0]));
        plays.add(PlayTagDescriptor.create("ifnot", NameValueDescriptor.createExpression()));
        plays.add(PlayTagDescriptor.create("include", true, NameValueDescriptor.createStringExpression()));
        plays.add(PlayTagDescriptor.create("jsAction", true, NameValueDescriptor.createAction()));
        plays.add(PlayTagDescriptor.create("list", NameValueDescriptor.createExpression(), NameValueDescriptor.create("items").setRequired(false), NameValueDescriptor.createStringExpression("as").setRequired(false)));
        plays.add(PlayTagDescriptor.create("option", NameValueDescriptor.createExpression()));
        plays.add(PlayTagDescriptor.create("script", true, NameValueDescriptor.createStringExpression(), NameValueDescriptor.createStringExpression("src"), NameValueDescriptor.createStringExpression("id").setRequired(false), NameValueDescriptor.createStringExpression("charset").setRequired(false)));
        plays.add(PlayTagDescriptor.create("render", true, NameValueDescriptor.createStringExpression()));
        plays.add(PlayTagDescriptor.create("select", NameValueDescriptor.createStringExpression(), NameValueDescriptor.createStringExpression("name").setRequired(false), NameValueDescriptor.create("items ").setRequired(false), NameValueDescriptor.create("value").setRequired(false), NameValueDescriptor.create("labelProperty").setRequired(false), NameValueDescriptor.create("valueProperty").setRequired(false)));
        plays.add(PlayTagDescriptor.create("set", true, new NameValueDescriptor[0]));
        plays.add(PlayTagDescriptor.create("stylesheet", true, NameValueDescriptor.createStringExpression(), NameValueDescriptor.createStringExpression("src").setRequired(false), NameValueDescriptor.createStringExpression("id").setRequired(false), NameValueDescriptor.createStringExpression("media").setRequired(false), NameValueDescriptor.createStringExpression("title").setRequired(false)));
        plays.add(PlayTagDescriptor.create("verbatim", new NameValueDescriptor[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/play/completion/PlayCompletionUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomTagDescriptors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFastTagDescriptors";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createLookupElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createTagNameLookupElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

