/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.console;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.play.console.PlayConsoleRunner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayConsoleCompletionContributor
extends CompletionContributor {
    private static final Map<String, String> myCommands = new HashMap<String, String>();
    private static final Map<String, CompleteParametersFunction> myParameters = new HashMap<String, CompleteParametersFunction>();

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Object data;
        PsiFile originalFile;
        Document document;
        if (parameters == null) {
            PlayConsoleCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            PlayConsoleCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters.getInvocationCount() != 0 && (document = PsiDocumentManager.getInstance((Project)(originalFile = parameters.getOriginalFile()).getProject()).getDocument(originalFile)) != null && (data = document.getUserData(PlayConsoleRunner.PLAY_CONSOLE_KEY)) != null) {
            String text = parameters.getOriginalFile().getText();
            List strings = StringUtil.split((String)text, (String)" ");
            if (strings.size() > 0) {
                String commandName = (String)strings.get(0);
                CompleteParametersFunction function = myParameters.get(commandName.trim());
                if (function != null) {
                    function.complete(result, parameters, text.substring(commandName.length()));
                }
            } else {
                PlayConsoleCompletionContributor.completeCommands(result);
            }
        }
    }

    public static boolean completeModuleNames(CompletionResultSet result, CompletionParameters parameters, String parametersString) {
        List params = StringUtil.split((String)parametersString, (String)" ");
        String prefix = result.getPrefixMatcher().getPrefix();
        if (params.size() == 0 || prefix.trim().length() > 0) {
            Project project = parameters.getPosition().getProject();
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)module.getName().toLowerCase()).withCaseSensitivity(false).withIcon(ModuleType.get((Module)module).getIcon()).withTailText(PlayConsoleCompletionContributor.getWorkingDir(module), true));
            }
        }
        return true;
    }

    private static void completeCommands(CompletionResultSet result) {
        for (Map.Entry<String, String> entry : myCommands.entrySet()) {
            result.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)entry.getKey()).withCaseSensitivity(false).withTailText(" (" + entry.getValue() + ")", true).bold(), (TailType)TailType.SPACE));
        }
        result.stopHere();
    }

    @Nullable
    private static String getWorkingDir(Module module) {
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (contentRoots.length == 0) {
            return "";
        }
        return contentRoots[0].getPath();
    }

    static {
        myCommands.put("antify", "Create a build.xml file for this project");
        myCommands.put("auto-test", "Automatically run all application tests");
        myCommands.put("build-module", "Build and package a module");
        myCommands.put("check", "Check for a release newer than the current one");
        myCommands.put("classpath", "Display the computed classpath");
        myCommands.put("clean", "Delete temporary files (including the bytecode cache)");
        myCommands.put("dependencies", "Resolve and retrieve project dependencies");
        myCommands.put("eclipsify", "Create all Eclipse configuration files");
        myCommands.put("evolutions", "Run the evolution check");
        myCommands.put("evolutions:apply", "Automatically apply pending evolutions");
        myCommands.put("evolutions:markA", "ppliedMark pending evolutions as manually applied");
        myCommands.put("evolutions:resolve", " Resolve partially applied evolution");
        myCommands.put("help", "Display help on a specific command");
        myCommands.put("id", "Define the framework ID");
        myCommands.put("idealize", "Create all IntelliJ Idea configuration files");
        myCommands.put("install", "Install a module");
        myCommands.put("javadoc", "Generate your application Javadoc");
        myCommands.put("list-modules", "List modules available from the central modules repository");
        myCommands.put("modules", "Display the computed modules list");
        myCommands.put("netbeansify", "Create all NetBeans configuration files");
        myCommands.put("new", "Create a new application");
        myCommands.put("new-module", "Create a module");
        myCommands.put("out", "Follow logs/system.out file");
        myCommands.put("pid", "Show the PID of the running application");
        myCommands.put("precompile", "Precompile all Java sources and templates to speed up application start-up");
        myCommands.put("restart", "Restart the running application");
        myCommands.put("run", "Run the application in the current shell");
        myCommands.put("secret", "   Generate a new secret key");
        myCommands.put("start", "Start the application in the background");
        myCommands.put("status", "Display the running application's status");
        myCommands.put("stop", "Stop the running application");
        myCommands.put("test", "Run the application in test mode in the current shell");
        myCommands.put("version", "Print the framework version");
        myCommands.put("war", "Export the application as a standalone WAR archive");
        myParameters.put("run", new ModulesAsParametersFunction());
        myParameters.put("start", new ModulesAsParametersFunction());
        myParameters.put("stop", new ModulesAsParametersFunction());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/play/console/PlayConsoleCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class CompleteParametersFunction {
        abstract boolean complete(CompletionResultSet var1, CompletionParameters var2, String var3);
    }

    private static class ModulesAsParametersFunction
    extends CompleteParametersFunction {
        private ModulesAsParametersFunction() {
        }

        @Override
        boolean complete(CompletionResultSet result, CompletionParameters parameters, String parametersString) {
            return PlayConsoleCompletionContributor.completeModuleNames(result, parameters, parametersString);
        }
    }
}

