/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.console;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.play.console.BasicProcessConsoleRunnerWithHistory;
import com.intellij.play.utils.PlayBundle;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PlayConsoleRunner
extends BasicProcessConsoleRunnerWithHistory<LanguageConsoleView> {
    public static final Key<Object> PLAY_CONSOLE_KEY = Key.create((String)PlayConsoleRunner.class.getSimpleName());
    private final String myPlayHome;
    private final String myWorkingDir;

    public PlayConsoleRunner(@NotNull Project project, @NotNull String playHome, @NotNull String workingDir) {
        if (project == null) {
            PlayConsoleRunner.$$$reportNull$$$0(0);
        }
        if (playHome == null) {
            PlayConsoleRunner.$$$reportNull$$$0(1);
        }
        if (workingDir == null) {
            PlayConsoleRunner.$$$reportNull$$$0(2);
        }
        super(PlayConsoleRunner.createConsoleView(project));
        this.myPlayHome = playHome;
        this.myWorkingDir = workingDir;
    }

    @NotNull
    private static LanguageConsoleView createConsoleView(Project project) {
        LanguageConsoleImpl consoleView = new LanguageConsoleImpl(project, PlayBundle.message("playframework", new Object[0]), (Language)PlainTextLanguage.INSTANCE);
        consoleView.getConsoleEditor().getDocument().putUserData(PLAY_CONSOLE_KEY, (Object)Boolean.TRUE);
        consoleView.setPrompt("play ");
        LanguageConsoleImpl languageConsoleImpl = consoleView;
        if (languageConsoleImpl == null) {
            PlayConsoleRunner.$$$reportNull$$$0(3);
        }
        return languageConsoleImpl;
    }

    @Override
    protected GeneralCommandLine createCommandLine(@NotNull String command) {
        if (command == null) {
            PlayConsoleRunner.$$$reportNull$$$0(4);
        }
        return new GeneralCommandLine(new String[]{PlayConsoleRunner.getExePath(this.myPlayHome)}).withParameters(PlayConsoleRunner.getParameters(command)).withEnvironment("PLAY_OPTS", this.getOptions()).withWorkDirectory(this.myWorkingDir);
    }

    private static List<String> getParameters(@NotNull String command) {
        if (command == null) {
            PlayConsoleRunner.$$$reportNull$$$0(5);
        }
        LinkedList<String> params = new LinkedList<String>();
        for (String s : StringUtil.split((String)command, (String)" ")) {
            if ("play".equals(s.trim())) continue;
            params.add(s.trim());
        }
        return params;
    }

    static String getExePath(String playHome) {
        if (!playHome.endsWith(File.separator)) {
            playHome = playHome + File.separator;
        }
        return playHome + (SystemInfo.isWindows ? "play.bat" : "play");
    }

    protected String getOptions() {
        return "-Djline.WindowsTerminal.directConsole=false";
    }

    @Override
    protected String getToolWindowId() {
        return ToolWindowId.RUN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "playHome";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/play/console/PlayConsoleRunner";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/play/console/PlayConsoleRunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

