/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.language;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.play.language.PlayActionCompositeElement;
import com.intellij.play.language.PlayActionElementType;
import com.intellij.play.language.PlayCompositeElementType;
import com.intellij.play.language.PlayCompositeGroovyExpressionElement;
import com.intellij.play.language.PlayElementTypes;
import com.intellij.play.language.PlayParser;
import com.intellij.play.language.TagExpressionCompositeElement;
import com.intellij.play.language.TagExpressionElementType;
import com.intellij.play.language.groovy.GroovyExpressionLazyParseableElementType;
import com.intellij.play.language.lexer.PlayLexer;
import com.intellij.play.language.psi.PlayPsiFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class PlayParserDefinition
implements ParserDefinition {
    private static final TokenSet WHITE_SPACE = TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.WHITE_SPACE});
    private static final TokenSet COMMENT = TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.COMMENT_START, PlayElementTypes.COMMENT_END, PlayElementTypes.COMMENT_TEXT});

    @NotNull
    public Lexer createLexer(Project project) {
        PlayLexer playLexer = PlayLexer.createLexer();
        if (playLexer == null) {
            PlayParserDefinition.$$$reportNull$$$0(0);
        }
        return playLexer;
    }

    public PsiParser createParser(Project project) {
        return new PlayParser();
    }

    public IFileElementType getFileNodeType() {
        return PlayElementTypes.PLAY_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITE_SPACE;
        if (tokenSet == null) {
            PlayParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = COMMENT;
        if (tokenSet == null) {
            PlayParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = PlayElementTypes.STRING_LITERALS;
        if (tokenSet == null) {
            PlayParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof PlayCompositeElementType) {
            PsiElement psiElement = ((PlayCompositeElementType)type).createPsiElement(node);
            if (psiElement == null) {
                PlayParserDefinition.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        if (type instanceof PlayActionElementType) {
            PlayActionCompositeElement playActionCompositeElement = new PlayActionCompositeElement(node);
            if (playActionCompositeElement == null) {
                PlayParserDefinition.$$$reportNull$$$0(5);
            }
            return playActionCompositeElement;
        }
        if (type instanceof TagExpressionElementType) {
            TagExpressionCompositeElement tagExpressionCompositeElement = new TagExpressionCompositeElement(node);
            if (tagExpressionCompositeElement == null) {
                PlayParserDefinition.$$$reportNull$$$0(6);
            }
            return tagExpressionCompositeElement;
        }
        if (type instanceof GroovyExpressionLazyParseableElementType) {
            PlayCompositeGroovyExpressionElement playCompositeGroovyExpressionElement = new PlayCompositeGroovyExpressionElement(node);
            if (playCompositeGroovyExpressionElement == null) {
                PlayParserDefinition.$$$reportNull$$$0(7);
            }
            return playCompositeGroovyExpressionElement;
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PlayPsiFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    public String toString() {
        return PlayParserDefinition.class.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/play/language/PlayParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

