/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.references;

import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.play.completion.beans.PlayFastTagDescriptor;
import com.intellij.play.language.psi.PlayPsiFile;
import com.intellij.play.language.psi.PlayTag;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.IncorrectOperationException;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayCustomTagNamePsiReference
extends PsiReferenceBase<PsiElement>
implements LocalQuickFixProvider {
    private final PlayTag myPlayTag;
    private String myTagName;
    @NotNull
    private String myFqn;
    private static final String CUSTOM_TAGS_DIR = "tags";

    public PlayCustomTagNamePsiReference(@NotNull PlayTag playTag, @NotNull String tagName, @NotNull String fqn) {
        if (playTag == null) {
            PlayCustomTagNamePsiReference.$$$reportNull$$$0(0);
        }
        if (tagName == null) {
            PlayCustomTagNamePsiReference.$$$reportNull$$$0(1);
        }
        if (fqn == null) {
            PlayCustomTagNamePsiReference.$$$reportNull$$$0(2);
        }
        super((PsiElement)playTag, TextRange.from((int)playTag.getText().indexOf(tagName), (int)tagName.length()));
        this.myPlayTag = playTag;
        this.myTagName = tagName;
        this.myFqn = fqn;
    }

    public PsiElement resolve() {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.myPlayTag);
        if (module != null) {
            Map<String, PsiFile> tags = PlayPathUtils.getCustomTags(module);
            for (Map.Entry<String, PsiFile> tag : tags.entrySet()) {
                PsiFile tagFile = tag.getValue();
                if (!(tagFile instanceof PlayPsiFile) || !this.myFqn.equals(tag.getKey())) continue;
                return tagFile;
            }
            for (PlayFastTagDescriptor descriptor : PlayPathUtils.getFastTags(module)) {
                if (!this.myFqn.equals(descriptor.getFqn())) continue;
                return descriptor.getMethod();
            }
        }
        return null;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String tagName = PlayCustomTagNamePsiReference.getNewTagName(newElementName);
        String fqnName = this.myFqn.contains(".") ? StringUtil.getPackageName((String)this.myFqn) + "." + tagName : tagName;
        ((PlayTag)this.getElement()).setName(fqnName);
        return this.getElement();
    }

    private static String getNewTagName(String newElementName) {
        if (newElementName.contains(".")) {
            return FileUtil.getNameWithoutExtension((String)newElementName);
        }
        if (newElementName.startsWith("_")) {
            return newElementName.substring(1);
        }
        return newElementName;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        Module module;
        if (element == null) {
            PlayCustomTagNamePsiReference.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)this.myPlayTag)) != null) {
            Object tags;
            if (element instanceof PlayPsiFile) {
                tags = PlayPathUtils.getCustomTags(module);
                for (Map.Entry<String, Object> entry : tags.entrySet()) {
                    if (!element.equals(entry.getValue())) continue;
                    ((PlayTag)this.getElement()).setName(entry.getKey());
                    return element;
                }
            }
            if (element instanceof PsiMethod) {
                tags = PlayPathUtils.getFastTags(module);
                Iterator<Map.Entry<String, Object>> iterator = tags.iterator();
                while (iterator.hasNext()) {
                    PlayFastTagDescriptor playFastTagDescriptor = (PlayFastTagDescriptor)((Object)iterator.next());
                    if (!element.equals(playFastTagDescriptor.getMethod())) continue;
                    ((PlayTag)this.getElement()).setName(playFastTagDescriptor.getFqn());
                    return element;
                }
            }
        }
        return super.bindToElement(element);
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            PlayCustomTagNamePsiReference.$$$reportNull$$$0(4);
        }
        return EMPTY_ARRAY;
    }

    public LocalQuickFix[] getQuickFixes() {
        LocalQuickFix[] localQuickFixArray;
        LocalQuickFix fix = this.createNewCustomTagFix();
        if (fix == null) {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        } else {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = fix;
        }
        return localQuickFixArray;
    }

    @Nullable
    private LocalQuickFix createNewCustomTagFix() {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.myPlayTag);
        if (module == null) {
            return null;
        }
        PsiDirectory viewsDirectory = PlayPathUtils.getViewsDirectory(module);
        if (viewsDirectory == null) {
            return null;
        }
        String newFileName = "tags/" + this.myFqn.replace(".", "/") + ".html";
        return new CreateFileFix(newFileName, viewsDirectory, "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "playTag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/play/references/PlayCustomTagNamePsiReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/play/references/PlayCustomTagNamePsiReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

