/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.references;

import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.play.completion.PlayCompletionUtils;
import com.intellij.play.completion.beans.PlayFastTagDescriptor;
import com.intellij.play.completion.beans.PlayTagDescriptor;
import com.intellij.play.language.psi.PlayTag;
import com.intellij.play.references.PlayCustomTagNamePsiReference;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PlayCustomTagPsiReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            PlayCustomTagPsiReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PlayCustomTagPsiReferenceProvider.$$$reportNull$$$0(1);
        }
        HashSet set = new HashSet();
        PlayTag playTag = (PlayTag)element;
        String name = playTag.getName();
        if (!StringUtil.isEmptyOrSpaces((String)name) && PlayCustomTagPsiReferenceProvider.isCustomTag(playTag)) {
            if (name.contains(".")) {
                String namespaceName = StringUtil.getPackageName((String)name);
                String tagName = StringUtil.getShortName((String)name);
                set.addAll(PlayCustomTagPsiReferenceProvider.getNamespaceReferences((PlayTag)element, namespaceName));
                set.add(new PlayCustomTagNamePsiReference((PlayTag)element, tagName, name));
            } else {
                set.add(new PlayCustomTagNamePsiReference((PlayTag)element, name, name));
            }
        }
        PsiReference[] psiReferenceArray = set.toArray(new PsiReference[set.size()]);
        if (psiReferenceArray == null) {
            PlayCustomTagPsiReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private static Collection<? extends PsiReference> getNamespaceReferences(@NotNull PlayTag element, @NotNull String namespaceName) {
        Module module;
        if (element == null) {
            PlayCustomTagPsiReferenceProvider.$$$reportNull$$$0(3);
        }
        if (namespaceName == null) {
            PlayCustomTagPsiReferenceProvider.$$$reportNull$$$0(4);
        }
        if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)element)) == null) {
            return Collections.emptySet();
        }
        HashSet references = new HashSet();
        HashSet descriptors = new HashSet();
        int offset = element.getText().indexOf(namespaceName);
        for (final PlayFastTagDescriptor fastTagDescriptor : PlayPathUtils.getFastTags(module)) {
            if (!namespaceName.equals(fastTagDescriptor.getNamespaceValue())) continue;
            descriptors.add(new PsiReferenceBase<PlayTag>(element, TextRange.create((int)offset, (int)(offset + namespaceName.length()))){

                public PsiElement resolve() {
                    JamStringAttributeElement<String> namespace = fastTagDescriptor.getNamespace();
                    return namespace == null ? null : namespace.getPsiElement();
                }

                @NotNull
                public Object[] getVariants() {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayCustomTagPsiReferenceProvider$1", "getVariants"));
                }
            });
        }
        if (descriptors.size() > 0) {
            references.add(new PsiMultiReference(descriptors.toArray(new PsiReference[descriptors.size()]), (PsiElement)element));
        }
        PackageReferenceSet set = new PackageReferenceSet(namespaceName, (PsiElement)element, offset){

            public Set<PsiPackage> getInitialContext() {
                HashSet packages = new HashSet();
                Set<PsiDirectory> roots = PlayPathUtils.getCustomTagRoots(module);
                for (PsiDirectory root : roots) {
                    PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(root);
                    if (psiPackage == null) continue;
                    packages.add(psiPackage);
                }
                return packages;
            }
        };
        references.addAll(set.getReferences());
        return references;
    }

    private static boolean isCustomTag(PlayTag tag) {
        String tagName = tag.getName();
        if (!StringUtil.isEmptyOrSpaces((String)tagName)) {
            for (PlayTagDescriptor descriptor : PlayCompletionUtils.getPredefinedTagDescriptors()) {
                if (!tagName.equals(descriptor.getTagName())) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/play/references/PlayCustomTagPsiReferenceProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/play/references/PlayCustomTagPsiReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

