/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.play.references.PlayControllerActionPsiReferenceProvider;
import com.intellij.play.utils.routes.RouterLineDescriptor;
import com.intellij.play.utils.routes.RouterUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.HashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayRoutesPsiReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiFile containingFile;
        Module module;
        if (element == null) {
            PlayRoutesPsiReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PlayRoutesPsiReferenceProvider.$$$reportNull$$$0(1);
        }
        PsiElement originalElement = element.getOriginalElement();
        HashSet references = new HashSet();
        if (originalElement instanceof PsiFile && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement)) != null && (containingFile = element.getContainingFile()) != null) {
            PsiFile file = containingFile.getOriginalFile();
            Set descriptors = (Set)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.createSingleDependency(RouterUtils.getLineDescriptors(file.getText()), (Object)file));
            for (RouterLineDescriptor descriptor : descriptors) {
                references.addAll(PlayRoutesPsiReferenceProvider.getPathReferences(descriptor.getPath()));
                references.addAll(PlayRoutesPsiReferenceProvider.getActionReferences((PsiFile)originalElement, descriptor.getAction(), module));
            }
        }
        PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
        if (psiReferenceArray == null) {
            PlayRoutesPsiReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    @NotNull
    private static Set<PsiReference> getActionReferences(@NotNull PsiFile psiFile, @Nullable Pair<String, Integer> pair, @NotNull Module module) {
        if (psiFile == null) {
            PlayRoutesPsiReferenceProvider.$$$reportNull$$$0(3);
        }
        if (module == null) {
            PlayRoutesPsiReferenceProvider.$$$reportNull$$$0(4);
        }
        if (pair == null) {
            Set<PsiReference> set = Collections.emptySet();
            if (set == null) {
                PlayRoutesPsiReferenceProvider.$$$reportNull$$$0(5);
            }
            return set;
        }
        Set<PsiReference> set = PlayControllerActionPsiReferenceProvider.getActionNameReferences(psiFile.getChildren()[0], module, (String)pair.getFirst(), (Integer)pair.getSecond());
        if (set == null) {
            PlayRoutesPsiReferenceProvider.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    private static Set<PsiReference> getPathReferences(@Nullable Pair<String, Integer> path) {
        if (path == null) {
            Set<PsiReference> set = Collections.emptySet();
            if (set == null) {
                PlayRoutesPsiReferenceProvider.$$$reportNull$$$0(7);
            }
            return set;
        }
        Set<PsiReference> set = Collections.emptySet();
        if (set == null) {
            PlayRoutesPsiReferenceProvider.$$$reportNull$$$0(8);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/play/references/PlayRoutesPsiReferenceProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/play/references/PlayRoutesPsiReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionReferences";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActionReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

