/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.utils.processors;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.play.language.psi.PlayNameValueCompositeElement;
import com.intellij.play.language.psi.PlayTag;
import com.intellij.play.references.PlayFakeRenameableReferenceProvider;
import com.intellij.play.utils.PlayUtils;
import com.intellij.play.utils.beans.PlayImplicitVariable;
import com.intellij.play.utils.beans.PlayRenameableImplicitVariable;
import com.intellij.play.utils.processors.PlayDeclarationsProcessor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class ListTagImplicitVariablesProcessor
implements PlayDeclarationsProcessor {
    @Override
    public boolean processElement(PsiScopeProcessor processor, ResolveState state, PsiElement scope) {
        Set<PlayImplicitVariable> listVariables = ListTagImplicitVariablesProcessor.getParentListVariables(scope);
        if (listVariables != null) {
            for (PlayImplicitVariable playImplicitVariable : listVariables) {
                if (ResolveUtil.processElement((PsiScopeProcessor)processor, (PsiNamedElement)playImplicitVariable, (ResolveState)state)) continue;
                return false;
            }
        }
        return true;
    }

    private static Set<PlayTag> getParentListTags(PsiElement expressionElement) {
        HashSet listTags = new HashSet();
        for (PsiElement parent = expressionElement.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PlayTag) || !"list".equals(((PlayTag)parent).getName())) continue;
            listTags.add((PlayTag)parent);
        }
        return listTags;
    }

    @Nullable
    public static Set<PlayImplicitVariable> getParentListVariables(PsiElement expressionElement) {
        return (Set)RecursionManager.createGuard((String)"PlayListTagIterable").doPreventingRecursion((Object)expressionElement, true, () -> {
            HashSet vars = new HashSet();
            Set<PlayTag> listTags = ListTagImplicitVariablesProcessor.getParentListTags(expressionElement);
            for (PlayTag listTag : listTags) {
                vars.addAll(ListTagImplicitVariablesProcessor.getListTagIterableVariables((PsiElement)listTag));
            }
            return vars;
        });
    }

    @NotNull
    public static Set<PlayImplicitVariable> getListTagIterableVariables(@Nullable PsiElement psiElement) {
        PlayTag listTag;
        com.intellij.util.containers.hash.HashSet variables = new com.intellij.util.containers.hash.HashSet();
        if (psiElement instanceof PlayTag && "list".equals((listTag = (PlayTag)psiElement).getName())) {
            PsiClass psiClass;
            Project project = listTag.getProject();
            GrExpression grExpression = ListTagImplicitVariablesProcessor.getGrExpression(listTag, "items");
            if (grExpression != null && (psiClass = ListTagImplicitVariablesProcessor.getListTagCollectionType(grExpression)) != null) {
                String name;
                GrExpression nameExpression = ListTagImplicitVariablesProcessor.getGrExpression(listTag, "as");
                if (nameExpression == null) {
                    variables.add(new PlayImplicitVariable("_", (PsiType)JavaPsiFacade.getElementFactory((Project)project).createType(psiClass), (PsiElement)grExpression));
                } else if (nameExpression instanceof GrLiteral && !StringUtil.isEmptyOrSpaces((String)(name = ListTagImplicitVariablesProcessor.getStringValue(nameExpression)))) {
                    RenameableFakePsiElement element = PlayFakeRenameableReferenceProvider.getOrCreateRenamebaleFakeElement((PsiLiteral)((GrLiteral)nameExpression));
                    variables.add(new PlayRenameableImplicitVariable(name, (PsiType)JavaPsiFacade.getElementFactory((Project)project).createType(psiClass), element));
                    variables.add(new PlayRenameableImplicitVariable(name + "_index", (PsiType)JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.lang.Integer"), element));
                    variables.add(new PlayRenameableImplicitVariable(name + "_isLast", (PsiType)JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.lang.Boolean"), element));
                    variables.add(new PlayRenameableImplicitVariable(name + "_isFirst", (PsiType)JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.lang.Boolean"), element));
                    variables.add(new PlayRenameableImplicitVariable(name + "_parity", (PsiType)JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.lang.Object"), element));
                }
            }
        }
        com.intellij.util.containers.hash.HashSet hashSet = variables;
        if (hashSet == null) {
            ListTagImplicitVariablesProcessor.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @Nullable
    private static String getStringValue(GrExpression nameExpression) {
        Object value;
        if (nameExpression instanceof GrLiteral && (value = ((GrLiteral)nameExpression).getValue()) instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Nullable
    private static PsiClass getListTagCollectionType(@NotNull GrExpression grExpression) {
        PsiType psiType;
        PsiType type;
        if (grExpression == null) {
            ListTagImplicitVariablesProcessor.$$$reportNull$$$0(1);
        }
        if (InheritanceUtil.isInheritor((PsiType)(type = grExpression.getType()), (String)"java.util.Collection") && (psiType = PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)true)) instanceof PsiClassType) {
            return ((PsiClassType)psiType).resolve();
        }
        return PlayUtils.getObjectClass(grExpression.getProject());
    }

    @Nullable
    private static GrExpression getGrExpression(@NotNull PlayTag tag, String name) {
        PlayNameValueCompositeElement nameValue;
        if (tag == null) {
            ListTagImplicitVariablesProcessor.$$$reportNull$$$0(2);
        }
        if ((nameValue = tag.findNameValue(name)) == null) {
            return null;
        }
        PsiElement valueElement = nameValue.getValueElement();
        return valueElement == null ? null : (GrExpression)PsiTreeUtil.getChildOfType((PsiElement)valueElement, GrExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/play/utils/processors/ListTagImplicitVariablesProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getListTagIterableVariables";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/play/utils/processors/ListTagImplicitVariablesProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getListTagCollectionType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getGrExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

