/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.server;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javaee.oss.geronimo.GeronimoBundle;
import com.intellij.javaee.oss.geronimo.GeronimoUtil;
import com.intellij.javaee.oss.geronimo.model.GeronimoAppRoot;
import com.intellij.javaee.oss.geronimo.model.GeronimoCommonRoot;
import com.intellij.javaee.oss.geronimo.model.GeronimoEjbRoot;
import com.intellij.javaee.oss.geronimo.model.GeronimoWebRoot;
import com.intellij.javaee.oss.server.JavaeeInspection;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.NotNull;

public class GeronimoInspection
extends JavaeeInspection {
    public GeronimoInspection() {
        super(GeronimoAppRoot.class, new Class[]{GeronimoEjbRoot.class, GeronimoWebRoot.class});
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        super.checkDomElement(element, holder, helper);
        if (element instanceof GeronimoCommonRoot) {
            this.checkCommonRoot((GeronimoCommonRoot)element, holder);
            if (element instanceof GeronimoWebRoot) {
                this.checkContextRoot((GeronimoWebRoot)element, holder);
            }
        }
    }

    private void checkCommonRoot(GeronimoCommonRoot root, DomElementAnnotationHolder holder) {
        GenericDomValue<String> value;
        if (GeronimoUtil.isGeronimo10(root)) {
            GenericAttributeValue<String> value2 = root.getConfigId();
            if (StringUtil.isEmpty((String)((String)value2.getValue()))) {
                holder.createProblem(root.getConfigId(), GeronimoBundle.getText("Error.config.id.empty", new Object[0]), new LocalQuickFix[0]);
            }
        } else if (root instanceof GeronimoAppRoot && StringUtil.isEmpty((String)((String)(value = root.getEnvironment().getModuleId().getArtifactId()).getValue()))) {
            holder.createProblem(value, GeronimoBundle.getText("Error.artifact.id.empty", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private void checkContextRoot(GeronimoWebRoot root, DomElementAnnotationHolder holder) {
        GenericDomValue<String> value = root.getContextRoot();
        if ("".equals(value.getValue())) {
            holder.createProblem(value, GeronimoBundle.getText("Error.context.root.empty", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @NotNull
    public String getShortName() {
        String string = GeronimoBundle.getText("GeronimoIntegration.name", new Object[0]);
        if (string == null) {
            GeronimoInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/geronimo/server/GeronimoInspection", "getShortName"));
    }
}

