/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.javascript.flex.FlexPropertiesSupport;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ReferenceSupport;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeNameValuePairImpl;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.validation.fixes.ActionScriptCreateClassOrInterfaceFix;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexAttributeReferenceProvider
extends PsiReferenceProvider {
    @NonNls
    private static final String BUNDLE_ATTR_NAME = "bundle";
    private static final FlexPropertiesSupport.PropertyReferenceInfoProvider<JSAttributeNameValuePairImpl> ourPropertyInfoProvider = new FlexPropertiesSupport.PropertyReferenceInfoProvider<JSAttributeNameValuePairImpl>(){

        @Override
        @Nullable
        public TextRange getReferenceRange(JSAttributeNameValuePairImpl element) {
            return FlexAttributeReferenceProvider.getValueRange(element);
        }

        @Override
        public String getBundleName(JSAttributeNameValuePairImpl element) {
            JSAttributeNameValuePair pair = ((JSAttribute)element.getParent()).getValueByName(FlexAttributeReferenceProvider.BUNDLE_ATTR_NAME);
            return pair != null ? pair.getSimpleValue() : null;
        }

        @Override
        public boolean isSoft(JSAttributeNameValuePairImpl element) {
            return false;
        }
    };
    private static final Key<JSReferenceSet> METADATA_REFERENCE_KEY = Key.create((String)"com.intellij.lang.javascript.METADATA_REFERENCE_KEY");
    private static final FlexPropertiesSupport.BundleReferenceInfoProvider<JSAttributeNameValuePairImpl> ourBundleInfoProvider = new FlexPropertiesSupport.BundleReferenceInfoProvider<JSAttributeNameValuePairImpl>(){

        @Override
        public TextRange getReferenceRange(JSAttributeNameValuePairImpl element) {
            return FlexAttributeReferenceProvider.getValueRange(element);
        }

        @Override
        public boolean isSoft(JSAttributeNameValuePairImpl element) {
            return false;
        }
    };

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            FlexAttributeReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            FlexAttributeReferenceProvider.$$$reportNull$$$0(1);
        }
        JSAttributeNameValuePairImpl nameValuePair = (JSAttributeNameValuePairImpl)element;
        String name = nameValuePair.getName();
        PsiReference[] psiReferenceArray = FlexAttributeReferenceProvider.valueRefs(nameValuePair, name);
        if (psiReferenceArray == null) {
            FlexAttributeReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    public static PsiReference[] valueRefs(JSAttributeNameValuePairImpl element, String name) {
        String baseClassFqns;
        XmlAttributeDescriptor attributeDescriptor;
        JSAttributeImpl jsAttribute = (JSAttributeImpl)element.getParent();
        XmlElementDescriptor descriptor = jsAttribute.getBackedDescriptor();
        XmlAttributeDescriptor xmlAttributeDescriptor = attributeDescriptor = descriptor == null ? null : descriptor.getAttributeDescriptor(StringUtil.notNullize((String)name, (String)"_DEFAULT_"), null);
        if (name == null) {
            return FlexAttributeReferenceProvider.getDefaultPropertyRefs(element, attributeDescriptor);
        }
        String string = baseClassFqns = attributeDescriptor == null ? null : attributeDescriptor.getDefaultValue();
        if (baseClassFqns != null) {
            return FlexAttributeReferenceProvider.getClassRefs(element, baseClassFqns);
        }
        if ("source".equals(name)) {
            return FlexAttributeReferenceProvider.getPathRefsCheckingParent(element);
        }
        if ("key".equals(name)) {
            return FlexAttributeReferenceProvider.getPropertyRefsCheckingParent(element);
        }
        if (BUNDLE_ATTR_NAME.equals(name)) {
            return FlexAttributeReferenceProvider.getBundleRefsCheckingParent(element);
        }
        if (attributeDescriptor != null && attributeDescriptor.isEnumerated()) {
            String[] enumeratedValues = attributeDescriptor.getEnumeratedValues();
            TextRange range = FlexAttributeReferenceProvider.getValueRange(element);
            if (enumeratedValues != null && enumeratedValues.length > 0 && range != null) {
                return new PsiReference[]{new EnumeratedAttributeValueReference(element, range, enumeratedValues)};
            }
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference[] getClassRefs(@NotNull JSAttributeNameValuePairImpl element, @NotNull String baseClassFqns) {
        ASTNode valueNode;
        if (element == null) {
            FlexAttributeReferenceProvider.$$$reportNull$$$0(3);
        }
        if (baseClassFqns == null) {
            FlexAttributeReferenceProvider.$$$reportNull$$$0(4);
        }
        if ((valueNode = element.findValueNode()) != null) {
            int offsetInParent = valueNode.getPsi().getStartOffsetInParent();
            String text = valueNode.getText();
            JSReferenceSet referenceSet = (JSReferenceSet)element.getUserData(METADATA_REFERENCE_KEY);
            if (referenceSet == null) {
                referenceSet = new JSReferenceSet((PsiElement)element, "", offsetInParent, false, true);
                element.putUserData(METADATA_REFERENCE_KEY, (Object)referenceSet);
                referenceSet.setLocalQuickFixProvider((LocalQuickFixProvider)new ClassRefQuickFixProvider(element, referenceSet));
            }
            if (!"Object".equals(baseClassFqns)) {
                referenceSet.setBaseClassFqns((Collection)StringUtil.split((String)baseClassFqns, (String)","));
            }
            referenceSet.update(text, offsetInParent);
            return referenceSet.getReferences();
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference[] getDefaultPropertyRefs(JSAttributeNameValuePairImpl element, XmlAttributeDescriptor attributeDescriptor) {
        ASTNode valueNode;
        String baseClassFqn;
        String string = baseClassFqn = attributeDescriptor == null ? null : attributeDescriptor.getDefaultValue();
        if (baseClassFqn != null) {
            return FlexAttributeReferenceProvider.getClassRefs(element, baseClassFqn);
        }
        String parentName = ((JSAttribute)element.getParent()).getName();
        if ("ResourceBundle".equals(parentName)) {
            return FlexPropertiesSupport.getResourceBundleReference(element, ourBundleInfoProvider);
        }
        if ("Embed".equals(parentName)) {
            return FlexAttributeReferenceProvider.getPathRefs(element);
        }
        if ("DefaultProperty".equals(parentName) && (valueNode = element.findValueNode()) != null) {
            JSReferenceSet referenceSet = (JSReferenceSet)element.getUserData(METADATA_REFERENCE_KEY);
            if (referenceSet == null) {
                referenceSet = new JSReferenceSet((PsiElement)element, false);
                element.putUserData(METADATA_REFERENCE_KEY, (Object)referenceSet);
            }
            referenceSet.update(valueNode.getText(), valueNode.getPsi().getStartOffsetInParent());
            return referenceSet.getReferences();
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference[] getBundleRefsCheckingParent(JSAttributeNameValuePairImpl element) {
        JSAttribute attribute = (JSAttribute)element.getParent();
        String parentName = attribute.getName();
        if (!"Resource".equals(parentName)) {
            return PsiReference.EMPTY_ARRAY;
        }
        return FlexPropertiesSupport.getResourceBundleReference(element, ourBundleInfoProvider);
    }

    private static PsiReference[] getPropertyRefsCheckingParent(JSAttributeNameValuePairImpl element) {
        JSAttribute attribute = (JSAttribute)element.getParent();
        String parentName = attribute.getName();
        if (!"Resource".equals(parentName)) {
            return PsiReference.EMPTY_ARRAY;
        }
        return FlexPropertiesSupport.getPropertyReferences(element, ourPropertyInfoProvider);
    }

    private static PsiReference[] getPathRefsCheckingParent(JSAttributeNameValuePairImpl element) {
        String parentName = ((JSAttribute)element.getParent()).getName();
        if (!"Embed".equals(parentName)) {
            return PsiReference.EMPTY_ARRAY;
        }
        return FlexAttributeReferenceProvider.getPathRefs(element);
    }

    private static PsiReference[] getPathRefs(JSAttributeNameValuePairImpl element) {
        ASTNode valueNode = element.findValueNode();
        if (valueNode != null && StringUtil.isQuotedString((String)valueNode.getText())) {
            return ReferenceSupport.getFileRefs((PsiElement)element, valueNode.getPsi(), valueNode.getPsi().getStartOffsetInParent() + 1, ReferenceSupport.LookupOptions.EMBEDDED_ASSET);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Nullable
    private static TextRange getValueRange(JSAttributeNameValuePairImpl element) {
        ASTNode valueNode = element.findValueNode();
        if (valueNode == null) {
            return null;
        }
        int valueStart = valueNode.getPsi().getStartOffsetInParent();
        int length = valueNode.getTextLength();
        return StringUtil.isQuotedString((String)valueNode.getText()) ? new TextRange(valueStart + 1, valueStart + length - 1) : new TextRange(valueStart, valueStart + length);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/flex/FlexAttributeReferenceProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassFqns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/flex/FlexAttributeReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClassRefs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EnumeratedAttributeValueReference
    implements PsiReference,
    EmptyResolveMessageProvider {
        private final JSAttributeNameValuePairImpl myElement;
        private final String[] myAllowedValues;
        private final String myValue;
        private final TextRange myRange;
        private final boolean myResolveOk;

        public EnumeratedAttributeValueReference(JSAttributeNameValuePairImpl element, TextRange range, String[] allowedValues) {
            this.myElement = element;
            this.myAllowedValues = allowedValues;
            this.myRange = range;
            ASTNode valueNode = element.getValueNode();
            this.myValue = valueNode == null ? "" : StringUtil.stripQuotesAroundValue((String)valueNode.getText());
            this.myResolveOk = ArrayUtil.contains((String)this.myValue, (String[])allowedValues);
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        public TextRange getRangeInElement() {
            return this.myRange;
        }

        public PsiElement resolve() {
            if (this.myResolveOk) {
                XmlAttributeDescriptor attributeDescriptor = ((JSAttributeImpl)this.myElement.getParent()).getBackedDescriptor().getAttributeDescriptor(this.myElement.getName(), null);
                return attributeDescriptor == null ? null : attributeDescriptor.getDeclaration();
            }
            return null;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myValue;
            if (string == null) {
                EnumeratedAttributeValueReference.$$$reportNull$$$0(0);
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            throw new IncorrectOperationException();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                EnumeratedAttributeValueReference.$$$reportNull$$$0(1);
            }
            throw new IncorrectOperationException();
        }

        public boolean isReferenceTo(PsiElement element) {
            return false;
        }

        @NotNull
        public Object[] getVariants() {
            if (this.myAllowedValues == null) {
                EnumeratedAttributeValueReference.$$$reportNull$$$0(2);
            }
            return this.myAllowedValues;
        }

        public boolean isSoft() {
            return false;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = XmlErrorMessages.message((String)"wrong.value", (Object[])new Object[]{"attribute"});
            if (string == null) {
                EnumeratedAttributeValueReference.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/flex/FlexAttributeReferenceProvider$EnumeratedAttributeValueReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/flex/FlexAttributeReferenceProvider$EnumeratedAttributeValueReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ClassRefQuickFixProvider
    implements LocalQuickFixProvider {
        private final JSAttributeNameValuePairImpl myElement;
        private final JSReferenceSet myReferenceSet;

        public ClassRefQuickFixProvider(JSAttributeNameValuePairImpl element, JSReferenceSet referenceSet) {
            this.myElement = element;
            this.myReferenceSet = referenceSet;
        }

        public LocalQuickFix[] getQuickFixes() {
            String fqn = this.myElement.getSimpleValue();
            if (fqn != null && ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(JavaScriptSupportLoader.JAVASCRIPT.getLanguage())).isIdentifier(StringUtil.getShortName((String)fqn), null)) {
                String[] baseClasses = this.myReferenceSet.getBaseClassFqns();
                String baseClass = null;
                if (baseClasses.length == 1 && !"Object".equals(baseClasses[0])) {
                    baseClass = baseClasses[0];
                } else if (baseClasses.length > 0) {
                    for (String aClass : baseClasses) {
                        if (ActionScriptClassResolver.findClassByQNameStatic(aClass, (PsiElement)this.myElement) == null) continue;
                        if (baseClass == null) {
                            baseClass = aClass;
                            continue;
                        }
                        baseClass = null;
                        break;
                    }
                }
                ActionScriptCreateClassOrInterfaceFix fix = new ActionScriptCreateClassOrInterfaceFix(fqn, baseClass, (PsiElement)this.myElement);
                fix.setCreatedClassFqnConsumer(fqn1 -> {
                    if (this.myElement.isValid() && !fqn1.equals(StringUtil.stripQuotesAroundValue((String)this.myElement.getValueNode().getText()))) {
                        char quoteChar;
                        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myElement)) {
                            return;
                        }
                        ASTNode oldValueNode = this.myElement.getValueNode();
                        String oldText = oldValueNode.getText();
                        char c = quoteChar = oldText.length() > 0 ? (char)oldText.charAt(0) : (char)'\"';
                        if (quoteChar != '\'' && quoteChar != '\"') {
                            quoteChar = '\"';
                        }
                        ASTNode newNode = JSChangeUtil.createExpressionFromText((Project)this.myElement.getProject(), (String)(quoteChar + fqn1 + quoteChar));
                        this.myElement.getNode().replaceChild(oldValueNode, newNode.getFirstChildNode());
                    }
                });
                return new LocalQuickFix[]{fix};
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
    }
}

