/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.javascript.flex.css.FlexCssUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.css.resolve.CssElementProcessor;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.impl.CssResolverImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssClassValueReference
extends PsiPolyVariantCachingReference
implements CssReference {
    private final PsiElement myElement;
    private final int myStart;
    private final int myEnd;

    public CssClassValueReference(@NotNull PsiElement element) {
        int length;
        if (element == null) {
            CssClassValueReference.$$$reportNull$$$0(0);
        }
        this.myElement = element;
        String value = CssClassValueReference.getValue(this.myElement);
        int n = length = value != null ? value.length() : 0;
        if (length == 0) {
            this.myStart = 0;
            this.myEnd = 0;
        } else if (element instanceof CssString || FlexCssUtil.inQuotes(this.myElement.getText())) {
            String text = this.myElement.getText();
            this.myStart = text.length() >= 2 && text.charAt(1) == '.' ? 2 : 1;
            this.myEnd = length + 1;
        } else {
            this.myStart = 0;
            this.myEnd = length;
        }
    }

    public static String getValue(PsiElement element) {
        if (element instanceof CssString) {
            return ((CssString)element).getValue();
        }
        String text = element.getText();
        if (FlexCssUtil.inQuotes(text)) {
            return text.substring(text.length() >= 2 && text.charAt(1) == '.' ? 2 : 1, text.length() - 1);
        }
        return text;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message((String)"invalid.css.class", (Object[])new Object[0]);
        if (string == null) {
            CssClassValueReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return new TextRange(this.myStart, this.myEnd);
    }

    @NotNull
    public String getCanonicalText() {
        String value = CssClassValueReference.getValue(this.myElement);
        String string = value != null ? value : "";
        if (string == null) {
            CssClassValueReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
        assert (manipulator != null);
        return manipulator.handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CssClassValueReference.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        MyCandidatesProcessor processor = new MyCandidatesProcessor();
        this.processStyles(processor);
        Object[] objectArray = processor.myStyleNames.toArray();
        if (objectArray == null) {
            CssClassValueReference.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    @NotNull
    protected ResolveResult[] resolveInner(boolean incompleteCode, @NotNull PsiFile containingFile) {
        String value;
        if (containingFile == null) {
            CssClassValueReference.$$$reportNull$$$0(5);
        }
        if ((value = CssClassValueReference.getValue(this.myElement)) == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                CssClassValueReference.$$$reportNull$$$0(6);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        MyResolveProcessor processor = new MyResolveProcessor(value);
        this.processStyles(processor);
        if (processor.myTargets.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                CssClassValueReference.$$$reportNull$$$0(7);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)processor.myTargets);
        if (resolveResultArray == null) {
            CssClassValueReference.$$$reportNull$$$0(8);
        }
        return resolveResultArray;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof CssSelectorSuffix) {
            String text = element.getText();
            return text != null && !text.isEmpty() && text.substring(1).equals(CssClassValueReference.getValue(this.myElement));
        }
        return false;
    }

    public boolean isSoft() {
        return true;
    }

    private void processStyles(CssElementProcessor processor) {
        PsiFile context;
        PsiFile file = this.myElement.getContainingFile();
        if (!(file instanceof XmlFile) && (context = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file)) instanceof XmlFile) {
            file = (XmlFile)context;
        }
        if (file instanceof XmlFile) {
            CssResolveManager.getInstance().getNewResolver().processOneFile((XmlFile)file, processor, true);
        } else if (file instanceof StylesheetFile) {
            CssClassValueReference.processOneStylesheetFile((StylesheetFile)file, processor);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null) {
            CssResolverImpl.processStyles((Module)module, (CssElementProcessor)processor, (PsiFile)file);
        }
    }

    private static void processOneStylesheetFile(@NotNull StylesheetFile file, @NotNull CssElementProcessor processor) {
        CssStylesheet stylesheet;
        if (file == null) {
            CssClassValueReference.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            CssClassValueReference.$$$reportNull$$$0(10);
        }
        if ((stylesheet = file.getStylesheet()) != null) {
            for (CssRuleset ruleset : stylesheet.getRulesets()) {
                processor.process(ruleset);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/flex/css/CssClassValueReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/flex/css/CssClassValueReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveInner";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processOneStylesheetFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class MyCssElementProcessor
    extends CssElementProcessor {
        private MyCssElementProcessor() {
        }

        public boolean process(@NotNull CssRuleset ruleset) {
            if (ruleset == null) {
                MyCssElementProcessor.$$$reportNull$$$0(0);
            }
            for (CssSelector selector : ruleset.getSelectors()) {
                for (PsiElement child : selector.getChildren()) {
                    if (!(child instanceof CssSimpleSelector)) continue;
                    for (CssSelectorSuffix selectorSuffix : ((CssSimpleSelector)child).getSelectorSuffixes()) {
                        String text = selectorSuffix.getText();
                        if (text == null || text.isEmpty() || text.charAt(0) != '.') continue;
                        this.handleSelector(selectorSuffix, text.substring(1));
                        ProgressIndicatorProvider.checkCanceled();
                    }
                }
            }
            return true;
        }

        protected abstract void handleSelector(@NotNull CssSelectorSuffix var1, @NotNull String var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleset", "com/intellij/javascript/flex/css/CssClassValueReference$MyCssElementProcessor", "process"));
        }
    }

    private static class MyResolveProcessor
    extends MyCssElementProcessor {
        private final String myReferenceText;
        private final Set<CssSelectorSuffix> myTargets;

        private MyResolveProcessor(@NotNull String referenceText) {
            if (referenceText == null) {
                MyResolveProcessor.$$$reportNull$$$0(0);
            }
            this.myTargets = ContainerUtil.newLinkedHashSet();
            this.myReferenceText = referenceText;
        }

        @Override
        protected void handleSelector(@NotNull CssSelectorSuffix selectorSuffix, @NotNull String text) {
            if (selectorSuffix == null) {
                MyResolveProcessor.$$$reportNull$$$0(1);
            }
            if (text == null) {
                MyResolveProcessor.$$$reportNull$$$0(2);
            }
            if (text.equals(this.myReferenceText)) {
                this.myTargets.add(selectorSuffix);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectorSuffix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/flex/css/CssClassValueReference$MyResolveProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyCandidatesProcessor
    extends MyCssElementProcessor {
        Set<String> myStyleNames = ContainerUtil.newLinkedHashSet();

        private MyCandidatesProcessor() {
        }

        @Override
        protected void handleSelector(@NotNull CssSelectorSuffix selectorSuffix, @NotNull String text) {
            if (selectorSuffix == null) {
                MyCandidatesProcessor.$$$reportNull$$$0(0);
            }
            if (text == null) {
                MyCandidatesProcessor.$$$reportNull$$$0(1);
            }
            this.myStyleNames.add(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectorSuffix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/flex/css/CssClassValueReference$MyCandidatesProcessor";
            objectArray[2] = "handleSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

