/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class RenameMoveUtils {
    private static final Key<String> oldPackageKey = Key.create((String)"old.package.key");

    private RenameMoveUtils() {
    }

    public static void updateFileWithChangedName(JSFile file) throws IncorrectOperationException {
        VirtualFile virtualFile = file.getVirtualFile();
        if (!ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex().isInSource(virtualFile)) {
            return;
        }
        JSQualifiedNamedElement element = JSPsiImplUtils.findQualifiedElement((JSFile)file);
        if (element != null) {
            String shortName = virtualFile.getNameWithoutExtension();
            JSFunction constructor = null;
            if (element instanceof JSClass) {
                constructor = ((JSClass)element).getConstructor();
            }
            element.setName(shortName);
            if (constructor != null) {
                constructor.setName(shortName);
            }
        }
    }

    @Nullable
    public static JSPackageStatement updatePackageStatement(JSFile file) {
        String expectedPackageNameFromFile;
        String s;
        JSPackageStatement packageStatement = JSPsiImplUtils.findPackageStatement((JSFile)file);
        if (packageStatement != null && JSPsiImplUtils.differentPackageName((String)(s = packageStatement.getQualifiedName()), (String)(expectedPackageNameFromFile = JSResolveUtil.getExpectedPackageNameFromFile((VirtualFile)file.getVirtualFile(), (Project)file.getProject())))) {
            packageStatement.setQualifiedName(expectedPackageNameFromFile);
        }
        return packageStatement;
    }

    public static void updateMovedFile(JSFile file) throws IncorrectOperationException {
        RenameMoveUtils.updateMovedFile(file, (UserDataHolder)file);
    }

    public static void updateMovedFile(JSFile file, UserDataHolder dataHolder) throws IncorrectOperationException {
        JSPackageStatement statement = RenameMoveUtils.updatePackageStatement(file);
        if (statement != null) {
            String qName = statement.getQualifiedName();
            String oldPackageKey = (String)dataHolder.getUserData(RenameMoveUtils.oldPackageKey);
            file.putUserData(RenameMoveUtils.oldPackageKey, null);
            if (JSPsiImplUtils.differentPackageName((String)oldPackageKey, (String)qName) && !JSPsiImplUtils.isEmpty((String)oldPackageKey)) {
                ASTNode node;
                statement.addAfter(JSChangeUtil.createStatementFromText((Project)file.getProject(), (String)("import " + oldPackageKey + ".*;"), (JSLanguageDialect)((JSLanguageDialect)file.getLanguage())).getPsi(), (node = statement.getNode().findChildByType(JSTokenTypes.LBRACE)) != null ? node.getPsi() : null);
            }
        }
    }

    public static void prepareMovedFile(JSFile file) {
        RenameMoveUtils.prepareMovedFile(file, (UserDataHolder)file);
    }

    public static void prepareMovedFile(JSFile file, UserDataHolder dataHolder) {
        RenameMoveUtils.saveOldPackageNameCheckingRefs(file, dataHolder);
    }

    private static void saveOldPackageNameCheckingRefs(JSFile file, UserDataHolder dataHolder) {
        JSPackageStatement statement = JSPsiImplUtils.findPackageStatement((JSFile)file);
        if (statement == null) {
            return;
        }
        String oldPackageName = statement.getQualifiedName();
        Ref hasReferencesToOldPackage = new Ref((Object)Boolean.FALSE);
        RenameMoveUtils.checkIfFileHasReferencesToOldPackage(file, oldPackageName, (Ref<Boolean>)hasReferencesToOldPackage);
        if (((Boolean)hasReferencesToOldPackage.get()).booleanValue()) {
            dataHolder.putUserData(oldPackageKey, (Object)oldPackageName);
        }
    }

    private static void checkIfFileHasReferencesToOldPackage(JSFile file, final String oldPackageName, final Ref<Boolean> hasReferencesToOldPackage) {
        final PsiFile realFile = RenameMoveUtils.getRealFile((PsiFile)file);
        file.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (((Boolean)hasReferencesToOldPackage.get()).booleanValue()) {
                    return;
                }
                for (PsiReference el : element.getReferences()) {
                    if (el instanceof PsiPolyVariantReference) {
                        ResolveProcessor.setSkipPackageLocalCheck((PsiElement)element, (boolean)true);
                        for (ResolveResult r : ((PsiPolyVariantReference)el).multiResolve(false)) {
                            this.checkIfResolveBelongsToPackage(r.getElement(), (Ref<Boolean>)hasReferencesToOldPackage);
                        }
                        ResolveProcessor.setSkipPackageLocalCheck((PsiElement)element, (boolean)false);
                        continue;
                    }
                    PsiElement resolve = el.resolve();
                    if (resolve == null) continue;
                    this.checkIfResolveBelongsToPackage(resolve, (Ref<Boolean>)hasReferencesToOldPackage);
                }
                if (((Boolean)hasReferencesToOldPackage.get()).booleanValue()) {
                    return;
                }
                super.visitElement(element);
            }

            private void checkIfResolveBelongsToPackage(PsiElement resolve, Ref<Boolean> hasReferencesToOldPackage2) {
                PsiFile containingFile = RenameMoveUtils.getRealFile(resolve.getContainingFile());
                if (containingFile != realFile && containingFile != null && !JSPsiImplUtils.differentPackageName((String)JSResolveUtil.getExpectedPackageNameFromFile((VirtualFile)containingFile.getVirtualFile(), (Project)containingFile.getProject()), (String)oldPackageName) && !JSPsiImplUtils.isEmpty((String)oldPackageName)) {
                    hasReferencesToOldPackage2.set((Object)Boolean.TRUE);
                }
            }
        });
    }

    private static PsiFile getRealFile(PsiFile realFile) {
        PsiElement context;
        PsiElement psiElement = context = realFile != null ? realFile.getContext() : null;
        if (context != null) {
            realFile = context.getContainingFile();
        }
        return realFile;
    }

    public static void prepareMovedMxmlFile(XmlFile xmlFile, @Nullable XmlFile originalElement) {
        RenameMoveUtils.prepareMovedMxmlFile(xmlFile, originalElement, (UserDataHolder)xmlFile);
    }

    public static void prepareMovedMxmlFile(XmlFile xmlFile, @Nullable XmlFile originalElement, UserDataHolder dataHolder) {
        VirtualFile file = (originalElement != null ? originalElement : xmlFile).getVirtualFile();
        final String expectedPackageNameFromFile = JSResolveUtil.getExpectedPackageNameFromFile((VirtualFile)file, (Project)xmlFile.getProject());
        final Ref hasReferencesToOldPackage = new Ref((Object)Boolean.FALSE);
        xmlFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (((Boolean)hasReferencesToOldPackage.get()).booleanValue()) {
                    return;
                }
                if (element instanceof PsiLanguageInjectionHost) {
                    InjectedLanguageUtil.enumerate((PsiElement)element, (PsiLanguageInjectionHost.InjectedPsiVisitor)new JSResolveUtil.JSInjectedFilesVisitor(){

                        protected void process(JSFile file) {
                            RenameMoveUtils.checkIfFileHasReferencesToOldPackage(file, expectedPackageNameFromFile, (Ref<Boolean>)hasReferencesToOldPackage);
                        }
                    });
                }
                super.visitElement(element);
            }
        });
        if (((Boolean)hasReferencesToOldPackage.get()).booleanValue()) {
            dataHolder.putUserData(oldPackageKey, (Object)expectedPackageNameFromFile);
        }
    }

    public static void updateMovedMxmlFile(XmlFile xmlFile) {
        RenameMoveUtils.updateMovedMxmlFile(xmlFile, (UserDataHolder)xmlFile);
    }

    public static void updateMovedMxmlFile(XmlFile xmlFile, UserDataHolder dataHolder) {
        String oldPackage = (String)dataHolder.getUserData(oldPackageKey);
        xmlFile.putUserData(oldPackageKey, null);
        String newPackage = JSResolveUtil.getExpectedPackageNameFromFile((VirtualFile)xmlFile.getVirtualFile(), (Project)xmlFile.getProject());
        if (JSPsiImplUtils.differentPackageName((String)oldPackage, (String)newPackage) && !JSPsiImplUtils.isEmpty((String)oldPackage)) {
            String fqn = oldPackage + ".*";
            for (JSClass c : XmlBackedJSClassImpl.getClasses((XmlFile)xmlFile)) {
                ImportUtils.doImport((PsiElement)c, (String)fqn, (boolean)true);
            }
        }
    }
}

