/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.resolve;

import com.intellij.javascript.flex.mxml.MxmlJSClassProvider;
import com.intellij.javascript.flex.resolve.SwcCatalogXmlUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssString;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class FlexResolveHelper
implements JSResolveHelper {
    @Nullable
    public PsiElement findClassByQName(String link, Project project, String className, GlobalSearchScope scope) {
        Ref result = new Ref();
        String expectedPackage = link.equals(className) ? "" : link.substring(0, link.length() - className.length() - 1);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        PsiManager manager = PsiManager.getInstance((Project)project);
        Processor processor = file -> {
            VirtualFile rootForFile = projectFileIndex.getSourceRootForFile(file);
            if (rootForFile == null) {
                return true;
            }
            if (expectedPackage.equals(VfsUtilCore.getRelativePath((VirtualFile)file.getParent(), (VirtualFile)rootForFile, (char)'.'))) {
                XmlBackedJSClass clazz;
                PsiFile psiFile = manager.findFile(file);
                XmlBackedJSClass xmlBackedJSClass = clazz = psiFile instanceof XmlFile ? XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)psiFile)) : null;
                if (clazz != null) {
                    result.set((Object)clazz);
                    return false;
                }
            }
            return true;
        };
        Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)(className + ".mxml"), (GlobalSearchScope)scope);
        ContainerUtil.process((Iterable)files, (Processor)processor);
        if (result.isNull()) {
            files = FilenameIndex.getVirtualFilesByName((Project)project, (String)(className + ".fxg"), (GlobalSearchScope)scope);
            ContainerUtil.process((Iterable)files, (Processor)processor);
        }
        return (PsiElement)result.get();
    }

    public boolean importClass(final PsiScopeProcessor processor, PsiNamedElement file) {
        boolean completion;
        if (file instanceof JSFunction) {
            return true;
        }
        if (file instanceof XmlBackedJSClassImpl && !FlexResolveHelper.processInlineComponentsInScope((XmlBackedJSClassImpl)file, (Processor<XmlBackedJSClass>)((Processor)inlineComponent -> processor.execute((PsiElement)inlineComponent, ResolveState.initial())))) {
            return false;
        }
        String packageQualifierText = JSResolveUtil.findPackageStatementQualifier((PsiElement)file);
        final Project project = file.getProject();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)file);
        MxmlAndFxgFilesProcessor filesProcessor = new MxmlAndFxgFilesProcessor(){
            final PsiManager manager;
            {
                this.manager = PsiManager.getInstance((Project)project);
            }

            @Override
            public void addDependency(PsiDirectory directory) {
            }

            @Override
            public boolean processFile(VirtualFile file, VirtualFile root) {
                PsiFile xmlFile = this.manager.findFile(file);
                if (!(xmlFile instanceof XmlFile)) {
                    return true;
                }
                return processor.execute((PsiElement)XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)xmlFile)), ResolveState.initial());
            }
        };
        PsiFile containingFile = file.getContainingFile();
        boolean bl = completion = containingFile.getOriginalFile() != containingFile;
        if (completion) {
            return FlexResolveHelper.processAllMxmlAndFxgFiles(scope, project, filesProcessor, null);
        }
        if (packageQualifierText != null && packageQualifierText.length() > 0 && !FlexResolveHelper.processMxmlAndFxgFilesInPackage(scope, project, packageQualifierText, filesProcessor)) {
            return false;
        }
        return FlexResolveHelper.processMxmlAndFxgFilesInPackage(scope, project, "", filesProcessor);
    }

    public boolean processPackage(String packageQualifierText, String resolvedName, Processor<VirtualFile> processor, GlobalSearchScope globalSearchScope, Project project) {
        for (VirtualFile vfile : DirectoryIndex.getInstance((Project)project).getDirectoriesByPackageName(packageQualifierText, globalSearchScope.isSearchInLibraries())) {
            VirtualFile fileForJar;
            if (!globalSearchScope.contains(vfile) || vfile.getFileSystem() instanceof JarFileSystem && (fileForJar = JarFileSystem.getInstance().getVirtualFileForJar(vfile)) != null && !"swc".equalsIgnoreCase(fileForJar.getExtension()) && !"ane".equalsIgnoreCase(fileForJar.getExtension())) continue;
            if (resolvedName != null) {
                VirtualFile child = vfile.findChild(resolvedName);
                if (child == null && (child = vfile.findChild(resolvedName + ".mxml")) == null) {
                    child = vfile.findChild(resolvedName + ".fxg");
                }
                if (child == null || processor.process((Object)child)) continue;
                return false;
            }
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
            for (VirtualFile child : vfile.getChildren()) {
                if (index.isExcluded(child) || processor.process((Object)child)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isAdequatePlaceForImport(PsiElement place) {
        return place instanceof CssString;
    }

    public boolean resolveTypeNameUsingImports(ResolveProcessor resolveProcessor, PsiNamedElement parent) {
        if (parent instanceof XmlBackedJSClassImpl) {
            return FlexResolveHelper.processInlineComponentsInScope((XmlBackedJSClassImpl)parent, (Processor<XmlBackedJSClass>)((Processor)inlineComponent -> resolveProcessor.execute((PsiElement)inlineComponent, ResolveState.initial())));
        }
        return true;
    }

    public long getResolveResultTimestamp(PsiElement candidate) {
        return SwcCatalogXmlUtil.getTimestampFromCatalogXml(candidate);
    }

    public JSReferenceExpression bindReferenceToElement(JSReferenceExpression ref, String qName, String newName, boolean justMakeQualified, PsiNamedElement element) {
        PsiFile file;
        if (qName != null && (element instanceof XmlBackedJSClass || element instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)((PsiFile)element)) || (file = element.getContainingFile()) == null || file.getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4))) {
            boolean doImport;
            boolean qualify;
            if (justMakeQualified || ref.getParent() instanceof JSImportStatement || element instanceof PsiDirectoryContainer || ref.getParent() instanceof JSReferenceListMember && ref.getContainingFile().getContext() instanceof XmlAttributeValue) {
                qualify = true;
                doImport = false;
            } else {
                doImport = JSImportHandlingUtil.evaluateImportStatus((String)newName, (PsiElement)ref) == JSImportHandlingUtil.ImportStatus.ABSENT && JSImportHandlingUtil.evaluateImportStatus((String)ref.getReferencedName(), (PsiElement)ref) == JSImportHandlingUtil.ImportStatus.ABSENT;
                JSQualifiedNamedElement qualifiedElement = null;
                if (element instanceof JSQualifiedNamedElement) {
                    qualifiedElement = (JSQualifiedNamedElement)element;
                } else if (element instanceof JSFile) {
                    qualifiedElement = JSPsiImplUtils.findQualifiedElement((JSFile)((JSFile)element));
                } else if (element instanceof XmlFile) {
                    qualifiedElement = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)element));
                }
                assert (qualifiedElement != null) : qualifiedElement.getClass();
                qualify = JSResolveUtil.shortReferenceIsAmbiguousOrUnequal((String)newName, (PsiElement)ref, (String)qualifiedElement.getQualifiedName(), null);
            }
            if (qualify) {
                ASTNode newChild = JSChangeUtil.createExpressionFromText((Project)ref.getProject(), (String)qName);
                ref.getParent().getNode().replaceChild(ref.getNode(), newChild);
                ref = (JSReferenceExpression)newChild.getPsi();
            }
            if (doImport && qName.indexOf(46) != -1 && !StringUtil.getPackageName((String)qName).equals(JSResolveUtil.getPackageNameFromPlace((PsiElement)ref))) {
                SmartPsiElementPointer refPointer = SmartPointerManager.getInstance((Project)ref.getProject()).createSmartPsiElementPointer((PsiElement)ref);
                ImportUtils.doImport((PsiElement)ref, (String)qName, (boolean)false);
                ref = (JSReferenceExpression)refPointer.getElement();
            }
        }
        return ref;
    }

    public boolean isStrictTypeContext(PsiElement element) {
        return true;
    }

    public static boolean processAllMxmlAndFxgFiles(GlobalSearchScope scope, Project project, MxmlAndFxgFilesProcessor processor, String nameHint) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (VirtualFile root : ProjectRootManager.getInstance((Project)project).getContentSourceRoots()) {
            boolean b = projectFileIndex.iterateContentUnderDirectory(root, fileOrDir -> !scope.contains(fileOrDir) || !JavaScriptSupportLoader.isMxmlOrFxgFile((VirtualFile)fileOrDir) || nameHint != null && !nameHint.equals(fileOrDir.getNameWithoutExtension()) || processor.processFile(fileOrDir, root));
            if (b) continue;
            return false;
        }
        return true;
    }

    private static boolean processMxmlAndFxgFilesInPackage(GlobalSearchScope scope, Project project, String packageName, MxmlAndFxgFilesProcessor processor) {
        Query packageFiles = DirectoryIndex.getInstance((Project)project).getDirectoriesByPackageName(packageName, scope.isSearchInLibraries());
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile packageFile : packageFiles) {
            PsiDirectory dir;
            if (!scope.contains(packageFile) || (dir = manager.findDirectory(packageFile)) == null) continue;
            processor.addDependency(dir);
            for (PsiFile file : dir.getFiles()) {
                if (!JavaScriptSupportLoader.isMxmlOrFxgFile((PsiFile)file) || processor.processFile(file.getVirtualFile(), null)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean mxmlPackageExists(String packageName, Project project, GlobalSearchScope scope) {
        return !FlexResolveHelper.processMxmlAndFxgFilesInPackage(scope, project, packageName, new MxmlAndFxgFilesProcessor(){

            @Override
            public void addDependency(PsiDirectory directory) {
            }

            @Override
            public boolean processFile(VirtualFile file, VirtualFile root) {
                return false;
            }
        });
    }

    private static boolean processInlineComponentsInScope(XmlBackedJSClassImpl context, Processor<XmlBackedJSClass> processor) {
        XmlTag rootTag = ((XmlFile)context.getContainingFile()).getDocument().getRootTag();
        boolean recursive = context.getParent().getParentTag() != null && XmlBackedJSClassImpl.isComponentTag((XmlTag)context.getParent().getParentTag());
        Collection<XmlBackedJSClass> components = MxmlJSClassProvider.getChildInlineComponents(rootTag, recursive);
        return ContainerUtil.process(components, processor);
    }

    public static interface MxmlAndFxgFilesProcessor {
        public void addDependency(PsiDirectory var1);

        public boolean processFile(VirtualFile var1, VirtualFile var2);
    }
}

