/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class AddImportECMAScriptClassOrFunctionAction
implements HintAction,
QuestionAction,
LocalQuickFix {
    private final PsiPolyVariantReference myReference;
    private Editor myEditor;
    private boolean isAvailable;
    private boolean isAvailableCalculated;
    private long modificationCount = -1L;
    private String myText = "";
    private final boolean myUnambiguousTheFlyMode;

    public AddImportECMAScriptClassOrFunctionAction(Editor editor, PsiPolyVariantReference psiReference) {
        this(editor, psiReference, false);
    }

    public AddImportECMAScriptClassOrFunctionAction(Editor editor, PsiPolyVariantReference psiReference, boolean unambiguousTheFlyMode) {
        this.myReference = psiReference;
        this.myEditor = editor;
        this.myUnambiguousTheFlyMode = unambiguousTheFlyMode;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            AddImportECMAScriptClassOrFunctionAction.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
        PsiElement element = this.myReference.getElement();
        TextRange range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        HintManager.getInstance().showQuestionHint(editor, this.getText(), range.getStartOffset(), range.getEndOffset(), (QuestionAction)this);
        return true;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            AddImportECMAScriptClassOrFunctionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            AddImportECMAScriptClassOrFunctionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            AddImportECMAScriptClassOrFunctionAction.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            AddImportECMAScriptClassOrFunctionAction.$$$reportNull$$$0(4);
        }
        this.invoke(project, this.myEditor, descriptor.getPsiElement().getContainingFile());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddImportECMAScriptClassOrFunctionAction.$$$reportNull$$$0(5);
        }
        if (!this.myReference.getElement().isValid()) {
            return false;
        }
        long modL = this.myReference.getElement().getManager().getModificationTracker().getModificationCount();
        if (!this.isAvailableCalculated || modL != this.modificationCount) {
            ResolveResult[] results = this.myReference.multiResolve(false);
            boolean hasValidResult = false;
            for (ResolveResult r : results) {
                if (!r.isValidResult()) continue;
                hasValidResult = true;
                break;
            }
            if (!hasValidResult) {
                String text;
                Collection<JSQualifiedNamedElement> candidates = this.getCandidates(editor, file);
                this.isAvailableCalculated = true;
                boolean bl = this.isAvailable = candidates.size() > 0;
                if (this.isAvailable) {
                    JSQualifiedNamedElement element = candidates.iterator().next();
                    text = element.getQualifiedName() + "?";
                    if (candidates.size() > 1) {
                        text = text + " (multiple choices...)";
                    }
                    if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                        text = text + " Alt+Enter";
                    }
                } else {
                    text = "";
                }
                this.myText = text;
            } else {
                this.isAvailableCalculated = true;
                this.isAvailable = false;
                this.myText = "";
            }
            this.modificationCount = modL;
        }
        return this.isAvailable;
    }

    private Collection<JSQualifiedNamedElement> getCandidates(Editor editor, PsiFile file) {
        THashSet candidates;
        if (this.myReference instanceof JSReferenceExpression && ((JSReferenceExpression)this.myReference).getQualifier() == null) {
            Collection<JSQualifiedNamedElement> c = AddImportECMAScriptClassOrFunctionAction.getCandidates(editor, file, this.myReference.getCanonicalText());
            AddImportECMAScriptClassOrFunctionAction.filterCandidates(c);
            candidates = new THashSet(c, JSPsiImplUtils.QUALIFIED_NAME_HASHING_STRATEGY);
        } else {
            JSQualifiedNamedElement invalidResult = null;
            for (ResolveResult r : this.myReference.multiResolve(false)) {
                PsiElement element = r.getElement();
                if (!(element instanceof JSQualifiedNamedElement)) continue;
                invalidResult = (JSQualifiedNamedElement)element;
            }
            if (invalidResult != null) {
                if (this.myReference.getElement().getParent() instanceof JSNewExpression && invalidResult instanceof JSFunction && ((JSFunction)invalidResult).isConstructor()) {
                    invalidResult = (JSClass)invalidResult.getParent();
                }
                candidates = new SmartList();
                candidates.add(invalidResult);
            } else {
                candidates = Collections.emptyList();
            }
        }
        return candidates;
    }

    public static Collection<JSQualifiedNamedElement> getCandidates(Editor editor, PsiFile file, String name) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module != null) {
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile instanceof VirtualFileWindow) {
                virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
            }
            GlobalSearchScope searchScope = GlobalSearchScopes.projectProductionScope((Project)file.getProject()).contains(virtualFile) ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false) : JSResolveUtil.getResolveScope((PsiElement)file);
            return JSResolveUtil.findElementsByName((String)name, (Project)editor.getProject(), (GlobalSearchScope)searchScope);
        }
        return Collections.emptyList();
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file) {
        Collection<JSQualifiedNamedElement> candidates;
        if (project == null) {
            AddImportECMAScriptClassOrFunctionAction.$$$reportNull$$$0(6);
        }
        if ((candidates = this.getCandidates(editor, file)).isEmpty() || this.myUnambiguousTheFlyMode && candidates.size() != 1) {
            return;
        }
        if (candidates.size() > 1) {
            NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])candidates.toArray(new JSQualifiedNamedElement[candidates.size()])), (PsiElementListCellRenderer)new JSQualifiedNamedElementRenderer(), (String)JSBundle.message((String)"choose.class.to.import.title", (Object[])new Object[0]), (PsiElementProcessor)new PsiElementProcessor<JSQualifiedNamedElement>(){

                public boolean execute(@NotNull JSQualifiedNamedElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    CommandProcessor.getInstance().executeCommand(project, () -> {
                        if (element == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        AddImportECMAScriptClassOrFunctionAction.this.doImport(element.getQualifiedName());
                    }, "Import " + element.getQualifiedName(), (Object)this);
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "element";
                    objectArray2[1] = "com/intellij/lang/javascript/flex/AddImportECMAScriptClassOrFunctionAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "execute";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$execute$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).showInBestPositionFor(editor);
        } else {
            JSQualifiedNamedElement element = candidates.iterator().next();
            if (this.myUnambiguousTheFlyMode) {
                CommandProcessor.getInstance().runUndoTransparentAction(() -> this.doImport(element.getQualifiedName()));
            } else {
                CommandProcessor.getInstance().executeCommand(project, () -> this.doImport(element.getQualifiedName()), "Import " + element.getQualifiedName(), (Object)this);
            }
        }
    }

    private void doImport(String qName) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiElement element = this.myReference.getElement();
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
            ImportUtils.doImport((PsiElement)element, (String)qName, (boolean)true);
            PsiElement newElement = pointer.getElement();
            if (newElement != null) {
                ImportUtils.insertUseNamespaceIfNeeded((String)qName, (PsiElement)newElement);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean execute() {
        PsiFile containingFile = this.myReference.getElement().getContainingFile();
        this.invoke(containingFile.getProject(), this.myEditor, containingFile);
        return true;
    }

    private static void filterCandidates(Collection<JSQualifiedNamedElement> candidates) {
        Iterator<JSQualifiedNamedElement> i = candidates.iterator();
        while (i.hasNext()) {
            JSQualifiedNamedElement element = i.next();
            if (!element.getQualifiedName().contains(".")) {
                i.remove();
                continue;
            }
            if (!(element instanceof JSAttributeListOwner) || ((JSAttributeListOwner)element).getAttributeList().getAccessType() == JSAttributeList.AccessType.PUBLIC) continue;
            i.remove();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/AddImportECMAScriptClassOrFunctionAction";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/AddImportECMAScriptClassOrFunctionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

