/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.execution.ExecutionBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexMethodChooserDialog
extends DialogWrapper {
    private static final Comparator<JSFunction> METHOD_NAME_COMPARATOR = (method1, method2) -> method1.getName().compareToIgnoreCase(method2.getName());
    private final SortedListModel<JSFunction> myListModel = new SortedListModel(METHOD_NAME_COMPARATOR);
    private final JList myList = new JBList(this.myListModel);
    private final JPanel myWholePanel = new JPanel(new BorderLayout());

    public FlexMethodChooserDialog(JSClass clazz, Condition<JSFunction> filter, JComponent parent, @Nullable String initialSelection) {
        super((Component)parent, false);
        this.createList(clazz.getFunctions(), filter);
        this.myWholePanel.add(ScrollPaneFactory.createScrollPane((Component)this.myList));
        this.myList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSFunction method = (JSFunction)value;
                this.append(method.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/lang/javascript/flex/FlexMethodChooserDialog$1", "customizeCellRenderer"));
            }
        });
        this.myList.setSelectionMode(0);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                FlexMethodChooserDialog.this.close(0);
                return true;
            }
        }.installOn((Component)this.myList);
        int index = this.getIndexToSelect(clazz, initialSelection);
        if (index == -1) {
            this.myList.clearSelection();
        } else {
            ScrollingUtil.selectItem((JList)this.myList, (int)index);
        }
        this.setTitle(ExecutionBundle.message((String)"choose.test.method.dialog.title", (Object[])new Object[0]));
        this.init();
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FlexMethodChooserDialog.this.updateOkAction();
            }
        });
        this.updateOkAction();
    }

    private void updateOkAction() {
        this.setOKActionEnabled(this.myList.getSelectedIndex() != -1);
    }

    private int getIndexToSelect(JSClass clazz, @Nullable String methodName) {
        if (methodName == null) {
            return -1;
        }
        JSFunction method = clazz.findFunctionByName(methodName);
        if (method == null) {
            return -1;
        }
        return this.myListModel.indexOf((Object)method);
    }

    private void createList(JSFunction[] methods, Condition<JSFunction> filter) {
        for (JSFunction method : methods) {
            if (!filter.value((Object)method)) continue;
            this.myListModel.add((Object)method);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myWholePanel;
    }

    public JSFunction getSelectedMethod() {
        return (JSFunction)this.myList.getSelectedValue();
    }
}

