/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.newfile;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.actions.newfile.FlexMainStep;
import com.intellij.lang.javascript.flex.actions.newfile.NewFlexComponentAction;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.ui.newclass.CreateFlashClassWizard;
import com.intellij.lang.javascript.ui.newclass.CustomVariablesStep;
import com.intellij.lang.javascript.ui.newclass.WizardModel;
import com.intellij.lang.javascript.validation.fixes.ActionScriptCreateClassOrInterfaceFix;
import com.intellij.lang.javascript.validation.fixes.CreateClassParameters;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreateFlexComponentFix
extends ActionScriptCreateClassOrInterfaceFix {
    public static final Collection<String> FLEX_TEMPLATES_EXTENSIONS = Arrays.asList("mxml");
    @NonNls
    static final String FLEX3_COMPONENT_TEMPLATE_NAME = "Flex 3 Component";
    @NonNls
    static final String FLEX4_COMPONENT_TEMPLATE_NAME = "Flex 4 Component";

    public CreateFlexComponentFix(PsiDirectory dir) {
        super(dir);
    }

    public CreateFlexComponentFix(String classFqn, PsiElement element) {
        super(classFqn, null, element);
    }

    public boolean isAvailable(@NotNull Project project, PsiElement element, Editor editor, PsiFile file) {
        if (project == null) {
            CreateFlexComponentFix.$$$reportNull$$$0(0);
        }
        if (!super.isAvailable(project, element, editor, file)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return ModuleType.get((Module)module) == FlexModuleType.getInstance() && !FlexBuildConfigurationManager.getInstance(module).getActiveConfiguration().isPureAs();
    }

    public static String[] getAllowedBuiltInTemplates(Module module) {
        FlexBuildConfiguration c = FlexBuildConfigurationManager.getInstance(module).getActiveConfiguration();
        if (c.isPureAs()) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Sdk sdk = c.getSdk();
        if (sdk != null && StringUtil.compareVersionNumbers((String)sdk.getVersionString(), (String)"4") < 0) {
            return new String[]{FLEX3_COMPONENT_TEMPLATE_NAME};
        }
        return new String[]{FLEX4_COMPONENT_TEMPLATE_NAME};
    }

    protected CreateClassParameters createDialog(String templateName) {
        return CreateFlexComponentFix.createAndShow(templateName, this.myContext, this.myClassNameToCreate, this.myPackageName);
    }

    public static CreateClassParameters createAndShow(String templateName, PsiElement context, String classNameToCreate, String packageName) {
        WizardModel model = new WizardModel(context, true);
        FlexMainStep mainStep = new FlexMainStep(model, context, classNameToCreate, packageName, templateName);
        CustomVariablesStep customVariablesStep = new CustomVariablesStep(model);
        CreateFlashClassWizard w = new CreateFlashClassWizard(FlexBundle.message("new.flex.component.dialog.title", new Object[0]), context.getProject(), model, "New_MXML_Component_dialog", new AbstractWizardStepEx[]{mainStep, customVariablesStep});
        w.show();
        if (w.getExitCode() != 0) {
            return null;
        }
        return model;
    }

    protected void postProcess(@NotNull JSClass jsClass, String superClassFqn) {
        if (jsClass == null) {
            CreateFlexComponentFix.$$$reportNull$$$0(1);
        }
        CreateFlexComponentFix.fixParentComponent(jsClass, superClassFqn);
        jsClass.navigate(true);
    }

    public static void fixParentComponent(JSClass jsClass, String superClassFqn) {
        XmlTag tag = (XmlTag)jsClass.getParent();
        if (superClassFqn != null && superClassFqn.equals(tag.getName())) {
            ApplicationManager.getApplication().runWriteAction(() -> NewFlexComponentAction.setParentComponent((MxmlJSClass)jsClass, superClassFqn));
        }
    }

    @NotNull
    public String getName() {
        String string = FlexBundle.message("create.flex.component.intention.name", this.myClassNameToCreate);
        if (string == null) {
            CreateFlexComponentFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected List<FileTemplate> computeApplicableTemplates() {
        return CreateFlexComponentFix.computeApplicableTemplates(this.myContext);
    }

    public static List<FileTemplate> computeApplicableTemplates(PsiElement context) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        String[] allowedBuiltin = CreateFlexComponentFix.getAllowedBuiltInTemplates(module);
        return ContainerUtil.filter((Collection)ActionScriptCreateClassOrInterfaceFix.getApplicableTemplates(FLEX_TEMPLATES_EXTENSIONS, (Project)context.getProject()), fileTemplate -> {
            String name = fileTemplate.getName();
            return ArrayUtil.contains((String)name, (String[])allowedBuiltin) || !NewFlexComponentAction.isClassifierTemplate(name);
        });
    }

    protected String getTemplateForTest(boolean isInterface) {
        return this.computeApplicableTemplates().get(0).getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/actions/newfile/CreateFlexComponentFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/actions/newfile/CreateFlexComponentFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

